/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.lexer.PyFStringLiteralLexer;
import com.jetbrains.python.lexer.PyStringLiteralLexer;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyHighlighter
extends SyntaxHighlighterBase {
    private final Map<IElementType, TextAttributesKey> keys;
    private final LanguageLevel myLanguageLevel;
    public static final TextAttributesKey PY_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"PY.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey PY_BYTE_STRING = TextAttributesKey.createTextAttributesKey((String)"PY.STRING.B", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey PY_UNICODE_STRING = TextAttributesKey.createTextAttributesKey((String)"PY.STRING.U", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey PY_NUMBER = TextAttributesKey.createTextAttributesKey((String)"PY.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    static final TextAttributesKey PY_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"PY.OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    static final TextAttributesKey PY_PARENTHS = TextAttributesKey.createTextAttributesKey((String)"PY.PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    static final TextAttributesKey PY_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"PY.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    static final TextAttributesKey PY_BRACES = TextAttributesKey.createTextAttributesKey((String)"PY.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    static final TextAttributesKey PY_COMMA = TextAttributesKey.createTextAttributesKey((String)"PY.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    static final TextAttributesKey PY_DOT = TextAttributesKey.createTextAttributesKey((String)"PY.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey PY_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PY.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey PY_DOC_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PY.DOC_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
    public static final TextAttributesKey PY_DOC_COMMENT_TAG = TextAttributesKey.createTextAttributesKey((String)"PY.DOC_COMMENT_TAG", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG);
    public static final TextAttributesKey PY_DECORATOR = TextAttributesKey.createTextAttributesKey((String)"PY.DECORATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey PY_CLASS_DEFINITION = TextAttributesKey.createTextAttributesKey((String)"PY.CLASS_DEFINITION", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
    public static final TextAttributesKey PY_FUNC_DEFINITION = TextAttributesKey.createTextAttributesKey((String)"PY.FUNC_DEFINITION", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
    public static final TextAttributesKey PY_PREDEFINED_DEFINITION = TextAttributesKey.createTextAttributesKey((String)"PY.PREDEFINED_DEFINITION", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
    public static final TextAttributesKey PY_PREDEFINED_USAGE = TextAttributesKey.createTextAttributesKey((String)"PY.PREDEFINED_USAGE", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
    public static final TextAttributesKey PY_BUILTIN_NAME = TextAttributesKey.createTextAttributesKey((String)"PY.BUILTIN_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
    public static final TextAttributesKey PY_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"PY.PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
    public static final TextAttributesKey PY_SELF_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"PY.SELF_PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
    public static final TextAttributesKey PY_KEYWORD_ARGUMENT = TextAttributesKey.createTextAttributesKey((String)"PY.KEYWORD_ARGUMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
    public static final TextAttributesKey PY_FUNCTION_CALL = TextAttributesKey.createTextAttributesKey((String)"PY.FUNCTION_CALL", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_CALL);
    public static final TextAttributesKey PY_METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"PY.METHOD_CALL", (TextAttributesKey)PY_FUNCTION_CALL);
    public static final TextAttributesKey PY_ANNOTATION = TextAttributesKey.createTextAttributesKey((String)"PY.ANNOTATION", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey PY_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PY.VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey PY_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PY.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    public static final TextAttributesKey PY_FSTRING_FRAGMENT_BRACES = TextAttributesKey.createTextAttributesKey((String)"PY.FSTRING_FRAGMENT_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey PY_FSTRING_FRAGMENT_COLON = TextAttributesKey.createTextAttributesKey((String)"PY.FSTRING_FRAGMENT_COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey PY_FSTRING_FRAGMENT_TYPE_CONVERSION = TextAttributesKey.createTextAttributesKey((String)"PY.FSTRING_FRAGMENT_TYPE_CONVERSION", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);

    @NotNull
    public Lexer getHighlightingLexer() {
        LayeredLexer ret = new LayeredLexer((Lexer)this.createHighlightingLexer(this.myLanguageLevel));
        ret.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.SINGLE_QUOTED_STRING), new IElementType[]{PyTokenTypes.SINGLE_QUOTED_STRING});
        ret.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.SINGLE_QUOTED_UNICODE), new IElementType[]{PyTokenTypes.SINGLE_QUOTED_UNICODE});
        ret.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.TRIPLE_QUOTED_STRING), new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_STRING});
        ret.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.TRIPLE_QUOTED_UNICODE), new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_UNICODE});
        ret.registerLayer((Lexer)new PyFStringLiteralLexer(), new IElementType[]{PyTokenTypes.FSTRING_TEXT});
        LayeredLexer layeredLexer = ret;
        if (layeredLexer == null) {
            PyHighlighter.$$$reportNull$$$0(0);
        }
        return layeredLexer;
    }

    protected PythonHighlightingLexer createHighlightingLexer(LanguageLevel languageLevel) {
        return new PythonHighlightingLexer(this.myLanguageLevel);
    }

    public PyHighlighter(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
        this.keys = new HashMap<IElementType, TextAttributesKey>();
        PyHighlighter.fillMap(this.keys, (TokenSet)PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens(), (TextAttributesKey)PY_KEYWORD);
        PyHighlighter.fillMap(this.keys, (TokenSet)PyTokenTypes.OPERATIONS, (TextAttributesKey)PY_OPERATION_SIGN);
        this.keys.put(PyTokenTypes.INTEGER_LITERAL, PY_NUMBER);
        this.keys.put(PyTokenTypes.FLOAT_LITERAL, PY_NUMBER);
        this.keys.put(PyTokenTypes.IMAGINARY_LITERAL, PY_NUMBER);
        this.keys.put(PyTokenTypes.SINGLE_QUOTED_STRING, PY_BYTE_STRING);
        this.keys.put(PyTokenTypes.TRIPLE_QUOTED_STRING, PY_BYTE_STRING);
        this.keys.put(PyTokenTypes.SINGLE_QUOTED_UNICODE, PY_UNICODE_STRING);
        this.keys.put(PyTokenTypes.TRIPLE_QUOTED_UNICODE, PY_UNICODE_STRING);
        this.keys.put(PyTokenTypes.FSTRING_START, PY_UNICODE_STRING);
        this.keys.put(PyTokenTypes.FSTRING_END, PY_UNICODE_STRING);
        this.keys.put(PyTokenTypes.FSTRING_TEXT, PY_UNICODE_STRING);
        this.keys.put(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION, PY_FSTRING_FRAGMENT_TYPE_CONVERSION);
        this.keys.put(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START, PY_FSTRING_FRAGMENT_COLON);
        this.keys.put(PyTokenTypes.FSTRING_FRAGMENT_START, PY_FSTRING_FRAGMENT_BRACES);
        this.keys.put(PyTokenTypes.FSTRING_FRAGMENT_END, PY_FSTRING_FRAGMENT_BRACES);
        this.keys.put(PyTokenTypes.DOCSTRING, PY_DOC_COMMENT);
        this.keys.put(PyTokenTypes.LPAR, PY_PARENTHS);
        this.keys.put(PyTokenTypes.RPAR, PY_PARENTHS);
        this.keys.put(PyTokenTypes.LBRACE, PY_BRACES);
        this.keys.put(PyTokenTypes.RBRACE, PY_BRACES);
        this.keys.put(PyTokenTypes.LBRACKET, PY_BRACKETS);
        this.keys.put(PyTokenTypes.RBRACKET, PY_BRACKETS);
        this.keys.put(PyTokenTypes.COMMA, PY_COMMA);
        this.keys.put(PyTokenTypes.DOT, PY_DOT);
        this.keys.put(PyTokenTypes.END_OF_LINE_COMMENT, PY_LINE_COMMENT);
        this.keys.put(PyTokenTypes.BAD_CHARACTER, HighlighterColors.BAD_CHARACTER);
        this.keys.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, PY_VALID_STRING_ESCAPE);
        this.keys.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, PY_INVALID_STRING_ESCAPE);
        this.keys.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, PY_INVALID_STRING_ESCAPE);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = PyHighlighter.pack((TextAttributesKey)this.keys.get(tokenType));
        if (textAttributesKeyArray == null) {
            PyHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/highlighting/PyHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

