/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertDictCompQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("INTN.convert.dict.comp.to", new Object[0]);
        if (string == null) {
            ConvertDictCompQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.Family.convert.dict.comp.expression", new Object[0]);
        if (string == null) {
            ConvertDictCompQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project == null) {
            ConvertDictCompQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            ConvertDictCompQuickFix.$$$reportNull$$$0(3);
        }
        if (!LanguageLevel.forElement(element = descriptor2.getPsiElement()).isPy3K() && element instanceof PyDictCompExpression) {
            ConvertDictCompQuickFix.replaceComprehension(project, (PyDictCompExpression)element);
        }
    }

    private static void replaceComprehension(Project project, PyDictCompExpression expression) {
        if (expression.getResultExpression() instanceof PyKeyValueExpression) {
            PyKeyValueExpression keyValueExpression = (PyKeyValueExpression)expression.getResultExpression();
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            assert (keyValueExpression.getValue() != null);
            List<PyComprehensionComponent> components = expression.getComponents();
            StringBuilder replacement = new StringBuilder("dict([(" + keyValueExpression.getKey().getText() + ", " + keyValueExpression.getValue().getText() + ")");
            int slashNum = 1;
            for (PyComprehensionComponent component : components) {
                PyExpression test;
                if (component instanceof PyComprehensionForComponent) {
                    replacement.append("for ");
                    replacement.append(((PyComprehensionForComponent)component).getIteratorVariable().getText());
                    replacement.append(" in ");
                    replacement.append(((PyComprehensionForComponent)component).getIteratedList().getText());
                    replacement.append(" ");
                }
                if (component instanceof PyComprehensionIfComponent && (test = ((PyComprehensionIfComponent)component).getTest()) != null) {
                    replacement.append("if ");
                    replacement.append(test.getText());
                    replacement.append(" ");
                }
                for (int i = 0; i != slashNum; ++i) {
                    replacement.append("\t");
                }
                ++slashNum;
            }
            replacement.append("])");
            expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, replacement.toString()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ConvertDictCompQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ConvertDictCompQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

