/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyNamedParameterStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedParameterImpl
extends PyBaseElementImpl<PyNamedParameterStub>
implements PyNamedParameter {
    public PyNamedParameterImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyNamedParameterImpl(PyNamedParameterStub stub) {
        this(stub, (IStubElementType)PyElementTypes.NAMED_PARAMETER);
    }

    public PyNamedParameterImpl(PyNamedParameterStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiReferenceArray == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    public String getName() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameIdentifierNode();
        return node != null ? node.getText() : null;
    }

    public int getTextOffset() {
        ASTNode node = this.getNameIdentifierNode();
        return node == null ? super.getTextOffset() : node.getTextRange().getStartOffset();
    }

    @Nullable
    protected ASTNode getNameIdentifierNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode node = this.getNameIdentifierNode();
        return node == null ? null : node.getPsi();
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode oldNameIdentifier;
        if (name == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(1);
        }
        if ((oldNameIdentifier = this.getNameIdentifierNode()) != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            this.getNode().replaceChild(oldNameIdentifier, nameElement);
        }
        PyNamedParameterImpl pyNamedParameterImpl = this;
        if (pyNamedParameterImpl == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(2);
        }
        return pyNamedParameterImpl;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyNamedParameter(this);
    }

    @Override
    public boolean isPositionalContainer() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.isPositionalContainer();
        }
        return this.getNode().findChildByType((IElementType)PyTokenTypes.MULT) != null;
    }

    @Override
    public boolean isKeywordContainer() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.isKeywordContainer();
        }
        return this.getNode().findChildByType((IElementType)PyTokenTypes.EXP) != null;
    }

    @Override
    public boolean isKeywordOnly() {
        PyParameterList parameters2 = (PyParameterList)this.getStubOrPsiParentOfType(PyParameterList.class);
        if (parameters2 == null) {
            return false;
        }
        boolean varargSeen = false;
        for (PyParameter param : parameters2.getParameters()) {
            if (param == this) break;
            PyNamedParameter named = param.getAsNamed();
            if ((named == null || !named.isPositionalContainer()) && !(param instanceof PySingleStarParameter)) continue;
            varargSeen = true;
            break;
        }
        return varargSeen;
    }

    @Override
    @Nullable
    public PyExpression getDefaultValue() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null && stub.getDefaultValueText() == null) {
            return null;
        }
        ASTNode[] nodes = this.getNode().getChildren(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens());
        if (nodes.length > 0) {
            return (PyExpression)nodes[0].getPsi();
        }
        return null;
    }

    @Override
    public boolean hasDefaultValue() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.getDefaultValueText() != null;
        }
        return this.getDefaultValue() != null;
    }

    @Override
    @Nullable
    public String getDefaultValueText() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.getDefaultValueText();
        }
        return ParamHelper.getDefaultValueText(this.getDefaultValue());
    }

    @Override
    @NotNull
    public String getRepr(boolean includeDefaultValue, @Nullable TypeEvalContext context) {
        String string = PyCallableParameterImpl.psi(this).getPresentableText(includeDefaultValue, context);
        if (string == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public PyType getArgumentType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(4);
        }
        return PyCallableParameterImpl.psi(this).getArgumentType(context);
    }

    @Override
    public PyAnnotation getAnnotation() {
        return (PyAnnotation)this.getStubOrPsiChild(PyElementTypes.ANNOTATION);
    }

    @Override
    @Nullable
    public String getAnnotationValue() {
        return PyNamedParameterImpl.getAnnotationContentFromStubOrPsi(this);
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = PlatformIcons.PARAMETER_ICON;
        if (icon == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Override
    @NotNull
    public PyNamedParameter getAsNamed() {
        PyNamedParameterImpl pyNamedParameterImpl = this;
        if (pyNamedParameterImpl == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(6);
        }
        return pyNamedParameterImpl;
    }

    @Override
    @Nullable
    public PyTupleParameter getAsTuple() {
        return null;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyParameterList parameterList;
        PyFunction func;
        PsiElement parent;
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(7);
        }
        if (key == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(8);
        }
        if ((parent = this.getParentByStub()) instanceof PyParameterList && (func = (parameterList = (PyParameterList)parent).getContainingFunction()) != null) {
            PyType typeFromUsages;
            PyType type;
            PyExpression defaultValue;
            PyClass containingClass;
            for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
                Ref<PyType> resultRef = provider.getParameterType(this, func, context);
                if (resultRef == null) continue;
                return (PyType)resultRef.get();
            }
            if (this.isSelf() && (containingClass = func.getContainingClass()) != null) {
                PyFunction.Modifier modifier = func.getModifier();
                return new PyClassTypeImpl(containingClass, modifier == PyFunction.Modifier.CLASSMETHOD);
            }
            if (this.isKeywordContainer()) {
                return PyTypeUtil.toKeywordContainerType(this, null);
            }
            if (this.isPositionalContainer()) {
                return PyTypeUtil.toPositionalContainerType(this, null);
            }
            if (context.maySwitchToAST(this) && (defaultValue = this.getDefaultValue()) != null && (type = context.getType(defaultValue)) != null && !(type instanceof PyNoneType)) {
                if (type instanceof PyTupleType) {
                    return PyUnionType.createWeakType(type);
                }
                return type;
            }
            if (context.allowCallContext(this)) {
                ArrayList<PyType> types = new ArrayList<PyType>();
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                PyCallableParameter parameter = PyCallableParameterImpl.psi(this);
                PyNamedParameterImpl.processLocalCalls(func, (Processor<PyCallExpression>)((Processor)call -> {
                    if (context == null) {
                        PyNamedParameterImpl.$$$reportNull$$$0(20);
                    }
                    ((StreamEx)StreamEx.of(call.multiMapArguments(resolveContext)).flatCollection(mapping -> mapping.getMappedParameters().entrySet()).filter(entry -> parameter.equals(entry.getValue()))).map(Map.Entry::getKey).nonNull().map(context::getType).nonNull().forEach(types::add);
                    return true;
                }));
                if (!types.isEmpty()) {
                    return PyUnionType.createWeakType(PyUnionType.union(types));
                }
            }
            if (context.maySwitchToAST(this) && (typeFromUsages = this.getTypeFromUsages(context)) != null) {
                return typeFromUsages;
            }
        }
        return null;
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this);
    }

    @Nullable
    private PyType getTypeFromUsages(final @NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(9);
        }
        final LinkedHashSet<String> usedAttributes = new LinkedHashSet<String>();
        final ScopeOwner owner = ScopeUtil.getScopeOwner(this);
        String name = this.getName();
        final Ref parameterWasReassigned = Ref.create((Object)false);
        final Ref noneComparison = Ref.create((Object)false);
        if (owner != null && name != null) {
            owner.accept(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyElement(PyElement node) {
                    if (((Boolean)parameterWasReassigned.get()).booleanValue()) {
                        return;
                    }
                    if (node instanceof ScopeOwner && node != owner) {
                        return;
                    }
                    if (node instanceof PyQualifiedExpression) {
                        PyQualifiedExpression expr = (PyQualifiedExpression)node;
                        PyExpression qualifier = expr.getQualifier();
                        if (qualifier != null) {
                            PyExpression referencedExpr;
                            String attributeName = expr.getReferencedName();
                            PyExpression pyExpression = referencedExpr = node instanceof PyBinaryExpression && PyNames.isRightOperatorName(attributeName) ? ((PyBinaryExpression)node).getRightExpression() : qualifier;
                            if (attributeName != null && this.isReferenceToParameter((PsiElement)referencedExpr)) {
                                usedAttributes.add(attributeName);
                            }
                        } else if (this.isReferenceToParameter((PsiElement)expr)) {
                            StreamEx.of((Collection)PyNamedParameterImpl.this.getParametersByCallArgument((PsiElement)expr, context)).nonNull().map(parameter -> {
                                if (context == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return parameter.getType(context);
                            }).select(PyStructuralType.class).forEach(type -> usedAttributes.addAll(type.getAttributeNames()));
                        }
                    }
                    super.visitPyElement(node);
                }

                @Override
                public void visitPyIfStatement(PyIfStatement node) {
                    if (((Boolean)parameterWasReassigned.get()).booleanValue()) {
                        return;
                    }
                    PyExpression ifCondition = node.getIfPart().getCondition();
                    if (ifCondition != null) {
                        ifCondition.accept(this);
                    }
                    for (PyIfPart part : node.getElifParts()) {
                        PyExpression elseIfCondition = part.getCondition();
                        if (elseIfCondition == null) continue;
                        elseIfCondition.accept(this);
                    }
                }

                @Override
                public void visitPyCallExpression(PyCallExpression node) {
                    if (((Boolean)parameterWasReassigned.get()).booleanValue()) {
                        return;
                    }
                    Optional.ofNullable(node.getCallee()).filter(callee -> "len".equals(callee.getName()) && this.isReferenceToParameter((PsiElement)node.getArgument(0, PyReferenceExpression.class))).map(PsiElement::getReference).map(PsiReference::resolve).filter(element -> PyBuiltinCache.getInstance(element).isBuiltin((PsiElement)element)).ifPresent(callable -> usedAttributes.add("__len__"));
                    super.visitPyCallExpression(node);
                }

                @Override
                public void visitPyForStatement(PyForStatement node) {
                    if (((Boolean)parameterWasReassigned.get()).booleanValue()) {
                        return;
                    }
                    if (this.isReferenceToParameter((PsiElement)node.getForPart().getSource())) {
                        usedAttributes.add("__iter__");
                    }
                    super.visitPyForStatement(node);
                }

                @Override
                public void visitPyTargetExpression(PyTargetExpression node) {
                    if (((Boolean)parameterWasReassigned.get()).booleanValue()) {
                        return;
                    }
                    if (this.isReferenceToParameter(node)) {
                        parameterWasReassigned.set((Object)true);
                    } else {
                        super.visitPyTargetExpression(node);
                    }
                }

                @Override
                public void visitPyBinaryExpression(PyBinaryExpression node) {
                    super.visitPyBinaryExpression(node);
                    if (((Boolean)noneComparison.get()).booleanValue() || !node.isOperator("is") && !node.isOperator("isnot")) {
                        return;
                    }
                    PyExpression lhs = node.getLeftExpression();
                    PyExpression rhs = node.getRightExpression();
                    if (this.isReferenceToParameter((PsiElement)lhs) ^ this.isReferenceToParameter((PsiElement)rhs) && (lhs != null && context.getType(lhs) instanceof PyNoneType) ^ (rhs != null && context.getType(rhs) instanceof PyNoneType)) {
                        noneComparison.set((Object)true);
                    }
                }

                @Contract(value="null -> false")
                private boolean isReferenceToParameter(@Nullable PsiElement element) {
                    if (element == null) {
                        return false;
                    }
                    PsiReference reference = element.getReference();
                    return reference != null && reference.isReferenceTo((PsiElement)PyNamedParameterImpl.this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyNamedParameterImpl$1", "lambda$visitPyElement$0"));
                }
            });
        }
        if (!usedAttributes.isEmpty()) {
            PyStructuralType structuralType = new PyStructuralType(usedAttributes, true);
            return (Boolean)noneComparison.get() != false ? PyUnionType.union(structuralType, PyNoneType.INSTANCE) : structuralType;
        }
        return null;
    }

    @NotNull
    private List<PyCallableParameter> getParametersByCallArgument(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PyArgumentList argumentList;
        if (element == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(11);
        }
        if ((argumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class)) != null) {
            boolean elementIsArgument = false;
            for (PyExpression argument : argumentList.getArgumentExpressions()) {
                if (PyPsiUtils.flattenParens(argument) != element) continue;
                elementIsArgument = true;
                break;
            }
            PyCallExpression callExpression = argumentList.getCallExpression();
            if (elementIsArgument && callExpression != null) {
                PyReferenceExpression calleeReferenceExpr;
                PyExpression firstQualifier;
                PsiReference ref;
                PyExpression callee = callExpression.getCallee();
                if (callee instanceof PyReferenceExpression && (ref = (firstQualifier = PyPsiUtils.getFirstQualifier(calleeReferenceExpr = (PyReferenceExpression)callee)).getReference()) != null && ref.isReferenceTo((PsiElement)this)) {
                    List<PyCallableParameter> list = Collections.emptyList();
                    if (list == null) {
                        PyNamedParameterImpl.$$$reportNull$$$0(12);
                    }
                    return list;
                }
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                List<PyCallableParameter> list = callExpression.multiMapArguments(resolveContext).stream().flatMap(mapping -> mapping.getMappedParameters().entrySet().stream()).filter(entry -> {
                    if (element == null) {
                        PyNamedParameterImpl.$$$reportNull$$$0(19);
                    }
                    return entry.getKey() == element;
                }).map(Map.Entry::getValue).collect(Collectors.toList());
                if (list == null) {
                    PyNamedParameterImpl.$$$reportNull$$$0(13);
                }
                return list;
            }
        }
        List<PyCallableParameter> list = Collections.emptyList();
        if (list == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static void processLocalCalls(@NotNull PyFunction function, @NotNull Processor<PyCallExpression> processor) {
        if (function == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(16);
        }
        PsiFile file = function.getContainingFile();
        String name = function.getName();
        if (file != null && name != null) {
            String text2 = file.getText();
            int pos = text2.indexOf(name);
            while (pos != -1) {
                PyCallExpression expr;
                PsiReference ref = file.findReferenceAt(pos);
                if (ref != null && ref.isReferenceTo((PsiElement)function) && (expr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(pos), PyCallExpression.class)) != null && !processor.process((Object)expr)) {
                    return;
                }
                pos = text2.indexOf(name, pos + 1);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "('" + this.getName() + "')";
    }

    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner owner = ScopeUtil.getScopeOwner(this);
        if (owner instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)owner);
            if (localSearchScope == null) {
                PyNamedParameterImpl.$$$reportNull$$$0(17);
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.getContainingFile());
        if (localSearchScope == null) {
            PyNamedParameterImpl.$$$reportNull$$$0(18);
        }
        return localSearchScope;
    }

    @Override
    public boolean isSelf() {
        if (this.isPositionalContainer() || this.isKeywordContainer()) {
            return false;
        }
        PyFunction function = (PyFunction)this.getStubOrPsiParentOfType(PyFunction.class);
        if (function == null) {
            return false;
        }
        PyClass cls = function.getContainingClass();
        PyParameter[] parameters2 = function.getParameterList().getParameters();
        if (cls != null && parameters2.length > 0 && parameters2[0] == this) {
            if ("__new__".equals(function.getName())) {
                return true;
            }
            PyFunction.Modifier modifier = function.getModifier();
            if (modifier != PyFunction.Modifier.STATICMETHOD) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public PsiComment getTypeComment() {
        for (PsiElement next = this.getNextSibling(); next != null && !next.textContains('\n'); next = next.getNextSibling()) {
            if (next instanceof PsiWhiteSpace || ",".equals(next.getText())) continue;
            if (!(next instanceof PsiComment) || PyTypingTypeProvider.getTypeCommentValue(next.getText()) == null) break;
            return (PsiComment)next;
        }
        return null;
    }

    @Override
    @Nullable
    public String getTypeCommentAnnotation() {
        return PyNamedParameterImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyNamedParameterImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyNamedParameterImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepr";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsNamed";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersByCallArgument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromUsages";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParametersByCallArgument";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processLocalCalls";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getParametersByCallArgument$5";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getType$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

