/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyOverridingTypeProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeUtil;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCollectionTypeByModificationsProvider
extends PyTypeProviderBase
implements PyOverridingTypeProvider {
    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        PyExpression target;
        String qualifiedName;
        if (function == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(0);
        }
        if (callSite == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(2);
        }
        if ((qualifiedName = function.getQualifiedName()) != null && PyCollectionTypeUtil.INSTANCE.getCollectionConstructors(LanguageLevel.forElement((PsiElement)callSite)).contains(qualifiedName) && (target = PyCollectionTypeUtil.INSTANCE.getTargetForValueInAssignment(callSite)) instanceof PyTargetExpression) {
            List<PyType> typesByModifications;
            List<PyExpression> arguments = callSite.getArguments(null);
            List<PyType> argumentTypes = PyCollectionTypeByModificationsProvider.getTypesFromConstructorArguments(context, arguments);
            PyTargetExpression element = (PyTargetExpression)target;
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            if (owner != null && !(typesByModifications = PyCollectionTypeUtil.INSTANCE.getCollectionTypeByModifications(qualifiedName, element, context)).isEmpty()) {
                if (qualifiedName.equals("dict.__init__")) {
                    argumentTypes = PyCollectionTypeByModificationsProvider.extractTypesForDict(argumentTypes, typesByModifications);
                } else {
                    argumentTypes.addAll(typesByModifications);
                    argumentTypes = Collections.singletonList(PyUnionType.union(argumentTypes));
                }
                PyClass cls = function.getContainingClass();
                if (cls != null) {
                    return Ref.create((Object)new PyCollectionTypeImpl(cls, false, argumentTypes));
                }
                PyType returnType = context.getReturnType(function);
                if (returnType instanceof PyClassType) {
                    return Ref.create((Object)new PyCollectionTypeImpl(((PyClassType)returnType).getPyClass(), false, argumentTypes));
                }
            }
        }
        return null;
    }

    @NotNull
    private static List<PyType> getTypesFromConstructorArguments(@NotNull TypeEvalContext context, @NotNull List<PyExpression> arguments) {
        if (context == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(3);
        }
        if (arguments == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(4);
        }
        ArrayList<PyType> argumentTypes = new ArrayList<PyType>();
        PyExpression arg = (PyExpression)ContainerUtil.getFirstItem(arguments);
        if (arg != null) {
            PyType type = context.getType(arg);
            if (type instanceof PyCollectionType) {
                argumentTypes.addAll(((PyCollectionType)type).getElementTypes());
            } else {
                argumentTypes.add(type);
            }
        }
        ArrayList<PyType> arrayList = argumentTypes;
        if (arrayList == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyType> extractTypesForDict(@NotNull List<PyType> argumentTypes, @NotNull List<PyType> typesByModifications) {
        if (argumentTypes == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(6);
        }
        if (typesByModifications == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(7);
        }
        if (argumentTypes.size() == 1) {
            PyType type = (PyType)ContainerUtil.getFirstItem(argumentTypes);
            if (type instanceof PyTupleType) {
                PyTupleType tuple = (PyTupleType)type;
                argumentTypes = tuple.getElementTypes();
            } else if (type == null) {
                argumentTypes.add(null);
            }
        }
        if (typesByModifications.size() == 2) {
            if (argumentTypes.size() == 2) {
                argumentTypes.set(0, PyUnionType.union(argumentTypes.get(0), typesByModifications.get(0)));
                argumentTypes.set(1, PyUnionType.union(argumentTypes.get(1), typesByModifications.get(1)));
            } else {
                argumentTypes = typesByModifications;
            }
        }
        List<PyType> list = argumentTypes;
        if (list == null) {
            PyCollectionTypeByModificationsProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyCollectionTypeByModificationsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesByModifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyCollectionTypeByModificationsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFromConstructorArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTypesForDict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFromConstructorArguments";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractTypesForDict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

