/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/sdk/flavors/MayaSdkFlavor;", "Lcom/jetbrains/python/sdk/flavors/PythonSdkFlavor;", "()V", "getIcon", "Ljavax/swing/Icon;", "getName", "", "getSdkPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "getVersionOption", "isValidSdkHome", "", "isValidSdkPath", "file", "Ljava/io/File;", "Companion", "intellij.python.community.impl"})
public final class MayaSdkFlavor
extends PythonSdkFlavor {
    @NotNull
    private static MayaSdkFlavor INSTANCE;
    public static final Companion Companion;

    @Override
    public boolean isValidSdkHome(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = new File(path);
        return file.isFile() && this.isValidSdkPath(file) || MayaSdkFlavor.Companion.isMayaFolder(file);
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string2 = FileUtil.getNameWithoutExtension((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.getNameWithoutExtension(file)");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String name = string4;
        return StringsKt.startsWith$default((String)name, (String)"mayapy", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public String getVersionOption() {
        return "--version";
    }

    @Override
    @NotNull
    public String getName() {
        return "MayaPy";
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Python;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Python");
        return icon;
    }

    @Override
    @Nullable
    public VirtualFile getSdkPath(@NotNull VirtualFile path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (MayaSdkFlavor.Companion.isMayaFolder(new File(path.getPath()))) {
            return path.findFileByRelativePath("Contents/bin/mayapy");
        }
        return path;
    }

    private MayaSdkFlavor() {
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new MayaSdkFlavor();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/sdk/flavors/MayaSdkFlavor$Companion;", "", "()V", "INSTANCE", "Lcom/jetbrains/python/sdk/flavors/MayaSdkFlavor;", "getINSTANCE", "()Lcom/jetbrains/python/sdk/flavors/MayaSdkFlavor;", "setINSTANCE", "(Lcom/jetbrains/python/sdk/flavors/MayaSdkFlavor;)V", "isMayaFolder", "", "file", "Ljava/io/File;", "intellij.python.community.impl"})
    public static final class Companion {
        @NotNull
        public final MayaSdkFlavor getINSTANCE() {
            return INSTANCE;
        }

        public final void setINSTANCE(@NotNull MayaSdkFlavor mayaSdkFlavor) {
            Intrinsics.checkParameterIsNotNull((Object)mayaSdkFlavor, (String)"<set-?>");
            INSTANCE = mayaSdkFlavor;
        }

        private final boolean isMayaFolder(File file) {
            return file.isDirectory() && Intrinsics.areEqual((Object)file.getName(), (Object)"Maya.app");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

