/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class PyBuiltinAnnotator
extends PyAnnotator {
    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        String name = node.getName();
        if (name == null) {
            return;
        }
        boolean highlightedAsAttribute = this.highlightAsAttribute(node, name);
        if (highlightedAsAttribute) {
            return;
        }
        if ((PyBuiltinCache.isInBuiltins(node) || PyUtil.isPy2ReservedWord(node)) && !(node.getParent() instanceof PyDecorator)) {
            this.addHighlightingAnnotation((PsiElement)node, PyHighlighter.PY_BUILTIN_NAME);
        }
    }

    @Override
    public void visitPyTargetExpression(PyTargetExpression node) {
        String name = node.getName();
        if (name != null) {
            this.highlightAsAttribute(node, name);
        }
    }

    private boolean highlightAsAttribute(@NotNull PyQualifiedExpression node, @NotNull String name) {
        ASTNode tgt;
        ASTNode astNode;
        if (node == null) {
            PyBuiltinAnnotator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PyBuiltinAnnotator.$$$reportNull$$$0(1);
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
        if ((PyNames.UNDERSCORED_ATTRIBUTES.contains((Object)name) || PyNames.getBuiltinMethods(languageLevel).containsKey((Object)name)) && (node.isQualified() || ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyClass) && (astNode = node.getNode()) != null && (tgt = astNode.findChildByType((IElementType)PyTokenTypes.IDENTIFIER)) != null) {
            this.addHighlightingAnnotation(tgt, PyHighlighter.PY_PREDEFINED_USAGE);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/validation/PyBuiltinAnnotator";
        objectArray[2] = "highlightAsAttribute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

