/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.statistics.VcsLogIndexCollector;
import com.intellij.vcs.log.statistics.VcsLogIndexCollectorState;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/statistics/VcsLogIndexProjectStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getContext", "Lcom/intellij/internal/statistic/service/fus/collectors/FUSUsageContext;", "project", "Lcom/intellij/openapi/project/Project;", "getGroupId", "", "getIndexCollector", "Lcom/intellij/vcs/log/statistics/VcsLogIndexCollector;", "getSharedSettings", "Lcom/intellij/vcs/log/impl/VcsLogSharedSettings;", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "intellij.platform.vcs.log.impl"})
public final class VcsLogIndexProjectStatisticsCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        Set usages;
        block1: {
            Object sharedSettings;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            usages = new LinkedHashSet();
            Object object2 = this.getIndexCollector(project);
            if (object2 != null && (object2 = ((VcsLogIndexCollector)object2).getState()) != null) {
                Object indexCollectorState = object = object2;
                usages.add(StatisticsUtilKt.getCountingUsage("indexing.too.long.notification", ((VcsLogIndexCollectorState)indexCollectorState).getIndexingTooLongNotification()));
                usages.add(StatisticsUtilKt.getCountingUsage("resume.indexing.click", ((VcsLogIndexCollectorState)indexCollectorState).getResumeClick()));
                int indexingTime = (int)TimeUnit.MILLISECONDS.toMinutes(((VcsLogIndexCollectorState)indexCollectorState).getIndexTime());
                usages.add(StatisticsUtilKt.getCountingUsage("indexing.time.minutes", indexingTime));
            }
            VcsLogSharedSettings vcsLogSharedSettings = this.getSharedSettings(project);
            if (vcsLogSharedSettings == null || ((VcsLogSharedSettings)(sharedSettings = (object = vcsLogSharedSettings))).isIndexSwitchedOn()) break block1;
            usages.add(StatisticsUtilKt.getBooleanUsage("index.disabled.in.project", true));
        }
        return usages;
    }

    private final VcsLogSharedSettings getSharedSettings(Project project) {
        return (VcsLogSharedSettings)ServiceManager.getServiceIfCreated((Project)project, VcsLogSharedSettings.class);
    }

    private final VcsLogIndexCollector getIndexCollector(Project project) {
        return (VcsLogIndexCollector)ServiceManager.getServiceIfCreated((Project)project, VcsLogIndexCollector.class);
    }

    @Override
    @NotNull
    public FUSUsageContext getContext(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        FUSUsageContext fUSUsageContext = FUSUsageContext.OS_CONTEXT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fUSUsageContext, (String)"FUSUsageContext.OS_CONTEXT");
        return fUSUsageContext;
    }

    @Override
    @NotNull
    public String getGroupId() {
        return "statistics.vcs.log.index.project";
    }
}

