/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import tr.extract.Param;
import tr.extract.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(File xmlfile, InputStream xsltfile, List<Param> params, File pdffile) {
        System.out.print("Processing XSL-FO ... ");
        try {
            FopFactory fopFactory = FopFactory.newInstance();
            File configFile = Resources.FILE_FOP_CONFIG;
            if (configFile != null) {
                DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
                Configuration cfg = cfgBuilder.buildFromFile(configFile);
                fopFactory.setUserConfig(cfg);
            }
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdffile));
            try {
                Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(new StreamSource(xsltfile));
                for (Param param : params) {
                    transformer.setParameter(param.id, param.getValue());
                }
                StreamSource src = new StreamSource(xmlfile);
                SAXResult res = new SAXResult(fop.getDefaultHandler());
                transformer.transform(src, res);
            }
            finally {
                ((OutputStream)out).close();
            }
            System.out.print("done");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            System.out.println();
        }
    }
}

