/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;

public class Config {
    private final Properties properties = new Properties();
    private boolean useEnvironmentVariables;

    void load(String file) throws IOException {
        try {
            Properties mainProperties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(file);){
                mainProperties.loadFromXML(inputStream);
            }
            String defaultConfigFile = mainProperties.getProperty("config.default");
            if (defaultConfigFile != null) {
                try (FileInputStream inputStream = new FileInputStream(defaultConfigFile);){
                    this.properties.loadFromXML(inputStream);
                }
            }
            this.properties.putAll((Map<?, ?>)mainProperties);
            this.useEnvironmentVariables = Boolean.parseBoolean(System.getenv("CONFIG_USE_ENVIRONMENT_VARIABLES")) || Boolean.parseBoolean(this.properties.getProperty("config.useEnvironmentVariables"));
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException("Configuration file is not a valid XML document", e);
        }
    }

    public boolean hasKey(String key) {
        return this.useEnvironmentVariables && System.getenv().containsKey(Config.getEnvironmentVariableName(key)) || this.properties.containsKey(key);
    }

    public String getString(String key) {
        String value;
        if (this.useEnvironmentVariables && (value = System.getenv(Config.getEnvironmentVariableName(key))) != null && !value.isEmpty()) {
            return value;
        }
        return this.properties.getProperty(key);
    }

    public String getString(String key, String defaultValue) {
        return this.hasKey(key) ? this.getString(key) : defaultValue;
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String key, int defaultValue) {
        return this.hasKey(key) ? Integer.parseInt(this.getString(key)) : defaultValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.hasKey(key) ? Long.parseLong(this.getString(key)) : defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return this.hasKey(key) ? Double.parseDouble(this.getString(key)) : defaultValue;
    }

    public static String getEnvironmentVariableName(String key) {
        return key.replaceAll("\\.", "_").replaceAll("(\\p{Lu})", "_$1").toUpperCase();
    }

    public void setString(String key, String value) {
        this.properties.put(key, value);
    }
}

