/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocol;
import org.traccar.Context;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.protocol.WialonProtocolDecoder;
import org.traccar.protocol.WialonProtocolEncoder;

public class WialonProtocol
extends BaseProtocol {
    public WialonProtocol() {
        this.setSupportedDataCommands("rebootDevice", "sendUssd", "deviceIdentification", "outputControl");
        this.addServer(new TrackerServer(false, this.getName()){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline) {
                pipeline.addLast((ChannelHandler)new LineBasedFrameDecoder(4096));
                pipeline.addLast((ChannelHandler)new StringEncoder());
                boolean utf8 = Context.getConfig().getBoolean(WialonProtocol.this.getName() + ".utf8");
                if (utf8) {
                    pipeline.addLast((ChannelHandler)new StringDecoder(StandardCharsets.UTF_8));
                } else {
                    pipeline.addLast((ChannelHandler)new StringDecoder());
                }
                pipeline.addLast((ChannelHandler)new WialonProtocolEncoder());
                pipeline.addLast((ChannelHandler)new WialonProtocolDecoder(WialonProtocol.this));
            }
        });
    }
}

