/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CertPath
implements Serializable {
    private static final long serialVersionUID = 6068470306649138683L;
    private final String type;

    protected CertPath(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator<String> getEncodings();

    public boolean equals(Object o) {
        if (!(o instanceof CertPath)) {
            return false;
        }
        CertPath cp = (CertPath)o;
        return this.type.equals(cp.type) && this.getCertificates().equals(cp.getCertificates());
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.getCertificates().hashCode();
    }

    public String toString() {
        List<? extends Certificate> l = this.getCertificates();
        int size = l.size();
        int i = 0;
        CPStringBuilder result = new CPStringBuilder(this.type);
        result.append(" Cert Path: length = ").append(size).append(".\n[\n");
        while (--size >= 0) {
            result.append(l.get(i++)).append('\n');
        }
        return result.append("\n]").toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List<? extends Certificate> getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw (ObjectStreamException)new NotSerializableException("java.security.cert.CertPath: " + this.type).initCause(e);
        }
    }

    protected static class CertPathRep
    implements Serializable {
        private static final long serialVersionUID = 3015633072427920915L;
        private final String type;
        private final byte[] data;

        protected CertPathRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return CertificateFactory.getInstance(this.type).generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException e) {
                throw (ObjectStreamException)new NotSerializableException("java.security.cert.CertPath: " + this.type).initCause(e);
            }
        }
    }
}

