/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.spi.CurrencyNameProvider;

public final class Currency
implements Serializable {
    static final long serialVersionUID = -158308464356906721L;
    private static transient Properties properties;
    private String currencyCode;
    private transient int fractionDigits;
    private static transient Map countryMap;
    private static transient Map cache;

    static {
        countryMap = new HashMap();
        cache = new HashMap();
        properties = new Properties();
        try {
            properties.load(Currency.class.getResourceAsStream("iso4217.properties"));
        }
        catch (IOException exception) {
            throw new InternalError("Failed to load currency resource: " + exception);
        }
    }

    private Currency() {
    }

    private Currency(Locale loc) {
        String countryCode = loc.getCountry();
        if (countryCode.equals("")) {
            throw new IllegalArgumentException("Invalid (empty) country code for locale:" + loc);
        }
        String currencyKey = String.valueOf(countryCode) + ".currency";
        String fractionDigitsKey = String.valueOf(countryCode) + ".fractionDigits";
        this.currencyCode = properties.getProperty(currencyKey);
        if (this.currencyCode == null) {
            return;
        }
        int commaPosition = this.currencyCode.indexOf(",");
        if (commaPosition != -1) {
            this.currencyCode = this.currencyCode.substring(0, commaPosition);
        }
        this.fractionDigits = Integer.parseInt(properties.getProperty(fractionDigitsKey));
    }

    private Currency(String code) {
        this.currencyCode = code;
        this.fractionDigits = -1;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        return this.fractionDigits;
    }

    public static Currency getInstance(Locale locale) {
        Currency newCurrency;
        String country = locale.getCountry();
        if (locale == null || country == null) {
            throw new NullPointerException("The locale or its country is null.");
        }
        if (country.length() != 2) {
            throw new IllegalArgumentException();
        }
        String code = (String)countryMap.get(country);
        if (code == null) {
            newCurrency = new Currency(locale);
            code = newCurrency.getCurrencyCode();
            if (code == null) {
                return null;
            }
            countryMap.put(country, code);
            cache.put(code, newCurrency);
        } else {
            newCurrency = (Currency)cache.get(code);
        }
        return newCurrency;
    }

    public static Currency getInstance(String currencyCode) {
        if (currencyCode == null) {
            throw new NullPointerException("The supplied currency code is null.");
        }
        if (currencyCode.equals("XXX")) {
            return new Currency("XXX");
        }
        Currency newCurrency = (Currency)cache.get(currencyCode);
        if (newCurrency == null) {
            Locale[] allLocales = Locale.getAvailableLocales();
            int i = 0;
            while (i < allLocales.length) {
                try {
                    Currency testCurrency = Currency.getInstance(allLocales[i]);
                    if (testCurrency != null && testCurrency.getCurrencyCode().equals(currencyCode)) {
                        return testCurrency;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++i;
            }
            throw new IllegalArgumentException("The currency code, " + currencyCode + ", is not supported.");
        }
        return newCurrency;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    /*
     * Unable to fully structure code
     */
    public String getSymbol(Locale locale) {
        property = "currenciesSymbol." + this.currencyCode;
        try {
            return ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale).getString(property);
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(CurrencyNameProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var8_8 = p.getAvailableLocales();
            var7_7 = var8_8.length;
            var6_6 = 0;
            while (var6_6 < var7_7) {
                loc = var8_8[var6_6];
                if (loc.equals(locale)) {
                    localizedString = p.getSymbol(this.currencyCode, locale);
                    if (localizedString == null) continue block2;
                    return localizedString;
                }
                ++var6_6;
            }
            continue;
        }
lbl18:
        // 1 sources

        if (locale.equals(Locale.ROOT)) {
            return this.currencyCode;
        }
        return this.getSymbol(LocaleHelper.getFallbackLocale(locale));
    }

    public String toString() {
        return this.getCurrencyCode();
    }

    private Object readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.currencyCode);
    }
}

