;;
;; Set up the menu
;;
(add-menu "File")
(add-menu-entry "File" "New" "(new-buffer)")
(add-menu-entry "File" "Open" "(load-buffer)")
(add-menu-entry "File" "Save" "(save-buffer)")
(add-menu-entry "File" "Save As" "(save-buffer-as)")
(add-menu-entry "File" "Preview" "(preview)")
(add-menu-entry "File" "Print" "(print)")
(add-menu-entry "File" "Print Format" "(print-format)")
(add-menu-entry "File" "-" "-")
(add-submenu "File" "Backup Copies")
(add-submenu-entry "File" "Backup Copies" "Yes" "(make-backups 1)")
(add-submenu-entry "File" "Backup Copies" "No" "(make-backups 0)")
(add-submenu "File" "Settings")
(add-submenu-entry "File" "Settings" "Margins" "(change-margins nil)")
(add-submenu-entry "File" "Settings" "Paper Size" "(change-paper-size nil)")
(add-submenu-entry "File" "Settings" "Header and Footer" "(change-headfoot nil)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Load External" "(load-external)")
(add-menu-entry "File" "Save External" "(save-external)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Exit" "(quit-program)")

(add-menu "Edit")
;(add-menu-entry "Edit" "Show Editor" "(popup-editor)")
;(add-menu-entry "Edit" "Hide Stage" "(popdown-stage)")
(add-menu-entry "Edit" "Begin Empty Animation" "(ani-begin)")
(add-submenu "Edit" "Add Object")
(add-submenu-entry "Edit" "Add Object" "Line" "(add-line)")
(add-submenu-entry "Edit" "Add Object" "Rectangle" "(add-rectangle)")
(add-submenu-entry "Edit" "Add Object" "Arc" "(add-arc)")
(add-submenu-entry "Edit" "Add Object" "Ellipse" "(add-ellipse)")
(add-submenu-entry "Edit" "Add Object" "Image" "(add-image)")
(add-submenu-entry "Edit" "Add Object" "String" "(add-string)")
(add-submenu-entry "Edit" "Add Object" "Point" "(add-point)")
(add-submenu-entry "Edit" "Add Object" "Filled Rectangle" "(add-filled-rectangle)")
(add-submenu-entry "Edit" "Add Object" "Filled Arc" "(add-filled-arc)")
(add-submenu-entry "Edit" "Add Object" "Filled Ellipse" "(add-filled-ellipse)")
(add-submenu-entry "Edit" "Add Object" "Other" "(ins-object)")
(add-menu-entry "Edit" "Delete Object" "(del-object)")
(add-menu-entry "Edit" "Add Tick" "(ins-tick)")
(add-menu-entry "Edit" "Delete Tick" "(del-time)")
(add-menu-entry "Edit" "Edit Properties" "(ins-properties)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Set Background" "(set-background)")
(add-menu-entry "Edit" "Clear Background" "(clear-background)")
(add-menu-entry "Edit" "Set Gradient" "(set-bgrad)")
(add-menu-entry "Edit" "Clear Gradient" "(clear-bgrad)")
(add-menu-entry "Edit" "Timing" "(set-timing)")
(add-menu-entry "Edit" "Set Geometry" "(set-geometry)")

(add-menu "Format")
(add-menu-entry "Format" "Margins" "(change-margins \"\")")
(add-menu-entry "Format" "Paper Size" "(change-paper-size \"\")")
(add-menu-entry "Format" "Header and Footer" "(change-headfoot \"\")")
(add-menu-entry "Format" "First Page Number" "(change-first-page \"\")")

(add-menu "Window")
(add-menu-entry "Window" "Change Buffer" "(switch-to-buffer)")
(add-menu-entry "Window" "Delete Buffer" "(kill-buffer)")
(add-menu-entry "Window" "-" "-")
;(add-menu-entry "Window" "Split Window" "(split-window-vertically)")
;(add-menu-entry "Window" "Remove Window" "(delete-window)")
;(add-menu-entry "Window" "One Window" "(delete-other-windows)")
;(add-menu-entry "Window" "Change Window" "(other-window)")
;(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Add Sheet" "(add-sheet)")
(add-menu-entry "Window" "Remove Sheet" "(remove-sheet)")
(add-menu-entry "Window" "Rename Sheet" "(rename-sheet)")
(add-submenu "Window" "Move Sheet")
(add-submenu-entry "Window" "Move Sheet" "Up" "(move-sheet-up)")
(add-submenu-entry "Window" "Move Sheet" "Down" "(move-sheet-down)")
(add-submenu-entry "Window" "Move Sheet" "Top" "(move-sheet-top)")
(add-submenu-entry "Window" "Move Sheet" "Bottom" "(move-sheet-bottom)")

(add-menu-entry "Window" "-" "-")

(define (tooltip-set m)
  (set! *tooltip-mode* m)
  (tooltip-mode m))
(add-submenu "Window" "Helptexts")
(add-submenu-entry "Window" "Helptexts" "Disable" "(tooltip-set 0)")
(add-submenu-entry "Window" "Helptexts" "Label" "(tooltip-set 1)")
(add-submenu-entry "Window" "Helptexts" "Popup" "(tooltip-set 2)")
(add-submenu-entry "Window" "Helptexts" "Both" "(tooltip-set 3)")

(add-menu-entry "Window" "Save Preferences" "(save-preferences)")

(add-menu "Tools")

(require (string-append datadir "/common/tools.scm"))
(add-menu-entry "Tools" "XPaint" "(spawn \"xpaint\")")
(add-menu-entry "Tools" "-" "-")
(add-submenu "Tools" "Demo")
(add-submenu-entry "Tools" "Demo" "Box" "(ani-test)")
(add-submenu-entry "Tools" "Demo" "Circle" "(ani-test2)")
(add-submenu-entry "Tools" "Demo" "Line" "(ani-test3)")
(add-submenu-entry "Tools" "Demo" "Combo" "(ani-test4)")

(add-menu "Plugin")
(add-menu-entry "Plugin" "Import" "(plugin-import nil)")
(add-menu-entry "Plugin" "Export" "(plugin-export)")
(add-menu-entry "Plugin" "Link" "(plugin-link nil)")
(add-menu-entry "Plugin" "Delete" "(plugin-delete)")
(add-menu-entry "Plugin" "Move" "(plugin-move)")

(add-menu "Help")
(add-menu-entry "Help" "Contents" "(help-contents)")
;(add-menu-entry "Help" "Search" "(help-search)")
(add-menu-entry "Help" "Copying" "(help-copyright)")
(add-menu-entry "Help" "Help for Help" "(help-for-help)")

(add-submenu "Help" "Links")

(define (help-link name url)
  (add-submenu-entry "Help"
		     "Links"
		     name
		     (string-append "(do-link \"" url "\")")))

(help-link "Siag Home" "http://siag.nu/")
(help-link "FTP Directory" "ftp://siag.nu/pub/siag/")

(add-menu-entry "Help" "-" "-")
;(add-menu-entry "Help" "About Egon Animator" "(print-version)")
(add-menu-entry "Help" "About Egon Animator..." "(aboutbox)")
(add-menu-entry "Help" "About Siag Office..." "(aboutsiag)")

(add-pseudo-menu "Shortcuts")

;(add-menu-entry "Shortcuts" "Show editor" "(popup-editor)")
(add-menu-entry "Shortcuts" "Hide stage" "(popdown-stage)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Open file" "(load-buffer)")
(add-menu-entry "Shortcuts" "Save file" "(save-buffer-as)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Next page" "(next-page)")
(add-menu-entry "Shortcuts" "Previous page" "(previous-page)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Stop animation" "(ani-ctl ANI_STOP 0)")
(add-menu-entry "Shortcuts" "Previous frame" "(ani-ctl ANI_PREVIOUS 0)")
(add-menu-entry "Shortcuts" "Next frame" "(ani-ctl ANI_NEXT 0)")
(add-menu-entry "Shortcuts" "Play animation" "(ani-ctl ANI_CONTINUE 0)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Quit Egon" "(quit-program)")

