/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyReference
extends PropertyReferenceBase
implements LocalQuickFixProvider {
    @Nullable
    private final String myBundleName;

    public PropertyReference(@NotNull String key, @NotNull PsiElement element, @Nullable String bundleName, boolean soft, TextRange range) {
        if (key == null) {
            PropertyReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PropertyReference.$$$reportNull$$$0(1);
        }
        super(key, soft, element, range);
        this.myBundleName = bundleName;
    }

    public PropertyReference(@NotNull String key, @NotNull PsiElement element, @Nullable String bundleName, boolean soft) {
        if (key == null) {
            PropertyReference.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PropertyReference.$$$reportNull$$$0(3);
        }
        super(key, soft, element);
        this.myBundleName = bundleName;
    }

    @Override
    @Nullable
    protected List<PropertiesFile> getPropertiesFiles() {
        if (this.myBundleName == null) {
            return null;
        }
        return this.retrievePropertyFilesByBundleName(this.myBundleName, this.myElement);
    }

    protected List<PropertiesFile> retrievePropertyFilesByBundleName(String bundleName, PsiElement element) {
        return I18nUtil.propertiesFilesByBundleName(bundleName, element);
    }

    public LocalQuickFix[] getQuickFixes() {
        List<PropertiesFile> propertiesFiles = this.retrievePropertyFilesByBundleName(this.myBundleName, this.getElement());
        LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createCreatePropertyFix(this.myElement, this.myKey, propertiesFiles);
        return new LocalQuickFix[]{fix};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/properties/references/PropertyReference";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

