/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleCachingUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.FileCodeStyleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyle {
    private CodeStyle() {
    }

    @NotNull
    public static CodeStyleSettings getDefaultSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance().getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(1);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getProjectOrDefaultSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = project != null ? CodeStyle.getSettings(project) : CodeStyle.getDefaultSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(3);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(4);
        }
        for (FileCodeStyleProvider provider : FileCodeStyleProvider.EP_NAME.getExtensionList()) {
            CodeStyleSettings fileSettings = provider.getSettings(file);
            if (fileSettings == null) continue;
            CodeStyleSettings codeStyleSettings = fileSettings;
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(5);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleCachingUtil.getCachedCodeStyle(file);
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(6);
        }
        return codeStyleSettings;
    }

    public static CodeStyleSettings getSettings(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(7);
        }
        if ((project = editor.getProject()) != null) {
            PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
            if (file != null) {
                return CodeStyle.getSettings(file);
            }
            return CodeStyle.getSettings(project);
        }
        return CodeStyle.getDefaultSettings();
    }

    @Nullable
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull Editor editor) {
        PsiFile file;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(8);
        }
        if ((project = editor.getProject()) != null && (file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null) {
            return CodeStyle.getLanguageSettings(file);
        }
        return null;
    }

    @NotNull
    public static <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull PsiFile file, Class<T> customSettingsClass) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(9);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        T t = rootSettings.getCustomSettings(customSettingsClass);
        if (t == null) {
            CodeStyle.$$$reportNull$$$0(10);
        }
        return t;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(11);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(file.getLanguage());
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(12);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file, @NotNull Language language) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(13);
        }
        if (language == null) {
            CodeStyle.$$$reportNull$$$0(14);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(15);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(16);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings.IndentOptions indentOptions = rootSettings.getIndentOptionsByFile(file);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(17);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptionsByFileType(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(18);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = file != null ? CodeStyle.getSettings(project).getIndentOptions(file.getFileType()) : CodeStyle.getSettings(project).getIndentOptions();
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(19);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(20);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(21);
        }
        if ((file = PsiDocumentManager.getInstance(project).getPsiFile(document)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions(file);
            if (indentOptions == null) {
                CodeStyle.$$$reportNull$$$0(22);
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(project).getIndentOptions((FileType)null);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(23);
        }
        return indentOptions;
    }

    public static int getIndentSize(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(24);
        }
        return CodeStyle.getIndentOptions((PsiFile)file).INDENT_SIZE;
    }

    public static void setTemporarySettings(@Nullable Project project, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(25);
        }
        CodeStyleSettingsManager.getInstance(project).setTemporarySettings(settings);
    }

    public static void dropTemporarySettings(@Nullable Project project) {
        CodeStyleSettingsManager.getInstance(project).dropTemporarySettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithTemporarySettings(@NotNull Project project, @NotNull CodeStyleSettings tempSettings, @NotNull Runnable runnable) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(26);
        }
        if (tempSettings == null) {
            CodeStyle.$$$reportNull$$$0(27);
        }
        if (runnable == null) {
            CodeStyle.$$$reportNull$$$0(28);
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance(project);
        CodeStyleSettings tempSettingsBefore = settingsManager.getTemporarySettings();
        try {
            settingsManager.setTemporarySettings(tempSettings);
            runnable.run();
        }
        finally {
            if (tempSettingsBefore != null) {
                settingsManager.setTemporarySettings(tempSettingsBefore);
            } else {
                settingsManager.dropTemporarySettings();
            }
        }
    }

    public static boolean usesOwnSettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(29);
        }
        return CodeStyleSettingsManager.getInstance((Project)project).USE_PER_PROJECT_SETTINGS;
    }

    public static void updateDocumentIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        PsiDocumentManager documentManager;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(30);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(31);
        }
        if (!project.isDisposed() && (documentManager = PsiDocumentManager.getInstance(project)) != null && (file = documentManager.getPsiFile(document)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(file).getIndentOptionsByFile(file, null, true, null);
            indentOptions.associateWithDocument(document);
        }
    }

    public static void setMainProjectSettings(@NotNull Project project, @NotNull CodeStyleSettings settings) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(32);
        }
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(33);
        }
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance(project);
        codeStyleSettingsManager.setMainProjectCodeStyle(settings);
        codeStyleSettingsManager.USE_PER_PROJECT_SETTINGS = true;
    }

    public static boolean isFormattingEnabled(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(34);
        }
        return !CodeStyle.getSettings(file).getExcludedFiles().contains(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 1: 
            case 18: 
            case 20: 
            case 26: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettings";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrDefaultSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
            case 17: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 16: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByFileType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSize";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doWithTemporarySettings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "usesOwnSettings";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentIndentOptions";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setMainProjectSettings";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFormattingEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

