/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Executor {
    public static final ExtensionPointName<Executor> EXECUTOR_EXTENSION_NAME = ExtensionPointName.create((String)"com.intellij.executor");

    public abstract String getToolWindowId();

    public abstract Icon getToolWindowIcon();

    @NotNull
    public abstract Icon getIcon();

    public abstract Icon getDisabledIcon();

    public abstract String getDescription();

    @NotNull
    public abstract String getActionName();

    @NotNull
    @NonNls
    public abstract String getId();

    @NotNull
    public abstract String getStartActionText();

    @NonNls
    public abstract String getContextActionId();

    @NonNls
    public abstract String getHelpId();

    @Nullable
    public ActionWrapper runnerActionsGroupExecutorActionCustomizer() {
        return null;
    }

    @NotNull
    public String getStartActionText(@NotNull String configurationName) {
        String configName;
        String text;
        if (configurationName == null) {
            Executor.$$$reportNull$$$0(0);
        }
        boolean hasMnemonic = (text = this.getStartActionText()).indexOf(27) >= 0 || !StringUtil.escapeMnemonics((String)text).equals(text);
        String string = configName = StringUtil.isEmpty((String)configurationName) ? "" : " '" + Executor.shortenNameIfNeed(configurationName) + "'";
        if (!hasMnemonic) {
            configName = StringUtil.escapeMnemonics((String)configName);
        }
        String string2 = text + configName;
        if (string2 == null) {
            Executor.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            Executor.$$$reportNull$$$0(2);
        }
        return true;
    }

    public static String shortenNameIfNeed(@NotNull String name) {
        if (name == null) {
            Executor.$$$reportNull$$$0(3);
        }
        return StringUtil.trimMiddle((String)name, (int)Registry.intValue((String)"run.configuration.max.name.length", (int)80));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/Executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/Executor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStartActionText";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shortenNameIfNeed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ActionWrapper {
        @NotNull
        public AnAction wrap(@NotNull AnAction var1);
    }
}

