/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter,
DumbAware {
    private static final String FILE_URL_PROTOCOL = "file://";
    private final Project myProject;

    public UrlFilter() {
        this(null);
    }

    public UrlFilter(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            UrlFilter.$$$reportNull$$$0(0);
        }
        if (!URLUtil.canContainUrl((String)line)) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        Pattern pattern = line.contains(FILE_URL_PROTOCOL) ? URLUtil.FILE_URL_PATTERN : URLUtil.URL_PATTERN;
        Matcher m = pattern.matcher(line);
        Filter.ResultItem item = null;
        ArrayList<Filter.ResultItem> items = null;
        while (m.find()) {
            if (item == null) {
                item = new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group()));
                continue;
            }
            if (items == null) {
                items = new ArrayList<Filter.ResultItem>(2);
                items.add(item);
            }
            items.add(new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group())));
        }
        return items != null ? new Filter.Result(items) : (item != null ? new Filter.Result(item.getHighlightStartOffset(), item.getHighlightEndOffset(), item.getHyperlinkInfo()) : null);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        HyperlinkInfo fileHyperlinkInfo;
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(1);
        }
        HyperlinkInfo hyperlinkInfo = (fileHyperlinkInfo = this.buildFileHyperlinkInfo(url)) != null ? fileHyperlinkInfo : new BrowserHyperlinkInfo(url);
        if (hyperlinkInfo == null) {
            UrlFilter.$$$reportNull$$$0(2);
        }
        return hyperlinkInfo;
    }

    @Nullable
    private HyperlinkInfo buildFileHyperlinkInfo(final @NotNull String url) {
        if (url == null) {
            UrlFilter.$$$reportNull$$$0(3);
        }
        if (this.myProject != null && url.startsWith(FILE_URL_PROTOCOL)) {
            return new LazyFileHyperlinkInfo(this.myProject, StringUtil.trimStart((String)url, (String)FILE_URL_PROTOCOL), 0, 0){

                @Override
                @Nullable
                public OpenFileDescriptor getDescriptor() {
                    OpenFileDescriptor descriptor = super.getDescriptor();
                    if (descriptor == null) {
                        Messages.showErrorDialog(UrlFilter.this.myProject, "Cannot find file " + StringUtil.trimMiddle((String)url, (int)150), IdeBundle.message("title.cannot.open.file", new Object[0]));
                    }
                    return descriptor;
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/UrlFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/UrlFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHyperlinkInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildHyperlinkInfo";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildFileHyperlinkInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        @Override
        @NotNull
        public Filter[] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                UrlFilterProvider.$$$reportNull$$$0(1);
            }
            Filter[] filterArray = new Filter[]{new UrlFilter(project)};
            if (filterArray == null) {
                UrlFilterProvider.$$$reportNull$$$0(2);
            }
            return filterArray;
        }

        @Override
        @NotNull
        public Filter[] getDefaultFilters(@NotNull Project project) {
            if (project == null) {
                UrlFilterProvider.$$$reportNull$$$0(3);
            }
            Filter[] filterArray = this.getDefaultFilters(project, GlobalSearchScope.allScope(project));
            if (filterArray == null) {
                UrlFilterProvider.$$$reportNull$$$0(4);
            }
            return filterArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/filters/UrlFilter$UrlFilterProvider";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultFilters";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

