/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ReadonlyStatusHandler {
    public static boolean ensureFilesWritable(@NotNull Project project, VirtualFile ... files) {
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(0);
        }
        if (files == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(1);
        }
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(Arrays.asList(files)).hasReadonlyFiles();
    }

    public static boolean ensureDocumentWritable(@NotNull Project project, @NotNull Document document) {
        VirtualFile virtualFile2;
        PsiFile psiFile;
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(2);
        }
        if (document == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(3);
        }
        boolean okWritable = (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document)) == null ? document.isWritable() : ((virtualFile2 = psiFile.getVirtualFile()) != null ? ReadonlyStatusHandler.ensureFilesWritable(project, virtualFile2) : psiFile.isWritable());
        return okWritable;
    }

    @Deprecated
    @NotNull
    public OperationStatus ensureFilesWritable(VirtualFile ... files) {
        if (files == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(4);
        }
        OperationStatus operationStatus = this.ensureFilesWritable(Arrays.asList(files));
        if (operationStatus == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(5);
        }
        return operationStatus;
    }

    @NotNull
    public abstract OperationStatus ensureFilesWritable(@NotNull Collection<VirtualFile> var1);

    public static ReadonlyStatusHandler getInstance(@NotNull Project project) {
        if (project == null) {
            ReadonlyStatusHandler.$$$reportNull$$$0(6);
        }
        return ServiceManager.getService(project, ReadonlyStatusHandler.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ReadonlyStatusHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ReadonlyStatusHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureDocumentWritable";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class OperationStatus {
        @NotNull
        public abstract VirtualFile[] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        @NotNull
        public abstract String getReadonlyFilesMessage();
    }
}

