/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsManager.class);
    @Deprecated
    @Nullable
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS;
    public volatile boolean USE_PER_PROJECT_SETTINGS;
    public volatile String PREFERRED_PROJECT_CODE_STYLE;
    private volatile CodeStyleSettings myTemporarySettings;
    private final List<CodeStyleSettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        ProjectCodeStyleSettingsManager projectSettingsManager = ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class);
        projectSettingsManager.initProjectSettings(project);
        return projectSettingsManager;
    }

    @Deprecated
    public static CodeStyleSettingsManager getInstance() {
        return ServiceManager.getService(AppCodeStyleSettingsManager.class);
    }

    @Deprecated
    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    @Deprecated
    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            CodeStyleSettings codeStyleSettings = temporarySettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(1);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings projectSettings = this.getMainProjectCodeStyle();
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            CodeStyleSettings codeStyleSettings = projectSettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(2);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        return codeStyleSettings;
    }

    @Override
    public Element getState() {
        Element result2 = new Element("state");
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)result2, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter<CodeStyleSettingsManager>(this, new CodeStyleSettingsManager()){

                public boolean isAccept(@NotNull Field field) {
                    if (field == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return !CodeStyleSettingsManager.this.isIgnoredOnSave(field.getName()) && super.isAccept(field);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/CodeStyleSettingsManager$1", "isAccept"));
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
    }

    @Nullable
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.PER_PROJECT_SETTINGS;
    }

    @Deprecated
    public boolean isLoaded() {
        return true;
    }

    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        this.updateSettingsTracker();
        this.myTemporarySettings = settings;
    }

    public void dropTemporarySettings() {
        this.updateSettingsTracker();
        this.myTemporarySettings = null;
    }

    @Nullable
    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    public void addListener(@NotNull CodeStyleSettingsListener listener) {
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        this.myListeners.add(listener);
    }

    private void removeListener(@NotNull CodeStyleSettingsListener listener) {
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        this.myListeners.remove(listener);
    }

    public static void removeListener(@Nullable Project project, @NotNull CodeStyleSettingsListener listener) {
        CodeStyleSettingsManager projectInstance;
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        if (project == null || project.isDefault()) {
            CodeStyleSettingsManager.getInstance().removeListener(listener);
        } else if (!project.isDisposed() && (projectInstance = (CodeStyleSettingsManager)ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class)) != null) {
            projectInstance.removeListener(listener);
        }
    }

    public void fireCodeStyleSettingsChanged(@Nullable PsiFile file) {
        for (CodeStyleSettingsListener listener : this.myListeners) {
            listener.codeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(file));
        }
    }

    public final void notifyCodeStyleSettingsChanged() {
        this.updateSettingsTracker();
        this.fireCodeStyleSettingsChanged(null);
    }

    private void updateSettingsTracker() {
        CodeStyleSettings settings = this.getCurrentSettings();
        settings.getModificationTracker().incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

