/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedScopesHolder
implements PersistentStateComponent<Element> {
    private NamedScope[] myScopes;
    @NonNls
    private static final String SCOPE_TAG = "scope";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String PATTERN_ATT = "pattern";
    protected final Project myProject;
    private VirtualFile myProjectBaseDir;
    private final List<ScopeListener> myScopeListeners;

    public NamedScopesHolder(@NotNull Project project) {
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(0);
        }
        this.myScopes = NamedScope.EMPTY_ARRAY;
        this.myScopeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    public abstract String getDisplayName();

    public abstract Icon getIcon();

    public VirtualFile getProjectBaseDir() {
        if (this.myProjectBaseDir == null) {
            this.myProjectBaseDir = this.myProject.getBaseDir();
        }
        return this.myProjectBaseDir;
    }

    public void addScopeListener(@NotNull ScopeListener scopeListener) {
        if (scopeListener == null) {
            NamedScopesHolder.$$$reportNull$$$0(1);
        }
        this.myScopeListeners.add(scopeListener);
    }

    public void removeScopeListener(@NotNull ScopeListener scopeListener) {
        if (scopeListener == null) {
            NamedScopesHolder.$$$reportNull$$$0(2);
        }
        this.myScopeListeners.remove(scopeListener);
    }

    public void fireScopeListeners() {
        for (ScopeListener listener : this.myScopeListeners) {
            listener.scopesChanged();
        }
    }

    @NotNull
    public NamedScope[] getScopes() {
        List<NamedScope> list = this.getPredefinedScopes();
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>(list.size() + this.myScopes.length);
        scopes.addAll(list);
        Collections.addAll(scopes, this.myScopes);
        NamedScope[] namedScopeArray = scopes.toArray(NamedScope.EMPTY_ARRAY);
        if (namedScopeArray == null) {
            NamedScopesHolder.$$$reportNull$$$0(3);
        }
        return namedScopeArray;
    }

    @NotNull
    public NamedScope[] getEditableScopes() {
        if (this.myScopes == null) {
            NamedScopesHolder.$$$reportNull$$$0(4);
        }
        return this.myScopes;
    }

    public void removeAllSets() {
        this.myScopes = NamedScope.EMPTY_ARRAY;
        this.fireScopeListeners();
    }

    public void setScopes(@NotNull NamedScope[] scopes) {
        if (scopes == null) {
            NamedScopesHolder.$$$reportNull$$$0(5);
        }
        this.myScopes = (NamedScope[])scopes.clone();
        this.fireScopeListeners();
    }

    public void addScope(@NotNull NamedScope scope) {
        if (scope == null) {
            NamedScopesHolder.$$$reportNull$$$0(6);
        }
        this.myScopes = (NamedScope[])ArrayUtil.append((Object[])this.myScopes, (Object)scope);
        this.fireScopeListeners();
    }

    @Nullable
    public static NamedScope getScope(@NotNull Project project, String scopeName) {
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(7);
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    @NotNull
    public static NamedScopesHolder[] getAllNamedScopeHolders(@NotNull Project project) {
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(8);
        }
        NamedScopesHolder[] namedScopesHolderArray = new NamedScopesHolder[]{NamedScopeManager.getInstance(project), DependencyValidationManager.getInstance(project)};
        if (namedScopesHolderArray == null) {
            NamedScopesHolder.$$$reportNull$$$0(9);
        }
        return namedScopesHolderArray;
    }

    @Contract(value="_,_,!null -> !null")
    public static NamedScopesHolder getHolder(Project project, String scopeName, NamedScopesHolder defaultHolder) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return holder;
        }
        return defaultHolder;
    }

    private static Element writeScope(NamedScope scope) {
        Element setElement = new Element(SCOPE_TAG);
        setElement.setAttribute(NAME_ATT, scope.getName());
        PackageSet packageSet = scope.getValue();
        setElement.setAttribute(PATTERN_ATT, packageSet != null ? packageSet.getText() : "");
        return setElement;
    }

    @NotNull
    private NamedScope readScope(Element setElement) {
        PackageSet set;
        String name = setElement.getAttributeValue(NAME_ATT);
        String attributeValue = setElement.getAttributeValue(PATTERN_ATT);
        try {
            set = PackageSetFactory.getInstance().compile(attributeValue);
        }
        catch (ParsingException e) {
            set = new InvalidPackageSet(attributeValue);
        }
        NamedScope namedScope = this.createScope(name, set);
        if (namedScope == null) {
            NamedScopesHolder.$$$reportNull$$$0(10);
        }
        return namedScope;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            NamedScopesHolder.$$$reportNull$$$0(11);
        }
        List sets = state.getChildren(SCOPE_TAG);
        this.myScopes = new NamedScope[sets.size()];
        for (int i = 0; i < sets.size(); ++i) {
            Element set = (Element)sets.get(i);
            this.myScopes[i] = this.readScope(set);
        }
        this.fireScopeListeners();
    }

    @Override
    @NotNull
    public Element getState() {
        Element element = new Element("state");
        for (NamedScope myScope : this.myScopes) {
            element.addContent(NamedScopesHolder.writeScope(myScope));
        }
        Element element2 = element;
        if (element2 == null) {
            NamedScopesHolder.$$$reportNull$$$0(12);
        }
        return element2;
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (NamedScope scope : this.myScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return this.getPredefinedScope(name);
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        List<NamedScope> list = Collections.emptyList();
        if (list == null) {
            NamedScopesHolder.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public NamedScope getPredefinedScope(@NotNull String name) {
        if (name == null) {
            NamedScopesHolder.$$$reportNull$$$0(14);
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NamedScopesHolder.$$$reportNull$$$0(15);
        }
        return project;
    }

    @NotNull
    public final NamedScope createScope(@NotNull String name, @Nullable PackageSet value) {
        if (name == null) {
            NamedScopesHolder.$$$reportNull$$$0(16);
        }
        NamedScope namedScope = new NamedScope(name, this.getIcon(), value);
        if (namedScope == null) {
            NamedScopesHolder.$$$reportNull$$$0(17);
        }
        return namedScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeListener";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/NamedScopesHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCOPE_TAG;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATT;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/NamedScopesHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableScopes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNamedScopeHolders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedScopes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addScopeListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeScopeListener";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setScopes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllNamedScopeHolders";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ScopeListener {
        public void scopesChanged();
    }
}

