/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.statistics.Statistician;
import com.intellij.psi.statistics.StatisticsInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatisticsManager {
    public static final int OBLIVION_THRESHOLD = 7;
    public static final int RECENCY_OBLIVION_THRESHOLD = 10000;
    private static final KeyedExtensionCollector<Statistician, Key> COLLECTOR = new KeyedExtensionCollector<Statistician, Key>("com.intellij.statistician"){

        @Override
        @NotNull
        protected String keyToString(@NotNull Key key) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = key.toString();
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/statistics/StatisticsManager$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/statistics/StatisticsManager$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "keyToString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "keyToString";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @Nullable
    public static <T, Loc> StatisticsInfo serialize(Key<? extends Statistician<T, Loc>> key, T element, Loc location) {
        for (Statistician statistician : COLLECTOR.forKey(key)) {
            StatisticsInfo info = statistician.serialize(element, location);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    public static StatisticsManager getInstance() {
        return ServiceManager.getService(StatisticsManager.class);
    }

    public abstract int getUseCount(@NotNull StatisticsInfo var1);

    public abstract int getLastUseRecency(@NotNull StatisticsInfo var1);

    public abstract void incUseCount(@NotNull StatisticsInfo var1);

    public <T, Loc> int getUseCount(Key<? extends Statistician<T, Loc>> key, T element, Loc location) {
        StatisticsInfo info = StatisticsManager.serialize(key, element, location);
        return info == null ? 0 : this.getUseCount(info);
    }

    public <T, Loc> void incUseCount(Key<? extends Statistician<T, Loc>> key, T element, Loc location) {
        StatisticsInfo info = StatisticsManager.serialize(key, element, location);
        if (info != null) {
            this.incUseCount(info);
        }
    }

    public abstract StatisticsInfo[] getAllValues(@NonNls String var1);
}

