/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageTargetUtil {
    private static final ExtensionPointName<UsageTargetProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.usageTargetProvider");

    public static UsageTarget[] findUsageTargets(@NotNull DataProvider dataProvider) {
        UsageTarget[] targets;
        PsiElement psiElement;
        UsageTarget[] targets2;
        if (dataProvider == null) {
            UsageTargetUtil.$$$reportNull$$$0(0);
        }
        Editor editor = CommonDataKeys.EDITOR.getData(dataProvider);
        PsiFile file = CommonDataKeys.PSI_FILE.getData(dataProvider);
        ArrayList result2 = new ArrayList();
        if (file != null && editor != null && (targets2 = UsageTargetUtil.findUsageTargets(editor, file)) != null) {
            Collections.addAll(result2, targets2);
        }
        if ((psiElement = CommonDataKeys.PSI_ELEMENT.getData(dataProvider)) != null && (targets = UsageTargetUtil.findUsageTargets(psiElement)) != null) {
            Collections.addAll(result2, targets);
        }
        return result2.isEmpty() ? null : result2.toArray(UsageTarget.EMPTY_ARRAY);
    }

    public static UsageTarget[] findUsageTargets(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            UsageTargetUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            UsageTargetUtil.$$$reportNull$$$0(2);
        }
        ArrayList result2 = new ArrayList();
        for (UsageTargetProvider provider : UsageTargetUtil.getProviders(file.getProject())) {
            UsageTarget[] targets = provider.getTargets(editor, file);
            if (targets == null) continue;
            Collections.addAll(result2, targets);
        }
        return result2.isEmpty() ? null : result2.toArray(UsageTarget.EMPTY_ARRAY);
    }

    public static UsageTarget[] findUsageTargets(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageTargetUtil.$$$reportNull$$$0(3);
        }
        ArrayList result2 = new ArrayList();
        for (UsageTargetProvider provider : UsageTargetUtil.getProviders(psiElement.getProject())) {
            UsageTarget[] targets = provider.getTargets(psiElement);
            if (targets == null) continue;
            Collections.addAll(result2, targets);
        }
        return result2.isEmpty() ? null : result2.toArray(UsageTarget.EMPTY_ARRAY);
    }

    @NotNull
    private static List<UsageTargetProvider> getProviders(@NotNull Project project) {
        if (project == null) {
            UsageTargetUtil.$$$reportNull$$$0(4);
        }
        List<UsageTargetProvider> list = DumbService.getDumbAwareExtensions(project, EP_NAME);
        if (list == null) {
            UsageTargetUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/UsageTargetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/UsageTargetUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsageTargets";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

