/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;

public abstract class SwingWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.concurrency.SwingWorker");
    private Object value;
    private final ModalityState myModalityState = ModalityState.current();
    private final ThreadVar myThreadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void onThrowable() {
    }

    public void interrupt() {
        Thread t = this.myThreadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.myThreadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.myThreadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created SwingWorker " + this + "with modality state " + this.myModalityState);
        }
        final Runnable doFinished = () -> this.finished();
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("construct() terminated for " + SwingWorker.this);
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                    SwingWorker.this.onThrowable();
                    throw new RuntimeException(e);
                }
                finally {
                    SwingWorker.this.myThreadVar.clear();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("invoking 'finished' action for " + SwingWorker.this);
                }
                ApplicationManager.getApplication().invokeLater(doFinished, SwingWorker.this.myModalityState);
            }
        };
        Thread workerThread = new Thread(doConstruct, "SwingWorker work thread");
        workerThread.setPriority(5);
        this.myThreadVar = new ThreadVar(workerThread);
    }

    public void start() {
        Thread t = this.myThreadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread myThread;

        ThreadVar(Thread t) {
            this.myThread = t;
        }

        synchronized Thread get() {
            return this.myThread;
        }

        synchronized void clear() {
            this.myThread = null;
        }
    }
}

