/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageViewExtension
extends CoverageViewExtension {
    private final JavaCoverageAnnotator myAnnotator;

    public JavaCoverageViewExtension(JavaCoverageAnnotator annotator, Project project, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        super(project, suitesBundle, stateBean);
        this.myAnnotator = annotator;
    }

    public String getSummaryForNode(AbstractTreeNode node) {
        if (!this.myCoverageViewManager.isReady()) {
            return "Loading...";
        }
        if (this.myCoverageDataManager.isSubCoverageActive()) {
            return JavaCoverageViewExtension.showSubCoverageNotification();
        }
        PsiPackage aPackage = (PsiPackage)node.getValue();
        String coverageInformationString = this.myAnnotator.getPackageCoverageInformationString(aPackage, null, this.myCoverageDataManager, this.myStateBean.myFlattenPackages);
        return JavaCoverageViewExtension.getNotCoveredMessage(coverageInformationString) + " in package '" + (aPackage != null ? aPackage.getQualifiedName() : node.getName()) + "'";
    }

    private static String showSubCoverageNotification() {
        return "Active per test coverage: no cumulative data is available";
    }

    public String getSummaryForRootNode(AbstractTreeNode childNode) {
        if (this.myCoverageDataManager.isSubCoverageActive()) {
            return JavaCoverageViewExtension.showSubCoverageNotification();
        }
        Object value = childNode.getValue();
        String coverageInformationString = this.myAnnotator.getPackageCoverageInformationString((PsiPackage)value, null, this.myCoverageDataManager);
        if (coverageInformationString == null) {
            if (!this.myCoverageViewManager.isReady()) {
                return "Loading...";
            }
            PackageAnnotator.SummaryCoverageInfo info = new PackageAnnotator.PackageCoverageInfo();
            Collection children = childNode.getChildren();
            for (Object child : children) {
                Object childValue = ((CoverageListNode)child).getValue();
                PackageAnnotator.SummaryCoverageInfo childInfo = this.getSummaryCoverageForNodeValue(childValue);
                info = JavaCoverageAnnotator.merge(info, childInfo);
            }
            coverageInformationString = JavaCoverageAnnotator.getCoverageInformationString(info, false);
        }
        return JavaCoverageViewExtension.getNotCoveredMessage(coverageInformationString) + " in 'all classes in scope'";
    }

    private static String getNotCoveredMessage(String coverageInformationString) {
        if (coverageInformationString == null) {
            coverageInformationString = "No coverage";
        }
        return coverageInformationString;
    }

    public String getPercentage(int columnIndex, AbstractTreeNode node) {
        Object value = node.getValue();
        PackageAnnotator.SummaryCoverageInfo info = this.getSummaryCoverageForNodeValue(value);
        if (columnIndex == 1) {
            return this.myAnnotator.getClassCoveredPercentage(info);
        }
        if (columnIndex == 2) {
            return this.myAnnotator.getMethodCoveredPercentage(info);
        }
        if (columnIndex == 3) {
            return this.myAnnotator.getLineCoveredPercentage(info);
        }
        if (columnIndex == 4) {
            return this.myAnnotator.getBranchCoveredPercentage(info);
        }
        return "";
    }

    public PackageAnnotator.SummaryCoverageInfo getSummaryCoverageForNodeValue(Object value) {
        if (value instanceof PsiClass) {
            String qualifiedName = ((PsiClass)value).getQualifiedName();
            return this.myAnnotator.getClassCoverageInfo(qualifiedName);
        }
        if (value instanceof PsiPackage) {
            return this.myAnnotator.getPackageCoverageInfo((PsiPackage)value, this.myStateBean.myFlattenPackages);
        }
        if (value instanceof PsiNamedElement) {
            return this.myAnnotator.getExtensionCoverageInfo((PsiNamedElement)value);
        }
        return null;
    }

    public PsiElement getElementToSelect(Object object) {
        PsiFile containingFile;
        PsiElement psiElement = super.getElementToSelect(object);
        if (psiElement != null && (containingFile = psiElement.getContainingFile()) instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)containingFile).getClasses();
            if (classes.length == 1) {
                return classes[0];
            }
            for (PsiClass aClass : classes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)psiElement, (boolean)false)) continue;
                return aClass;
            }
        }
        return psiElement;
    }

    public VirtualFile getVirtualFile(Object object) {
        if (object instanceof PsiPackage) {
            PsiDirectory[] directories = ((PsiPackage)object).getDirectories();
            return directories.length > 0 ? directories[0].getVirtualFile() : null;
        }
        return super.getVirtualFile(object);
    }

    @Nullable
    public PsiElement getParentElement(PsiElement element) {
        if (element instanceof PsiClass) {
            PsiDirectory containingDirectory = element.getContainingFile().getContainingDirectory();
            return containingDirectory != null ? JavaDirectoryService.getInstance().getPackage(containingDirectory) : null;
        }
        return ((PsiPackage)element).getParentPackage();
    }

    @NotNull
    public AbstractTreeNode createRootNode() {
        CoverageListRootNode coverageListRootNode = new CoverageListRootNode(this.myProject, (PsiNamedElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(""), this.mySuitesBundle, this.myStateBean);
        if (coverageListRootNode == null) {
            JavaCoverageViewExtension.$$$reportNull$$$0(0);
        }
        return coverageListRootNode;
    }

    public List<AbstractTreeNode> createTopLevelNodes() {
        LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
        LinkedHashSet<PsiClass> classes = new LinkedHashSet<PsiClass>();
        for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
            packages.addAll(((JavaCoverageSuite)suite).getCurrentSuitePackages(this.myProject));
            classes.addAll(((JavaCoverageSuite)suite).getCurrentSuiteClasses(this.myProject));
        }
        HashSet<PsiPackage> packs = new HashSet<PsiPackage>();
        block1: for (PsiPackage aPackage : packages) {
            String qualifiedName = aPackage.getQualifiedName();
            for (PsiPackage psiPackage : packages) {
                if (!psiPackage.getQualifiedName().startsWith(qualifiedName + ".")) continue;
                packs.add(psiPackage);
                continue block1;
            }
        }
        packages.removeAll(packs);
        ArrayList<AbstractTreeNode> topLevelNodes = new ArrayList<AbstractTreeNode>();
        for (PsiPackage aPackage : packages) {
            GlobalSearchScope searchScope;
            if (aPackage.getClasses(searchScope = this.mySuitesBundle.getSearchScope(this.myProject)).length != 0) {
                CoverageListNode node = new CoverageListNode(this.myProject, (PsiNamedElement)aPackage, this.mySuitesBundle, this.myStateBean);
                topLevelNodes.add((AbstractTreeNode)node);
            }
            this.collectSubPackages(topLevelNodes, aPackage);
        }
        for (PsiClass aClass : classes) {
            topLevelNodes.add((AbstractTreeNode)new CoverageListNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean));
        }
        return topLevelNodes;
    }

    private void collectSubPackages(List<AbstractTreeNode> children, PsiPackage rootPackage) {
        PsiPackage[] subPackages;
        GlobalSearchScope searchScope = this.mySuitesBundle.getSearchScope(rootPackage.getProject());
        for (PsiPackage aPackage : subPackages = (PsiPackage[])ReadAction.compute(() -> rootPackage.getSubPackages(searchScope))) {
            this.processSubPackage(aPackage, children);
        }
    }

    private void processSubPackage(PsiPackage aPackage, List<AbstractTreeNode> children) {
        if (((Boolean)ReadAction.compute(() -> this.isInCoverageScope((PsiElement)aPackage))).booleanValue()) {
            CoverageListNode node = new CoverageListNode(aPackage.getProject(), (PsiNamedElement)aPackage, this.mySuitesBundle, this.myStateBean);
            children.add((AbstractTreeNode)node);
        } else if (!this.myStateBean.myFlattenPackages) {
            this.collectSubPackages(children, aPackage);
        }
        if (this.myStateBean.myFlattenPackages) {
            this.collectSubPackages(children, aPackage);
        }
    }

    public List<AbstractTreeNode> getChildrenNodes(AbstractTreeNode node) {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        if (node instanceof CoverageListNode) {
            Object val = node.getValue();
            if (val instanceof PsiClass) {
                return Collections.emptyList();
            }
            if (val instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)val;
                if (((Boolean)ReadAction.compute(() -> this.isInCoverageScope((PsiElement)psiPackage))).booleanValue()) {
                    PsiFile[] childFiles;
                    PsiPackage[] subPackages;
                    for (PsiPackage subPackage : subPackages = (PsiPackage[])ReadAction.compute(() -> psiPackage.isValid() ? psiPackage.getSubPackages(this.mySuitesBundle.getSearchScope(node.getProject())) : PsiPackage.EMPTY_ARRAY)) {
                        this.processSubPackage(subPackage, children);
                    }
                    for (PsiFile file : childFiles = (PsiFile[])ReadAction.compute(() -> psiPackage.isValid() ? psiPackage.getFiles(this.mySuitesBundle.getSearchScope(node.getProject())) : PsiFile.EMPTY_ARRAY)) {
                        this.collectFileChildren(file, node, children);
                    }
                } else if (!this.myStateBean.myFlattenPackages) {
                    this.collectSubPackages(children, (PsiPackage)val);
                }
            }
            if (node instanceof CoverageListRootNode) {
                for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
                    List<PsiClass> classes = ((JavaCoverageSuite)suite).getCurrentSuiteClasses(this.myProject);
                    for (PsiClass aClass : classes) {
                        children.add((AbstractTreeNode)new CoverageListNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean));
                    }
                }
            }
            for (AbstractTreeNode childNode : children) {
                childNode.setParent(node);
            }
        }
        return children;
    }

    protected void collectFileChildren(PsiFile file, AbstractTreeNode node, List<? super AbstractTreeNode> children) {
        if (file instanceof PsiClassOwner) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = (PsiClass[])ReadAction.compute(() -> file.isValid() ? ((PsiClassOwner)file).getClasses() : PsiClass.EMPTY_ARRAY)) {
                if (!(node instanceof CoverageListRootNode) && this.getClassCoverageInfo(aClass) == null) continue;
                children.add((AbstractTreeNode)new CoverageListNode(this.myProject, (PsiNamedElement)aClass, this.mySuitesBundle, this.myStateBean));
            }
        }
    }

    @Nullable
    private PackageAnnotator.ClassCoverageInfo getClassCoverageInfo(PsiClass aClass) {
        return this.myAnnotator.getClassCoverageInfo((String)ReadAction.compute(() -> aClass.isValid() ? aClass.getQualifiedName() : null));
    }

    public ColumnInfo[] createColumnInfos() {
        ArrayList<Object> infos = new ArrayList<Object>();
        infos.add(new ElementColumnInfo());
        infos.add(new PercentageCoverageColumnInfo(1, "Class, %", this.mySuitesBundle, this.myStateBean));
        infos.add(new PercentageCoverageColumnInfo(2, "Method, %", this.mySuitesBundle, this.myStateBean));
        infos.add(new PercentageCoverageColumnInfo(3, "Line, %", this.mySuitesBundle, this.myStateBean));
        RunConfigurationBase runConfiguration = this.mySuitesBundle.getRunConfiguration();
        if (runConfiguration != null) {
            JavaCoverageEnabledConfiguration coverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(runConfiguration);
            if (coverageEnabledConfiguration != null) {
                this.isBranchColumnAvailable(infos, coverageEnabledConfiguration.getCoverageRunner(), coverageEnabledConfiguration.isSampling());
            }
        } else {
            CoverageSuite suite;
            CoverageRunner runner;
            CoverageSuite[] coverageSuiteArray = this.mySuitesBundle.getSuites();
            int n = coverageSuiteArray.length;
            for (int i = 0; i < n && !this.isBranchColumnAvailable(infos, runner = (suite = coverageSuiteArray[i]).getRunner(), true); ++i) {
            }
        }
        return infos.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    private boolean isBranchColumnAvailable(ArrayList<? super ColumnInfo> infos, CoverageRunner coverageRunner, boolean sampling) {
        if (coverageRunner instanceof JavaCoverageRunner && ((JavaCoverageRunner)coverageRunner).isBranchInfoAvailable(sampling)) {
            infos.add((ColumnInfo)new PercentageCoverageColumnInfo(4, "Branch, %", this.mySuitesBundle, this.myStateBean));
            return true;
        }
        return false;
    }

    private boolean isInCoverageScope(PsiElement element) {
        if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            String qualifiedName = psiPackage.getQualifiedName();
            for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
                if (!((JavaCoverageSuite)suite).isPackageFiltered(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canSelectInCoverageView(Object object) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = object instanceof VirtualFile ? PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) : null;
        if (psiFile instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)psiFile).getPackageName();
            return this.isInCoverageScope((PsiElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName));
        }
        if (object instanceof PsiPackage) {
            return this.isInCoverageScope((PsiElement)object);
        }
        return false;
    }

    public boolean supportFlattenPackages() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/view/JavaCoverageViewExtension", "createRootNode"));
    }
}

