/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.properties.psi.DefaultResourceBundleManager;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceBundleManager {
    private static final ExtensionPointName<ResourceBundleManager> RESOURCE_BUNDLE_MANAGER = ExtensionPointName.create((String)"com.intellij.java-i18n.resourceBundleManager");
    protected final Project myProject;

    protected ResourceBundleManager(Project project) {
        this.myProject = project;
    }

    @Nullable
    public abstract PsiClass getResourceBundle();

    public List<String> suggestPropertiesFiles() {
        return I18nUtil.defaultSuggestPropertiesFiles((Project)this.myProject);
    }

    @Nullable
    public I18nizedTextGenerator getI18nizedTextGenerator() {
        return null;
    }

    @Nullable
    @NonNls
    public abstract String getTemplateName();

    @Nullable
    @NonNls
    public abstract String getConcatenationTemplateName();

    public abstract boolean isActive(PsiFile var1) throws ResourceBundleNotFoundException;

    public abstract boolean canShowJavaCodeInfo();

    @Nullable
    public static ResourceBundleManager getManager(PsiFile context) throws ResourceBundleNotFoundException {
        Project project = context.getProject();
        for (ResourceBundleManager manager : (ResourceBundleManager[])RESOURCE_BUNDLE_MANAGER.getExtensions((AreaInstance)project)) {
            if (!manager.isActive(context)) continue;
            return manager;
        }
        DefaultResourceBundleManager manager = new DefaultResourceBundleManager(project);
        return manager.isActive(context) ? manager : null;
    }

    @Nullable
    public PropertyCreationHandler getPropertyCreationHandler() {
        return null;
    }

    @Nullable
    public String suggestPropertyKey(@NotNull String value) {
        if (value == null) {
            ResourceBundleManager.$$$reportNull$$$0(0);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/properties/psi/ResourceBundleManager", "suggestPropertyKey"));
    }

    public static class ResourceBundleNotFoundException
    extends Exception {
        private final IntentionAction myFix;

        public ResourceBundleNotFoundException(String message, IntentionAction setupResourceBundle) {
            super(message);
            this.myFix = setupResourceBundle;
        }

        public IntentionAction getFix() {
            return this.myFix;
        }
    }
}

