/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.reflect.TypeToken;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiContentHelper;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.GithubSearchResult;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001a*\u0004\b\u0000\u0010\u00012\u00020\u0002:\b\u001a\u001b\u001c\u001d\u001e\u001f !B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u0004R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\b\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "T", "", "url", "", "(Ljava/lang/String;)V", "acceptMimeType", "getAcceptMimeType", "()Ljava/lang/String;", "additionalHeaders", "", "getAdditionalHeaders", "()Ljava/util/Map;", "headers", "", "getHeaders", "operationName", "getOperationName", "setOperationName", "getUrl", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "withOperationName", "name", "Companion", "Delete", "Get", "Head", "Patch", "Post", "Put", "WithBody", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Head;", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "intellij.vcs.github"})
public abstract class GithubApiRequest<T> {
    @Nullable
    private String operationName;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final String url;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getOperationName() {
        return this.operationName;
    }

    public final void setOperationName(@Nullable String string) {
        this.operationName = string;
    }

    @Nullable
    public abstract String getAcceptMimeType();

    @NotNull
    protected final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Map<String, String> getAdditionalHeaders() {
        return this.headers;
    }

    public abstract T extractResult(@NotNull GithubApiResponse var1) throws IOException;

    @NotNull
    public final GithubApiRequest<T> withOperationName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.operationName = name;
        return this;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    private GithubApiRequest(String url) {
        Map map2;
        this.url = url;
        GithubApiRequest githubApiRequest = this;
        githubApiRequest.headers = map2 = (Map)new LinkedHashMap();
    }

    public /* synthetic */ GithubApiRequest(String url, DefaultConstructorMarker $constructor_marker) {
        this(url);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \t*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0006\t\n\u000b\f\r\u000eB\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "Companion", "Json", "JsonList", "JsonPage", "JsonSearchPage", "Optional", "intellij.vcs.github"})
    public static abstract class Get<T>
    extends GithubApiRequest<T> {
        @Nullable
        private final String acceptMimeType;
        public static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Get(@NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url, null);
            this.acceptMimeType = acceptMimeType;
        }

        @JvmOverloads
        public /* synthetic */ Get(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @JvmOverloads
        public Get(@NotNull String url) {
            this(url, null, 2, null);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u0007*\u0004\b\u0002\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0002\u0007\bB\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "url", "", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "Json", "intellij.vcs.github"})
        public static abstract class Optional<T>
        extends Get<T> {
            public static final Companion Companion = new Companion(null);

            @JvmOverloads
            public Optional(@NotNull String url, @Nullable String acceptMimeType) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                super(url, acceptMimeType);
            }

            @JvmOverloads
            public /* synthetic */ Optional(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @JvmOverloads
            public Optional(@NotNull String url) {
                this(url, null, 2, null);
            }

            @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00030\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\f\u001a\u00028\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00038\u0003 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00038\u0003\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "kotlin.jvm.PlatformType", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
            public static class Json<T>
            extends Optional<T> {
                private final TypeToken<T> typeToken;

                @Override
                public T extractResult(@NotNull GithubApiResponse response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    TypeToken<T> typeToken = this.typeToken;
                    Intrinsics.checkExpressionValueIsNotNull(typeToken, (String)"typeToken");
                    return (T)GithubApiRequest.Companion.parseJsonResponse(response, typeToken);
                }

                public Json(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                    super(url, acceptMimeType);
                    this.typeToken = TypeToken.get(clazz);
                }

                public /* synthetic */ Json(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 4) != 0) {
                        string2 = "application/vnd.github.v3+json";
                    }
                    this(string, clazz, string2);
                }
            }

            @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0003\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "T", "url", "", "acceptMimeType", "intellij.vcs.github"})
            public static final class Companion {
                private final <T> Optional<T> json(String url, String acceptMimeType) {
                    int $i$f$json = 0;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    return new Json<Object>(url, Object.class, acceptMimeType);
                }

                static /* synthetic */ Optional json$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                    if ((n & 2) != 0) {
                        acceptMimeType = null;
                    }
                    boolean $i$f$json = false;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    return new Json<Object>(url, Object.class, acceptMimeType);
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\f\u001a\u00028\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00028\u0002 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00028\u0002\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "kotlin.jvm.PlatformType", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Get<T> {
            private final TypeToken<T> typeToken;

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                TypeToken<T> typeToken = this.typeToken;
                Intrinsics.checkExpressionValueIsNotNull(typeToken, (String)"typeToken");
                return (T)GithubApiRequest.Companion.parseJsonResponse(response, typeToken);
            }

            public Json(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                super(url, acceptMimeType);
                this.typeToken = TypeToken.get(clazz);
            }

            public /* synthetic */ Json(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonList;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonList<T>
        extends Get<List<? extends T>> {
            private final TypeToken<List<T>> typeToken;

            @Override
            @NotNull
            public List<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                return (List)GithubApiRequest.Companion.parseJsonResponse(response, this.typeToken);
            }

            public JsonList(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                super(url, acceptMimeType);
                TypeToken typeToken = TypeToken.getParameterized((Type)((Type)((Object)List.class)), (Type[])new Type[]{clazz});
                if (typeToken == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.gson.reflect.TypeToken<kotlin.collections.List<T>>");
                }
                this.typeToken = typeToken;
            }

            public /* synthetic */ JsonList(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonPage;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonPage<T>
        extends Get<GithubResponsePage<T>> {
            private final TypeToken<List<T>> typeToken;

            @Override
            @NotNull
            public GithubResponsePage<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                return GithubResponsePage.Companion.parseFromHeader((List)GithubApiRequest.Companion.parseJsonResponse(response, this.typeToken), response.findHeader("Link"));
            }

            public JsonPage(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                super(url, acceptMimeType);
                TypeToken typeToken = TypeToken.getParameterized((Type)((Type)((Object)List.class)), (Type[])new Type[]{clazz});
                if (typeToken == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.gson.reflect.TypeToken<kotlin.collections.List<T>>");
                }
                this.typeToken = typeToken;
            }

            public /* synthetic */ JsonPage(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$JsonSearchPage;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "clazz", "Ljava/lang/Class;", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchResult;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonSearchPage<T>
        extends Get<GithubResponsePage<T>> {
            private final TypeToken<GithubSearchResult<T>> typeToken;

            @Override
            @NotNull
            public GithubResponsePage<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                List list2 = ((GithubSearchResult)GithubApiRequest.Companion.parseJsonResponse(response, this.typeToken)).getItems();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parseJsonResponse(response, typeToken).items");
                return GithubResponsePage.Companion.parseFromHeader(list2, response.findHeader("Link"));
            }

            public JsonSearchPage(@NotNull String url, @NotNull Class<T> clazz, @Nullable String acceptMimeType) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                super(url, acceptMimeType);
                TypeToken typeToken = TypeToken.getParameterized((Type)((Type)((Object)GithubSearchResult.class)), (Type[])new Type[]{clazz});
                if (typeToken == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.gson.reflect.TypeToken<org.jetbrains.plugins.github.api.data.GithubSearchResult<T>>");
                }
                this.typeToken = typeToken;
            }

            public /* synthetic */ JsonSearchPage(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string2 = "application/vnd.github.v3+json";
                }
                this(string, clazz, string2);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\bJ1\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\n0\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\bJ1\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\n0\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0086\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get;", "T", "url", "", "acceptMimeType", "jsonPage", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "jsonSearchPage", "intellij.vcs.github"})
        public static final class Companion {
            private final <T> Get<T> json(String url, String acceptMimeType) {
                int $i$f$json = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, Object.class, acceptMimeType);
            }

            static /* synthetic */ Get json$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, Object.class, acceptMimeType);
            }

            private final <T> Get<GithubResponsePage<T>> jsonPage(String url, String acceptMimeType) {
                int $i$f$jsonPage = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonPage<Object>(url, Object.class, acceptMimeType);
            }

            static /* synthetic */ Get jsonPage$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                boolean $i$f$jsonPage = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonPage<Object>(url, Object.class, acceptMimeType);
            }

            private final <T> Get<GithubResponsePage<T>> jsonSearchPage(String url, String acceptMimeType) {
                int $i$f$jsonSearchPage = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonSearchPage<Object>(url, Object.class, acceptMimeType);
            }

            static /* synthetic */ Get jsonSearchPage$default(Companion this_, String url, String acceptMimeType, int n, Object object) {
                if ((n & 2) != 0) {
                    acceptMimeType = null;
                }
                boolean $i$f$jsonSearchPage = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonSearchPage<Object>(url, Object.class, acceptMimeType);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Head;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "intellij.vcs.github"})
    public static abstract class Head<T>
    extends GithubApiRequest<T> {
        @Nullable
        private final String acceptMimeType;

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Head(@NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url, null);
            this.acceptMimeType = acceptMimeType;
        }

        @JvmOverloads
        public /* synthetic */ Head(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @JvmOverloads
        public Head(@NotNull String url) {
            this(url, null, 2, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "url", "", "(Ljava/lang/String;)V", "body", "getBody", "()Ljava/lang/String;", "bodyMimeType", "getBodyMimeType", "intellij.vcs.github"})
    public static abstract class WithBody<T>
    extends GithubApiRequest<T> {
        @Nullable
        public abstract String getBody();

        @NotNull
        public abstract String getBodyMimeType();

        public WithBody(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \r*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\r\u000eB+\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "body", "", "bodyMimeType", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "getBody", "getBodyMimeType", "Companion", "Json", "intellij.vcs.github"})
    public static abstract class Post<T>
    extends WithBody<T> {
        @NotNull
        private final String body;
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Post(@NotNull String body2, @NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url);
            this.body = body2;
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        @JvmOverloads
        public /* synthetic */ Post(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @JvmOverloads
        public Post(@NotNull String body2, @NotNull String bodyMimeType, @NotNull String url) {
            this(body2, bodyMimeType, url, null, 8, null);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "url", "", "body", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "kotlin.jvm.PlatformType", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Post<T> {
            private final TypeToken<T> typeToken;

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                TypeToken<T> typeToken = this.typeToken;
                Intrinsics.checkExpressionValueIsNotNull(typeToken, (String)"typeToken");
                return (T)GithubApiRequest.Companion.parseJsonResponse(response, typeToken);
            }

            public Json(@NotNull String url, @NotNull Object body2, @NotNull Class<T> clazz) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                super(GithubApiContentHelper.toJson(body2), "application/json", url, "application/vnd.github.v3+json");
                this.typeToken = TypeToken.get(clazz);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0086\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "url", "", "body", "intellij.vcs.github"})
        public static final class Companion {
            private final <T> Post<T> json(String url, Object body2) {
                int $i$f$json = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b&\u0018\u0000 \r*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\r\u000e\u000fB-\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "body", "", "bodyMimeType", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "getBody", "getBodyMimeType", "Companion", "Json", "JsonList", "intellij.vcs.github"})
    public static abstract class Put<T>
    extends WithBody<T> {
        @Nullable
        private final String body;
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;
        public static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public final String getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Put(@Nullable String body2, @NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkParameterIsNotNull((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url);
            this.body = body2;
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
            if (this.body == null) {
                Map<String, String> map2 = this.getHeaders();
                String string = "Content-Length";
                String string2 = "0";
                map2.put(string, string2);
            }
        }

        @JvmOverloads
        public /* synthetic */ Put(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @JvmOverloads
        public Put(@Nullable String body2, @NotNull String bodyMimeType, @NotNull String url) {
            this(body2, bodyMimeType, url, null, 8, null);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "url", "", "body", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "kotlin.jvm.PlatformType", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Put<T> {
            private final TypeToken<T> typeToken;

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                TypeToken<T> typeToken = this.typeToken;
                Intrinsics.checkExpressionValueIsNotNull(typeToken, (String)"typeToken");
                return (T)GithubApiRequest.Companion.parseJsonResponse(response, typeToken);
            }

            public Json(@NotNull String url, @Nullable Object body2, @NotNull Class<T> clazz) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                Json json = this;
                Object object = body2;
                if (object != null) {
                    Object object2 = object;
                    Json json2 = json;
                    Object it = object2;
                    boolean bl = false;
                    String string2 = GithubApiContentHelper.toJson(it);
                    json = json2;
                    string = string2;
                } else {
                    string = null;
                }
                super(string, "application/json", url, "application/vnd.github.v3+json");
                this.typeToken = TypeToken.get(clazz);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$JsonList;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "", "url", "", "clazz", "Ljava/lang/Class;", "body", "", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Object;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "intellij.vcs.github"})
        public static class JsonList<T>
        extends Put<List<? extends T>> {
            private final TypeToken<List<T>> typeToken;

            @Override
            @NotNull
            public List<T> extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                return (List)GithubApiRequest.Companion.parseJsonResponse(response, this.typeToken);
            }

            public JsonList(@NotNull String url, @NotNull Class<T> clazz, @Nullable Object body2) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                JsonList jsonList = this;
                Object object = body2;
                if (object != null) {
                    Object object2 = object;
                    JsonList jsonList2 = jsonList;
                    Object it = object2;
                    boolean bl = false;
                    String string2 = GithubApiContentHelper.toJson(it);
                    jsonList = jsonList2;
                    string = string2;
                } else {
                    string = null;
                }
                super(string, "application/json", url, "application/vnd.github.v3+json");
                TypeToken typeToken = TypeToken.getParameterized((Type)((Type)((Object)List.class)), (Type[])new Type[]{clazz});
                if (typeToken == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.gson.reflect.TypeToken<kotlin.collections.List<T>>");
                }
                this.typeToken = typeToken;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0086\bJ-\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\n0\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0086\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Put;", "T", "url", "", "body", "jsonList", "", "intellij.vcs.github"})
        public static final class Companion {
            private final <T> Put<T> json(String url, Object body2) {
                int $i$f$json = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            static /* synthetic */ Put json$default(Companion this_, String url, Object body2, int n, Object object) {
                if ((n & 2) != 0) {
                    body2 = null;
                }
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            private final <T> Put<List<T>> jsonList(String url, Object body2) {
                int $i$f$jsonList = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new JsonList<Object>(url, Object.class, body2);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \r*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\r\u000eB+\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "body", "", "bodyMimeType", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "getBody", "getBodyMimeType", "Companion", "Json", "intellij.vcs.github"})
    public static abstract class Patch<T>
    extends WithBody<T> {
        @NotNull
        private final String body;
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Patch(@NotNull String body2, @NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            Intrinsics.checkParameterIsNotNull((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url);
            this.body = body2;
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        @JvmOverloads
        public /* synthetic */ Patch(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @JvmOverloads
        public Patch(@NotNull String body2, @NotNull String bodyMimeType, @NotNull String url) {
            this(body2, bodyMimeType, url, null, 8, null);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "url", "", "body", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "kotlin.jvm.PlatformType", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Post<T> {
            private final TypeToken<T> typeToken;

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                TypeToken<T> typeToken = this.typeToken;
                Intrinsics.checkExpressionValueIsNotNull(typeToken, (String)"typeToken");
                return (T)GithubApiRequest.Companion.parseJsonResponse(response, typeToken);
            }

            public Json(@NotNull String url, @NotNull Object body2, @NotNull Class<T> clazz) {
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                super(GithubApiContentHelper.toJson(body2), "application/json", url, "application/vnd.github.v3+json");
                this.typeToken = TypeToken.get(clazz);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0086\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "T", "url", "", "body", "intellij.vcs.github"})
        public static final class Companion {
            private final <T> Post<T> json(String url, Object body2) {
                int $i$f$json = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u0000 \r*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\r\u000eB-\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$WithBody;", "body", "", "bodyMimeType", "url", "acceptMimeType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAcceptMimeType", "()Ljava/lang/String;", "getBody", "getBodyMimeType", "Companion", "Json", "intellij.vcs.github"})
    public static abstract class Delete<T>
    extends WithBody<T> {
        @Nullable
        private final String body;
        @NotNull
        private final String bodyMimeType;
        @Nullable
        private final String acceptMimeType;
        public static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public String getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public String getBodyMimeType() {
            return this.bodyMimeType;
        }

        @Override
        @Nullable
        public String getAcceptMimeType() {
            return this.acceptMimeType;
        }

        @JvmOverloads
        public Delete(@Nullable String body2, @NotNull String bodyMimeType, @NotNull String url, @Nullable String acceptMimeType) {
            Intrinsics.checkParameterIsNotNull((Object)bodyMimeType, (String)"bodyMimeType");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url);
            this.body = body2;
            this.bodyMimeType = bodyMimeType;
            this.acceptMimeType = acceptMimeType;
        }

        @JvmOverloads
        public /* synthetic */ Delete(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @JvmOverloads
        public Delete(@Nullable String body2, @NotNull String bodyMimeType, @NotNull String url) {
            this(body2, bodyMimeType, url, null, 8, null);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00018\u00028\u0002\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Json;", "T", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "url", "", "body", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;)V", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "kotlin.jvm.PlatformType", "extractResult", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;)Ljava/lang/Object;", "intellij.vcs.github"})
        public static class Json<T>
        extends Delete<T> {
            private final TypeToken<T> typeToken;

            @Override
            public T extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                TypeToken<T> typeToken = this.typeToken;
                Intrinsics.checkExpressionValueIsNotNull(typeToken, (String)"typeToken");
                return (T)GithubApiRequest.Companion.parseJsonResponse(response, typeToken);
            }

            public Json(@NotNull String url, @Nullable Object body2, @NotNull Class<T> clazz) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                Json json = this;
                Object object = body2;
                if (object != null) {
                    Object object2 = object;
                    Json json2 = json;
                    Object it = object2;
                    boolean bl = false;
                    String string2 = GithubApiContentHelper.toJson(it);
                    json = json2;
                    string = string2;
                } else {
                    string = null;
                }
                super(string, "application/json", url, "application/vnd.github.v3+json");
                this.typeToken = TypeToken.get(clazz);
            }

            public /* synthetic */ Json(String string, Object object, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    object = null;
                }
                this(string, object, clazz);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0002\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0086\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Companion;", "", "()V", "json", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Delete;", "T", "url", "", "body", "intellij.vcs.github"})
        public static final class Companion {
            private final <T> Delete<T> json(String url, Object body2) {
                int $i$f$json = 0;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            static /* synthetic */ Delete json$default(Companion this_, String url, Object body2, int n, Object object) {
                if ((n & 2) != 0) {
                    body2 = null;
                }
                boolean $i$f$json = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new Json<Object>(url, body2, Object.class);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0001\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequest$Companion;", "", "()V", "parseJsonResponse", "T", "response", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "(Lorg/jetbrains/plugins/github/api/GithubApiResponse;Lcom/google/gson/reflect/TypeToken;)Ljava/lang/Object;", "intellij.vcs.github"})
    public static final class Companion {
        private final <T> T parseJsonResponse(GithubApiResponse response, TypeToken<T> typeToken) {
            return response.readBody((ThrowableConvertor)new ThrowableConvertor<Reader, T, IOException>(typeToken){
                final /* synthetic */ TypeToken $typeToken;

                public final T convert(Reader it) {
                    Reader reader = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)reader, (String)"it");
                    return GithubApiContentHelper.readJson(reader, this.$typeToken);
                }
                {
                    this.$typeToken = typeToken;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

