/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitCommit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.pullrequest.ui.GithubDataLoadingComponent;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000  2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u00020\u0004:\u0005\u001f !\"#B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\b\u0010\u001b\u001a\u00020\u0015H\u0014J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubDataLoadingComponent;", "", "Lgit4idea/GitCommit;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "projectUiSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;)V", "backgroundLoadingPanel", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "changesBrowser", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$PullRequestChangesBrowserWithError;", "diffAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getDiffAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "dispose", "", "handleError", "error", "", "handleResult", "result", "reset", "setBusy", "busy", "", "CommitTagBrowserNode", "Companion", "MyTreeModelBuilder", "PullRequestChangesBrowserWithError", "ToggleZipCommitsAction", "intellij.vcs.github"})
public final class GithubPullRequestChangesComponent
extends GithubDataLoadingComponent<List<? extends GitCommit>>
implements Disposable {
    private final PullRequestChangesBrowserWithError changesBrowser;
    private final JBLoadingPanel loadingPanel;
    private final ProgressStripe backgroundLoadingPanel;
    @NotNull
    private final AnAction diffAction;
    private static final String DEFAULT_EMPTY_TEXT = "Select pull request to view list of changed files";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AnAction getDiffAction() {
        return this.diffAction;
    }

    @Override
    protected void reset() {
        this.changesBrowser.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.changesBrowser.setCommits(CollectionsKt.emptyList());
    }

    @Override
    protected void handleResult(@NotNull List<GitCommit> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        this.changesBrowser.getEmptyText().setText("Pull request does not contain any changes");
        this.changesBrowser.setCommits(result);
    }

    @Override
    protected void handleError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        StatusText statusText = this.changesBrowser.getEmptyText().clear().appendText("Can't load changes", SimpleTextAttributes.ERROR_ATTRIBUTES);
        String string = error.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        statusText.appendSecondaryText(string, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
    }

    @Override
    protected void setBusy(boolean busy) {
        if (busy) {
            if (UtilKt.isNullOrEmpty((Collection)this.changesBrowser.getCommits())) {
                this.changesBrowser.getEmptyText().clear();
                this.loadingPanel.startLoading();
            } else {
                this.backgroundLoadingPanel.startLoading();
            }
        } else {
            this.loadingPanel.stopLoading();
            this.backgroundLoadingPanel.stopLoading();
        }
    }

    public void dispose() {
    }

    public GithubPullRequestChangesComponent(@NotNull Project project, @NotNull GithubPullRequestsProjectUISettings projectUiSettings) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectUiSettings, (String)"projectUiSettings");
        this.changesBrowser = new PullRequestChangesBrowserWithError(project, projectUiSettings);
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        this.backgroundLoadingPanel = new ProgressStripe((JComponent)this.loadingPanel, (Disposable)this, 300);
        AnAction anAction = this.changesBrowser.getDiffAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"changesBrowser.diffAction");
        this.diffAction = anAction;
        this.loadingPanel.add((Component)((Object)this.changesBrowser), (Object)"Center");
        this.changesBrowser.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.setContent((JComponent)this.loadingPanel);
        Disposer.register((Disposable)this, (Disposable)this.changesBrowser);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R7\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$PullRequestChangesBrowserWithError;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserBase;", "Lcom/intellij/util/ui/ComponentWithEmptyText;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "projectUiSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;)V", "<set-?>", "", "Lgit4idea/GitCommit;", "commits", "getCommits", "()Ljava/util/List;", "setCommits", "(Ljava/util/List;)V", "commits$delegate", "Lkotlin/properties/ReadWriteProperty;", "buildTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "createViewerBorder", "Ljavax/swing/border/Border;", "dispose", "", "getEmptyText", "Lcom/intellij/util/ui/StatusText;", "intellij.vcs.github"})
    public static final class PullRequestChangesBrowserWithError
    extends ChangesBrowserBase
    implements ComponentWithEmptyText,
    Disposable {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty commits$delegate;
        private final GithubPullRequestsProjectUISettings projectUiSettings;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PullRequestChangesBrowserWithError.class), "commits", "getCommits()Ljava/util/List;"))};
        }

        @NotNull
        public final List<GitCommit> getCommits() {
            return (List)this.commits$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setCommits(@NotNull List<GitCommit> list2) {
            Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
            this.commits$delegate.setValue((Object)this, $$delegatedProperties[0], list2);
        }

        @NotNull
        public StatusText getEmptyText() {
            ChangesTree changesTree = this.myViewer;
            Intrinsics.checkExpressionValueIsNotNull((Object)changesTree, (String)"myViewer");
            StatusText statusText = changesTree.getEmptyText();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"myViewer.emptyText");
            return statusText;
        }

        @NotNull
        protected Border createViewerBorder() {
            Border border = IdeBorderFactory.createBorder((int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)border, (String)"IdeBorderFactory.createBorder(SideBorder.TOP)");
            return border;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected DefaultTreeModel buildTreeModel() {
            Project project = this.myProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
            ChangesGroupingPolicyFactory changesGroupingPolicyFactory = this.getGrouping();
            Intrinsics.checkExpressionValueIsNotNull((Object)changesGroupingPolicyFactory, (String)"grouping");
            MyTreeModelBuilder builder = new MyTreeModelBuilder(project, changesGroupingPolicyFactory);
            if (this.projectUiSettings.getZipChanges()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.reversed((Iterable)this.getCommits());
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    GitCommit it = (GitCommit)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getChanges();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list2 = CommittedChangesTreeBrowser.zipChanges((List)((List)destination$iv$iv));
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"CommittedChangesTreeBrow\u2026).flatMap { it.changes })");
                List zipped = list2;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder.setChanges(zipped, null), (String)"builder.setChanges(zipped, null)");
            } else {
                for (GitCommit commit : this.getCommits()) {
                    builder.addCommit(commit);
                }
            }
            DefaultTreeModel defaultTreeModel = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultTreeModel, (String)"builder.build()");
            return defaultTreeModel;
        }

        public void dispose() {
        }

        /*
         * WARNING - void declaration
         */
        public PullRequestChangesBrowserWithError(@NotNull Project project, @NotNull GithubPullRequestsProjectUISettings projectUiSettings) {
            void initialValue$iv;
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)projectUiSettings, (String)"projectUiSettings");
            super(project, false, false);
            this.projectUiSettings = projectUiSettings;
            Delegates delegates = Delegates.INSTANCE;
            PullRequestChangesBrowserWithError pullRequestChangesBrowserWithError = this;
            List list3 = list2 = CollectionsKt.emptyList();
            list2 = (ReadWriteProperty)new ObservableProperty<List<? extends GitCommit>>((Object)initialValue$iv, (Object)initialValue$iv, this){
                final /* synthetic */ Object $initialValue;
                final /* synthetic */ PullRequestChangesBrowserWithError this$0;
                {
                    this.$initialValue = $captured_local_variable$1;
                    this.this$0 = pullRequestChangesBrowserWithError;
                    super($super_call_param$2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                    Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                    List list2 = (List)newValue;
                    List list3 = (List)oldValue;
                    KProperty $noName_0 = property;
                    boolean bl = false;
                    PullRequestChangesBrowserWithError.access$getMyViewer$p(this.this$0).rebuildTree();
                }
            };
            pullRequestChangesBrowserWithError.commits$delegate = list2;
            this.projectUiSettings.addChangesListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    myViewer.rebuildTree();
                }
            }));
            this.init();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$MyTreeModelBuilder;", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;)V", "addCommit", "", "commit", "Lgit4idea/GitCommit;", "intellij.vcs.github"})
    private static final class MyTreeModelBuilder
    extends TreeModelBuilder {
        public final void addCommit(@NotNull GitCommit commit) {
            Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
            CommitTagBrowserNode parentNode = new CommitTagBrowserNode(commit);
            parentNode.markAsHelperNode();
            MutableTreeNode mutableTreeNode = (MutableTreeNode)((Object)parentNode);
            MutableTreeNode mutableTreeNode2 = (MutableTreeNode)this.myRoot;
            ChangesBrowserNode changesBrowserNode = this.myRoot;
            Intrinsics.checkExpressionValueIsNotNull((Object)changesBrowserNode, (String)"myRoot");
            this.myModel.insertNodeInto(mutableTreeNode, mutableTreeNode2, changesBrowserNode.getChildCount());
            for (Change change : commit.getChanges()) {
                this.insertChangeNode(change, parentNode, this.createChangeNode(change, null));
            }
        }

        public MyTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)grouping, (String)"grouping");
            super(project, grouping);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$CommitTagBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "", "commit", "Lgit4idea/GitCommit;", "(Lgit4idea/GitCommit;)V", "getCommit", "()Lgit4idea/GitCommit;", "getTextPresentation", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.vcs.github"})
    private static final class CommitTagBrowserNode
    extends ChangesBrowserNode<Object> {
        @NotNull
        private final GitCommit commit;

        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
            renderer.setIcon(AllIcons.Vcs.CommitNode);
            renderer.append(this.commit.getSubject(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            StringBuilder stringBuilder = new StringBuilder().append(" by ");
            VcsUser vcsUser = this.commit.getAuthor();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsUser, (String)"commit.author");
            renderer.append(stringBuilder.append(vcsUser.getName()).append(" on ").append(DateFormatUtil.formatDate((long)this.commit.getAuthorTime())).toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            StringBuilder stringBuilder2 = new StringBuilder().append("commit ").append(this.commit.getId().asString()).append('\n').append("Author: ");
            VcsUser vcsUser2 = this.commit.getAuthor();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsUser2, (String)"commit.author");
            String tooltip = stringBuilder2.append(vcsUser2.getName()).append('\n').append("Date: ").append(DateFormatUtil.formatDateTime((long)this.commit.getAuthorTime())).append("\n\n").append(this.commit.getFullMessage()).toString();
            renderer.setToolTipText(XmlStringUtil.escapeString((String)tooltip));
        }

        @NotNull
        public String getTextPresentation() {
            String string = this.commit.getSubject();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commit.subject");
            return string;
        }

        @NotNull
        public final GitCommit getCommit() {
            return this.commit;
        }

        public CommitTagBrowserNode(@NotNull GitCommit commit) {
            Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
            super((Object)commit);
            this.commit = commit;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$ToggleZipCommitsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.vcs.github"})
    public static final class ToggleZipCommitsAction
    extends ToggleAction
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            super.update(e);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(e.getData(ChangesBrowserBase.DATA_KEY) instanceof PullRequestChangesBrowserWithError);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return false");
            Project project2 = project;
            return !GithubPullRequestsProjectUISettings.Companion.getInstance(project2).getZipChanges();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
            Project project2 = project;
            GithubPullRequestsProjectUISettings.Companion.getInstance(project2).setZipChanges(!state2);
        }

        public ToggleZipCommitsAction() {
            super("Commit");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$Companion;", "", "()V", "DEFAULT_EMPTY_TEXT", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

