/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00040\f\"\u0004\b\u0000\u0010\u00042\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\f0\bH\u0007J0\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00042\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\f0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00040\fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAsyncUtil;", "", "()V", "awaitMutableFuture", "T", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "futureSupplier", "Lkotlin/Function0;", "Ljava/util/concurrent/Future;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "futureOfMutable", "Ljava/util/concurrent/CompletableFuture;", "handleToOtherIfCancelled", "", "other", "isCancellation", "", "error", "", "intellij.vcs.github"})
public final class GithubAsyncUtil {
    public static final GithubAsyncUtil INSTANCE;

    @JvmStatic
    public static final <T> T awaitMutableFuture(@NotNull ProgressIndicator progressIndicator, @NotNull Function0<? extends Future<T>> futureSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkParameterIsNotNull(futureSupplier, (String)"futureSupplier");
        T result = null;
        Future future = (Future)futureSupplier.invoke();
        while (true) {
            try {
                result = (T)future.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                progressIndicator.checkCanceled();
                continue;
            }
            catch (Exception e) {
                if (INSTANCE.isCancellation(e)) {
                    future = (Future)futureSupplier.invoke();
                    continue;
                }
                if (e instanceof ExecutionException) {
                    Throwable throwable = e.getCause();
                    if (throwable == null) {
                        throwable = e;
                    }
                    throw throwable;
                }
                throw (Throwable)e;
            }
            break;
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final <T> CompletableFuture<T> futureOfMutable(@NotNull Function0<? extends CompletableFuture<T>> futureSupplier) {
        Intrinsics.checkParameterIsNotNull(futureSupplier, (String)"futureSupplier");
        CompletableFuture result = new CompletableFuture();
        INSTANCE.handleToOtherIfCancelled(futureSupplier, result);
        return result;
    }

    private final <T> void handleToOtherIfCancelled(Function0<? extends CompletableFuture<T>> futureSupplier, CompletableFuture<T> other) {
        ((CompletableFuture)futureSupplier.invoke()).handle(new BiFunction<T, Throwable, U>(other, futureSupplier){
            final /* synthetic */ CompletableFuture $other;
            final /* synthetic */ Function0 $futureSupplier;

            public final void apply(T result, Throwable error) {
                if (result != null) {
                    this.$other.complete(result);
                }
                if (error != null) {
                    if (GithubAsyncUtil.INSTANCE.isCancellation(error)) {
                        GithubAsyncUtil.access$handleToOtherIfCancelled(GithubAsyncUtil.INSTANCE, this.$futureSupplier, this.$other);
                    }
                    this.$other.completeExceptionally(error.getCause());
                }
            }
            {
                this.$other = completableFuture;
                this.$futureSupplier = function0;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCancellation(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        if (error instanceof ProcessCanceledException) return true;
        if (error instanceof CancellationException) return true;
        if (error instanceof InterruptedException) return true;
        Throwable throwable = error.getCause();
        if (throwable == null) return false;
        Throwable throwable2 = throwable;
        GithubAsyncUtil githubAsyncUtil = this;
        Throwable p1 = throwable2;
        boolean bl = false;
        boolean bl2 = githubAsyncUtil.isCancellation(p1);
        if (!bl2) return false;
        return true;
    }

    private GithubAsyncUtil() {
    }

    static {
        GithubAsyncUtil githubAsyncUtil;
        INSTANCE = githubAsyncUtil = new GithubAsyncUtil();
    }

    public static final /* synthetic */ void access$handleToOtherIfCancelled(GithubAsyncUtil $this, Function0 futureSupplier, CompletableFuture other) {
        $this.handleToOtherIfCancelled(futureSupplier, other);
    }
}

