/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.CompilerPhase;
import org.jetbrains.kotlin.backend.common.CompilerPhases;
import org.jetbrains.kotlin.backend.common.PhaseRunner;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004BG\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001e\u001a\u00020\u001f2\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dH\u0002J\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J9\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\"0\u0000\"\u0004\b\u0002\u0010\"2\u0006\u0010#\u001a\u0002H\"2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\"0\n\u00a2\u0006\u0002\u0010%J/\u0010 \u001a\u00028\u00012\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d2\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010'R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/CompilerPhaseManager;", "Context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "Data", "", "context", "phases", "Lorg/jetbrains/kotlin/backend/common/CompilerPhases;", "data", "phaseRunner", "Lorg/jetbrains/kotlin/backend/common/PhaseRunner;", "parent", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/CompilerPhases;Ljava/lang/Object;Lorg/jetbrains/kotlin/backend/common/PhaseRunner;Lorg/jetbrains/kotlin/backend/common/CompilerPhaseManager;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "depth", "", "getDepth", "()I", "getParent", "()Lorg/jetbrains/kotlin/backend/common/CompilerPhaseManager;", "getPhases", "()Lorg/jetbrains/kotlin/backend/common/CompilerPhases;", "previousPhases", "", "Lorg/jetbrains/kotlin/backend/common/CompilerPhase;", "checkPrerequisite", "", "phase", "createChild", "NewData", "newData", "newPhaseRunner", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/backend/common/PhaseRunner;)Lorg/jetbrains/kotlin/backend/common/CompilerPhaseManager;", "source", "(Lorg/jetbrains/kotlin/backend/common/CompilerPhase;Lorg/jetbrains/kotlin/backend/common/BackendContext;Ljava/lang/Object;)Ljava/lang/Object;", "ir.backend.common"})
public final class CompilerPhaseManager<Context extends BackendContext, Data> {
    private final int depth;
    private final Set<CompilerPhase<Context, Data>> previousPhases;
    @NotNull
    private final Context context;
    @NotNull
    private final CompilerPhases phases;
    private final Data data;
    private final PhaseRunner<Context, Data> phaseRunner;
    @Nullable
    private final CompilerPhaseManager<Context, ?> parent;

    public final int getDepth() {
        return this.depth;
    }

    @NotNull
    public final <NewData> CompilerPhaseManager<Context, NewData> createChild(NewData newData, @NotNull PhaseRunner<Context, NewData> newPhaseRunner) {
        Intrinsics.checkParameterIsNotNull(newPhaseRunner, (String)"newPhaseRunner");
        return new CompilerPhaseManager<Context, NewData>(this.context, this.phases, newData, newPhaseRunner, this);
    }

    @NotNull
    public final CompilerPhaseManager<Context, Data> createChild() {
        return this.createChild(this.data, this.phaseRunner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkPrerequisite(CompilerPhase<?, ?> phase) {
        if (CollectionsKt.contains((Iterable)this.previousPhases, phase)) return true;
        CompilerPhaseManager<Context, ?> compilerPhaseManager = this.parent;
        if (compilerPhaseManager == null) return false;
        if (!super.checkPrerequisite(phase)) return false;
        return true;
    }

    public final Data phase(@NotNull CompilerPhase<? super Context, Data> phase, @NotNull Context context, Data source) {
        Intrinsics.checkParameterIsNotNull(phase, (String)"phase");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (!this.phases.getEnabled().contains(phase)) {
            return source;
        }
        Iterable $receiver$iv = phase.getPrerequisite();
        for (Object element$iv : $receiver$iv) {
            CompilerPhase it = (CompilerPhase)element$iv;
            if (this.checkPrerequisite(it)) continue;
            throw (Throwable)new Error(phase + " requires " + it);
        }
        this.previousPhases.add(phase);
        this.phaseRunner.runBefore(phase, this.depth, context, source);
        Data result2 = this.phaseRunner.runBody(phase, context, source);
        this.phaseRunner.runAfter(phase, this.depth, context, result2);
        return result2;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final CompilerPhases getPhases() {
        return this.phases;
    }

    public final Data getData() {
        return this.data;
    }

    @Nullable
    public final CompilerPhaseManager<Context, ?> getParent() {
        return this.parent;
    }

    public CompilerPhaseManager(@NotNull Context context, @NotNull CompilerPhases phases, Data data, @NotNull PhaseRunner<Context, Data> phaseRunner, @Nullable CompilerPhaseManager<Context, ?> parent2) {
        Set set2;
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)phases, (String)"phases");
        Intrinsics.checkParameterIsNotNull(phaseRunner, (String)"phaseRunner");
        this.context = context;
        this.phases = phases;
        this.data = data;
        this.phaseRunner = phaseRunner;
        CompilerPhaseManager<Context, ?> compilerPhaseManager = this.parent = parent2;
        this.depth = compilerPhaseManager != null ? compilerPhaseManager.depth + 1 : 0;
        CompilerPhaseManager compilerPhaseManager2 = this;
        compilerPhaseManager2.previousPhases = set2 = (Set)new LinkedHashSet();
    }

    public /* synthetic */ CompilerPhaseManager(BackendContext backendContext, CompilerPhases compilerPhases, Object object, PhaseRunner phaseRunner, CompilerPhaseManager compilerPhaseManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            compilerPhaseManager = null;
        }
        this(backendContext, compilerPhases, object, phaseRunner, compilerPhaseManager);
    }
}

