/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class FunctionGenerationStrategy {
    public abstract void generateBody(@NotNull MethodVisitor var1, @NotNull FrameMap var2, @NotNull JvmMethodSignature var3, @NotNull MethodContext var4, @NotNull MemberCodegen<?> var5);

    public abstract boolean skipNotNullAssertionsForParameters();

    public boolean skipGenericSignature() {
        return false;
    }

    public MethodVisitor wrapMethodVisitor(@NotNull MethodVisitor mv, int access, @NotNull String name2, @NotNull String desc) {
        return mv;
    }

    @NotNull
    public JvmMethodGenericSignature mapMethodSignature(@NotNull FunctionDescriptor functionDescriptor2, @NotNull KotlinTypeMapper typeMapper2, @NotNull OwnerKind contextKind, boolean hasSpecialBridge) {
        return typeMapper2.mapSignatureWithGeneric(functionDescriptor2, contextKind, hasSpecialBridge);
    }

    public static abstract class CodegenBased
    extends FunctionGenerationStrategy {
        protected final GenerationState state;

        public CodegenBased(@NotNull GenerationState state) {
            this.state = state;
        }

        @Override
        public final void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
            ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), context, this.state, parentCodegen);
            this.doGenerateBody(codegen, signature);
        }

        @Override
        public boolean skipNotNullAssertionsForParameters() {
            return false;
        }

        public abstract void doGenerateBody(@NotNull ExpressionCodegen var1, @NotNull JvmMethodSignature var2);
    }

    public static class FunctionDefault
    extends CodegenBased {
        private final KtDeclarationWithBody declaration;

        public FunctionDefault(@NotNull GenerationState state, @NotNull KtDeclarationWithBody declaration2) {
            super(state);
            this.declaration = declaration2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            KtExpression bodyExpression = this.declaration.getBodyExpression();
            assert (bodyExpression != null) : "Function has no body: " + PsiUtilsKt.getElementTextWithContext(this.declaration);
            codegen.returnExpression(bodyExpression);
        }
    }
}

