/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.DefaultCodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinCodegenFacade {
    public static void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        state.beforeCompile();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCodegenFacade.doGenerateFiles(state.getFiles(), state, errorHandler);
    }

    public static void doGenerateFiles(@NotNull Collection<KtFile> files2, @NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        state.getCodegenFactory().generateModule(state, files2, errorHandler);
        CodegenFactory.Companion.doCheckCancelled(state);
        state.getFactory().done();
    }

    public static void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<KtFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        DefaultCodegenFactory.INSTANCE.generatePackage(state, packageFqName, jetFiles, errorHandler);
    }

    private KotlinCodegenFacade() {
    }
}

