/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleAbstractMultiplatformModuleBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u0015X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleMobileSharedMultiplatformModuleBuilder;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleAbstractMultiplatformModuleBuilder;", "()V", "commonName", "", "commonSourceName", "getCommonSourceName", "()Ljava/lang/String;", "commonTestName", "getCommonTestName", "jvmSourceName", "getJvmSourceName", "jvmTargetName", "jvmTestName", "getJvmTestName", "nativeSourceName", "getNativeSourceName", "nativeTargetName", "nativeTestName", "getNativeTestName", "shouldEnableGradleMetadataPreview", "", "getShouldEnableGradleMetadataPreview", "()Z", "buildMultiPlatformPart", "createProjectSkeleton", "", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBuilderId", "getDescription", "getPresentableName", "idea-gradle"})
public final class KotlinGradleMobileSharedMultiplatformModuleBuilder
extends KotlinGradleAbstractMultiplatformModuleBuilder {
    private final String commonName = "common";
    private String jvmTargetName = "jvm";
    private String nativeTargetName = "ios";
    private final boolean shouldEnableGradleMetadataPreview = true;

    private final String getCommonSourceName() {
        return this.commonName + "Main";
    }

    private final String getCommonTestName() {
        return this.commonName + "Test";
    }

    private final String getJvmSourceName() {
        return this.jvmTargetName + "Main";
    }

    private final String getJvmTestName() {
        return this.jvmTargetName + "Test";
    }

    private final String getNativeSourceName() {
        return this.nativeTargetName + "Main";
    }

    @NotNull
    public final String getNativeTestName() {
        return this.nativeTargetName + "Test";
    }

    @Override
    protected boolean getShouldEnableGradleMetadataPreview() {
        return this.shouldEnableGradleMetadataPreview;
    }

    @NotNull
    public String getBuilderId() {
        return "kotlin.gradle.multiplatform.mobileshared";
    }

    @NotNull
    public String getPresentableName() {
        return "Kotlin (Mobile Shared Library)";
    }

    @NotNull
    public String getDescription() {
        return "Multiplatform Gradle projects allow sharing the same Kotlin code between two mobile platforms (JVM/Android, Native).";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProjectSkeleton(@NotNull VirtualFile rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        VirtualFile virtualFile = rootDir.createChildDirectory((Object)this, "src");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"rootDir.createChildDirectory(this, \"src\")");
        VirtualFile src = virtualFile;
        BufferedWriter commonMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonSourceName(), null, null, null, 14, null);
        BufferedWriter commonTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonTestName(), null, null, "SampleTests.kt", 6, null);
        BufferedWriter jvmMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmSourceName(), this.jvmTargetName, null, null, 12, null);
        BufferedWriter jvmTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmTestName(), null, null, "SampleTestsJVM.kt", 6, null);
        BufferedWriter nativeMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeSourceName(), this.nativeTargetName, null, null, 12, null);
        BufferedWriter nativeTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeTestName(), null, null, "SampleTestsNative.kt", 6, null);
        try {
            commonMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                expect class Sample() {\n                    fun checkMe(): Int\n                }\n\n                expect object Platform {\n                    fun name(): String\n                }\n\n                fun hello(): String = \"Hello from ${Platform.name()}\"\n            "));
            jvmMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                actual class Sample {\n                    actual fun checkMe() = 42\n                }\n\n                actual object Platform {\n                    actual fun name(): String = \"JVM\"\n                }\n            "));
            nativeMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                actual class Sample {\n                    actual fun checkMe() = 7\n                }\n\n                actual object Platform {\n                    actual fun name(): String = \"iOS\"\n                }\n            "));
            commonTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTests {\n                    @Test\n                    fun testMe() {\n                        assertTrue(Sample().checkMe() > 0)\n                    }\n                }\n            "));
            jvmTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTestsJVM {\n                    @Test\n                    fun testHello() {\n                        assertTrue(\"JVM\" in hello())\n                    }\n                }\n            "));
            nativeTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTestsNative {\n                    @Test\n                    fun testHello() {\n                        assertTrue(\"iOS\" in hello())\n                    }\n                }\n            "));
        }
        catch (Throwable throwable) {
            Iterable $receiver$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, nativeMain, nativeTest});
            for (Object element$iv : $receiver$iv) {
                BufferedWriter p1 = (BufferedWriter)element$iv;
                p1.close();
            }
            throw throwable;
        }
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, nativeMain, nativeTest});
        for (Object element$iv : $receiver$iv) {
            BufferedWriter p1 = (BufferedWriter)element$iv;
            p1.close();
        }
    }

    @Override
    @NotNull
    protected String buildMultiPlatformPart() {
        return StringsKt.trimIndent((String)("\n            group 'com.example'\n            version '0.0.1'\n\n            apply plugin: 'maven-publish'\n\n            kotlin {\n                jvm()\n                // This is for iPhone emulator\n                // Switch here to iosArm64 (or iosArm32) to build library for iPhone device\n                iosX64(\"" + this.nativeTargetName + "\") {\n                    compilations.main.outputKinds(\"framework\")\n                }\n                sourceSets {\n                    " + this.getCommonSourceName() + " {\n                        dependencies {\n                            implementation kotlin('stdlib-common')\n                        }\n                    }\n                    " + this.getCommonTestName() + " {\n                        dependencies {\n                            implementation kotlin('test-common')\n                            implementation kotlin('test-annotations-common')\n                        }\n                    }\n                    " + this.getJvmSourceName() + " {\n                        dependencies {\n                            implementation kotlin('stdlib')\n                        }\n                    }\n                    " + this.getJvmTestName() + " {\n                        dependencies {\n                            implementation kotlin('test')\n                            implementation kotlin('test-junit')\n                        }\n                    }\n                    " + this.getNativeSourceName() + " {\n                    }\n                    " + this.getNativeTestName() + " {\n                    }\n                }\n            }\n\n            configurations {\n                compileClasspath\n            }\n        "));
    }

    public KotlinGradleMobileSharedMultiplatformModuleBuilder() {
        super(false, 1, null);
    }
}

