/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.DataNodeUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinMPPDataNodesKt;
import org.jetbrains.kotlin.idea.configuration.KotlinSourceSetInfo;
import org.jetbrains.kotlin.idea.configuration.KotlinTargetData;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinTargetDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinTargetData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "idea-gradle"})
public final class KotlinTargetDataService
extends AbstractProjectDataService<KotlinTargetData, Void> {
    @NotNull
    public Key<KotlinTargetData> getTargetDataKey() {
        return KotlinTargetData.Companion.getKEY();
    }

    public void importData(@NotNull Collection<DataNode<KotlinTargetData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        for (DataNode<KotlinTargetData> nodeToImport : toImport) {
            Artifact it;
            Artifact artifact;
            String artifactName;
            ModifiableArtifactModel artifactModel;
            File archiveFile;
            Object object = nodeToImport.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeToImport.data");
            KotlinTargetData targetData = (KotlinTargetData)((Object)object);
            if (targetData.getArchiveFile() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)modelsProvider.getModifiableArtifactModel(), (String)"modelsProvider.modifiableArtifactModel");
            Intrinsics.checkExpressionValueIsNotNull((Object)FileUtil.getNameWithoutExtension((File)archiveFile), (String)"FileUtil.getNameWithoutExtension(archiveFile)");
            Artifact artifact2 = artifactModel.findArtifact(artifactName);
            if (artifact2 != null) {
                it = artifact = artifact2;
                artifactModel.removeArtifact(it);
            }
            Artifact artifact3 = it = (artifact = artifactModel.addArtifact(artifactName, (ArtifactType)JarArtifactType.getInstance()));
            Intrinsics.checkExpressionValueIsNotNull((Object)artifact3, (String)"it");
            artifact3.setOutputPath(archiveFile.getParent());
            for (String moduleId : targetData.getModuleIds()) {
                Module moduleToPackage;
                ModuleData compilationData;
                KotlinSourceSetInfo kotlinSourceSet;
                DataNode<? extends ModuleData> dataNode = nodeToImport.getParent();
                if (dataNode == null || (dataNode = DataNodeUtilsKt.findChildModuleById(dataNode, moduleId)) == null) {
                    continue;
                }
                DataNode<? extends ModuleData> compilationModuleDataNode = dataNode;
                if ((ModuleData)compilationModuleDataNode.getData() == null) {
                    continue;
                }
                if (KotlinMPPDataNodesKt.getKotlinSourceSet(compilationModuleDataNode) == null) {
                    continue;
                }
                if (kotlinSourceSet.isTestModule()) continue;
                if (modelsProvider.findIdeModule(compilationData) == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleToPackage, (String)"modelsProvider.findIdeMo\u2026pilationData) ?: continue");
                it.getRootElement().addOrFindChild((PackagingElement)new ProductionModuleOutputPackagingElement(project, ProjectRootsUtilKt.createPointer(moduleToPackage)));
            }
        }
    }
}

