/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUMap;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesFileAttributeKt;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.ScriptNewDependenciesNotificationKt;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptContentLoader;
import org.jetbrains.kotlin.script.ScriptContentLoaderKt;
import org.jetbrains.kotlin.script.ScriptReportSink;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH$J\b\u0010\u001e\u001a\u00020\u0016H\u0004J \u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J \u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\"H$J\u0016\u0010#\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependenciesLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "contentLoader", "Lorg/jetbrains/kotlin/script/ScriptContentLoader;", "getContentLoader", "()Lorg/jetbrains/kotlin/script/ScriptContentLoader;", "fileModificationStamps", "Lcom/intellij/util/containers/SLRUMap;", "", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "reporter", "Lorg/jetbrains/kotlin/script/ScriptReportSink;", "attachReportsIfChanged", "", "result", "Lkotlin/script/experimental/dependencies/DependenciesResolver$ResolveResult;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptDef", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "loadDependencies", "notifyRootsChanged", "processResult", "saveDependencies", "shouldShowNotification", "", "updateDependencies", "idea-core"})
public abstract class ScriptDependenciesLoader {
    private final SLRUMap<String, Long> fileModificationStamps;
    @NotNull
    private final ScriptContentLoader contentLoader;
    @NotNull
    private final ScriptDependenciesCache cache;
    private final ScriptReportSink reporter;
    @NotNull
    private final Project project;

    public final void updateDependencies(@NotNull VirtualFile file, @NotNull KotlinScriptDefinition scriptDef) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)((Object)scriptDef), (String)"scriptDef");
                if (this.cache.get(file) == null) break block2;
                Long l = (Long)this.fileModificationStamps.get((Object)file.getPath());
                long l2 = file.getModificationStamp();
                if (l != null && l == l2) break block3;
            }
            this.fileModificationStamps.put((Object)file.getPath(), (Object)file.getModificationStamp());
            this.loadDependencies(file, scriptDef);
        }
    }

    protected abstract void loadDependencies(@NotNull VirtualFile var1, @NotNull KotlinScriptDefinition var2);

    protected abstract boolean shouldShowNotification();

    @NotNull
    protected final ScriptContentLoader getContentLoader() {
        return this.contentLoader;
    }

    @NotNull
    protected final ScriptDependenciesCache getCache() {
        return this.cache;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void processResult(@NotNull DependenciesResolver.ResolveResult result2, @NotNull VirtualFile file, @NotNull KotlinScriptDefinition scriptDef) {
        ScriptDependencies newDependencies;
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scriptDef), (String)"scriptDef");
        if (this.cache.get(file) == null) {
            this.saveDependencies(result2, file, scriptDef);
            this.attachReportsIfChanged(result2, file, scriptDef);
            return;
        }
        ScriptDependencies scriptDependencies2 = result2.getDependencies();
        Object object = newDependencies = scriptDependencies2 != null ? ScriptContentLoaderKt.adjustByDefinition(scriptDependencies2, scriptDef) : null;
        if (!(Intrinsics.areEqual((Object)this.cache.get(file), (Object)newDependencies) ^ true)) {
            this.attachReportsIfChanged(result2, file, scriptDef);
            if (!this.shouldShowNotification()) return;
            ScriptNewDependenciesNotificationKt.removeScriptDependenciesNotificationPanel(file, this.project);
            return;
        }
        if (this.shouldShowNotification()) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                ScriptNewDependenciesNotificationKt.addScriptDependenciesNotificationPanel(file, result2, this.project, (Function1<? super DependenciesResolver.ResolveResult, Unit>)((Function1)new Function1<DependenciesResolver.ResolveResult, Unit>(this, file, scriptDef){
                    final /* synthetic */ ScriptDependenciesLoader this$0;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ KotlinScriptDefinition $scriptDef;

                    public final void invoke(@NotNull DependenciesResolver.ResolveResult it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        ScriptDependenciesLoader.access$saveDependencies(this.this$0, it, this.$file, this.$scriptDef);
                        ScriptDependenciesLoader.access$attachReportsIfChanged(this.this$0, it, this.$file, this.$scriptDef);
                    }
                    {
                        this.this$0 = scriptDependenciesLoader;
                        this.$file = virtualFile;
                        this.$scriptDef = kotlinScriptDefinition;
                        super(1);
                    }
                }));
                return;
            }
        }
        this.saveDependencies(result2, file, scriptDef);
        this.attachReportsIfChanged(result2, file, scriptDef);
    }

    private final void attachReportsIfChanged(DependenciesResolver.ResolveResult result2, VirtualFile file, KotlinScriptDefinition scriptDef) {
        List list2;
        List list3 = result2.getReports();
        List list4 = (List)file.getUserData((Key)IdeScriptReportSink.Reports.INSTANCE);
        List it = list3;
        Collection collection = it;
        List list5 = list2 = !collection.isEmpty() ? list3 : null;
        if (Intrinsics.areEqual((Object)list4, (Object)list2) ^ true) {
            this.reporter.attachReports(file, result2.getReports());
        }
    }

    private final void saveDependencies(DependenciesResolver.ResolveResult result2, VirtualFile file, KotlinScriptDefinition scriptDef) {
        ScriptDependencies scriptDependencies2;
        if (this.shouldShowNotification()) {
            ScriptNewDependenciesNotificationKt.removeScriptDependenciesNotificationPanel(file, this.project);
        }
        if ((scriptDependencies2 = result2.getDependencies()) == null || (scriptDependencies2 = ScriptContentLoaderKt.adjustByDefinition(scriptDependencies2, scriptDef)) == null) {
            return;
        }
        ScriptDependencies dependencies2 = scriptDependencies2;
        boolean rootsChanged = this.cache.hasNotCachedRoots(dependencies2);
        if (this.cache.save(file, dependencies2)) {
            ScriptDependenciesFileAttributeKt.setScriptDependencies(file, dependencies2);
        }
        if (rootsChanged) {
            this.notifyRootsChanged();
        }
    }

    protected final void notifyRootsChanged() {
        Runnable doNotifyRootsChanged2 = new Runnable(this){
            final /* synthetic */ ScriptDependenciesLoader this$0;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ notifyRootsChanged.doNotifyRootsChanged.1 this$0;

                    public final void invoke() {
                        if (this.this$0.this$0.getProject().isDisposed()) {
                            return;
                        }
                        ProjectRootManagerEx projectRootManagerEx = ProjectRootManagerEx.getInstanceEx((Project)this.this$0.this$0.getProject());
                        if (projectRootManagerEx != null) {
                            projectRootManagerEx.makeRootsChange(EmptyRunnable.getInstance(), false, true);
                        }
                        ScriptDependenciesModificationTracker.Companion.getInstance(this.this$0.this$0.getProject()).incModificationCount();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = scriptDependenciesLoader;
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            TransactionGuard.submitTransaction((Disposable)((Disposable)this.project), (Runnable)doNotifyRootsChanged2);
        } else {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.project, doNotifyRootsChanged2);
        }
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public ScriptDependenciesLoader(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.fileModificationStamps = new SLRUMap(10, 10);
        this.contentLoader = new ScriptContentLoader(this.project);
        Object object = ServiceManager.getService((Project)this.project, ScriptDependenciesCache.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026denciesCache::class.java)");
        this.cache = (ScriptDependenciesCache)object;
        Object object2 = ServiceManager.getService((Project)this.project, ScriptReportSink.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"ServiceManager.getServic\u2026ptReportSink::class.java)");
        this.reporter = (ScriptReportSink)object2;
    }

    public static final /* synthetic */ void access$saveDependencies(ScriptDependenciesLoader $this, DependenciesResolver.ResolveResult result2, VirtualFile file, KotlinScriptDefinition scriptDef) {
        $this.saveDependencies(result2, file, scriptDef);
    }

    public static final /* synthetic */ void access$attachReportsIfChanged(ScriptDependenciesLoader $this, DependenciesResolver.ResolveResult result2, VirtualFile file, KotlinScriptDefinition scriptDef) {
        $this.attachReportsIfChanged(result2, file, scriptDef);
    }
}

