/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClsStubBuilder$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileContent", "", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "Companion", "idea-core"})
public class KotlinClsStubBuilder
extends ClsStubBuilder {
    @NotNull
    private static final Logger LOG;
    private static final String VERSIONED_PATH_MARKER = "!/META-INF/versions/";
    public static final Companion Companion;

    public int getStubVersion() {
        return 92;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"content.file");
        VirtualFile virtualFile2 = virtualFile;
        if (ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile2, content2.getContent())) {
            return null;
        }
        if (Companion.isVersioned(virtualFile2)) {
            return null;
        }
        byte[] byArray = content2.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"content.content");
        return this.doBuildFileStub(virtualFile2, byArray);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiFileStub<KtFile> doBuildFileStub(VirtualFile file, byte[] fileContent) {
        PsiFileStub psiFileStub;
        FqName fqName2;
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = IDEKotlinBinaryClassCache.INSTANCE.getKotlinBinaryClass(file, fileContent);
        if (kotlinJvmBinaryClass2 == null) {
            String string = "Can't find binary class for Kotlin file: " + file;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinJvmBinaryClass kotlinClass = kotlinJvmBinaryClass2;
        KotlinClassHeader header = kotlinClass.getClassHeader();
        ClassId classId = kotlinClass.getClassId();
        String string = header.getPackageName();
        if (string != null) {
            String string2;
            String it = string2 = string;
            fqName2 = new FqName(it);
        } else {
            FqName fqName3 = classId.getPackageFqName();
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"classId.packageFqName");
        }
        FqName packageFqName = fqName2;
        if (!header.getMetadataVersion().isCompatible()) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file, packageFqName, fileContent);
        if (header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS) {
            List<KotlinJvmBinaryClass> partFiles = ClassFileDecompilerUtilKt.findMultifileClassParts(file, classId, header.getMultifilePartNames());
            FqName fqName4 = classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"classId.asSingleFqName()");
            return ClsStubBuildingKt.createMultifileClassStub(header, partFiles, fqName4, components);
        }
        String[] annotationData = header.getData();
        if (annotationData == null) {
            LOG.error("Corrupted kotlin header for file " + file.getName());
            return null;
        }
        String[] strings = header.getStrings();
        if (strings == null) {
            LOG.error("String table not found in file " + file.getName());
            return null;
        }
        switch (KotlinClsStubBuilder$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                void nameResolver2;
                if (classId.isLocal()) {
                    return null;
                }
                Pair<JvmNameResolver, ProtoBuf.Class> pair2 = JvmProtoBufUtil.readClassDataFrom(annotationData, strings);
                JvmNameResolver jvmNameResolver = (JvmNameResolver)pair2.component1();
                ProtoBuf.Class classProto = (ProtoBuf.Class)pair2.component2();
                NameResolver nameResolver3 = (NameResolver)nameResolver2;
                ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
                ClsStubBuilderContext context = components.createContext(nameResolver3, packageFqName, new TypeTable(typeTable));
                psiFileStub = ClsStubBuildingKt.createTopLevelClassStub(classId, classProto, new KotlinJvmBinarySourceElement(kotlinClass, null, false, 6, null), context, header.isScript());
                break;
            }
            case 2: {
                String string3;
                String it;
                Object context = JvmProtoBufUtil.readPackageDataFrom(annotationData, strings);
                JvmNameResolver nameResolver2 = (JvmNameResolver)context.component1();
                ProtoBuf.Package packageProto = (ProtoBuf.Package)context.component2();
                NameResolver nameResolver4 = nameResolver2;
                ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
                context = components.createContext(nameResolver4, packageFqName, new TypeTable(typeTable));
                Object object = header.getPackageName();
                if (object == null || (object = new ClassId(new FqName(it = (string3 = object)), classId.getRelativeClassName(), classId.isLocal()).asSingleFqName()) == null) {
                    object = classId.asSingleFqName();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"header.packageName?.let \u2026 classId.asSingleFqName()");
                Object fqName5 = object;
                psiFileStub = ClsStubBuildingKt.createFileFacadeStub(packageProto, (FqName)fqName5, context);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Should have processed " + file.getPath() + " with header " + header);
            }
        }
        return psiFileStub;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName, byte[] fileContent) {
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedClassFinder classFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        DirectoryBasedDataFinder classDataFinder2 = new DirectoryBasedDataFinder(classFinder, LOG);
        AnnotationLoaderForClassFileStubBuilder annotationLoader = new AnnotationLoaderForClassFileStubBuilder(classFinder, file, fileContent);
        return new ClsStubBuilderComponents(classDataFinder2, annotationLoader, file);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinClsStubBuilder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026sStubBuilder::class.java)");
        LOG = logger;
        VERSIONED_PATH_MARKER = VERSIONED_PATH_MARKER;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/KotlinClsStubBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "VERSIONED_PATH_MARKER", "", "isVersioned", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final boolean isVersioned(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            String string = virtualFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"virtualFile.path");
            return StringsKt.contains$default((CharSequence)string, (CharSequence)VERSIONED_PATH_MARKER, (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

