/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.configuration.KotlinMigrationProjectComponentKt;
import org.jetbrains.kotlin.idea.configuration.MigrationInfo;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.inspections.gradle.DeprecatedGradleDependencyInspection;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspection;
import org.jetbrains.kotlin.idea.inspections.gradle.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.inspections.gradle.GradleKotlinxCoroutinesDeprecationInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.migration.CoroutinesObsoleteLibrariesKt;
import org.jetbrains.kotlin.idea.inspections.migration.DeprecatedForKotlinLibInfo;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/GradleKotlinxCoroutinesDeprecationInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "isApplicable", "", "migrationInfo", "Lorg/jetbrains/kotlin/idea/configuration/MigrationInfo;", "DependencyFinder", "idea-gradle"})
public final class GradleKotlinxCoroutinesDeprecationInspection
extends GradleBaseInspection
implements CleanupLocalInspectionTool,
MigrationFix {
    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkParameterIsNotNull((Object)migrationInfo, (String)"migrationInfo");
        return KotlinMigrationProjectComponentKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_2, LanguageVersion.KOTLIN_1_3);
    }

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new DependencyFinder();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/GradleKotlinxCoroutinesDeprecationInspection$DependencyFinder;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "()V", "checkKotlinVersion", "", "file", "Lcom/intellij/psi/PsiFile;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "reportOnElement", "Lcom/intellij/psi/PsiElement;", "classpathEntry", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "deprecatedForKotlinInfo", "Lorg/jetbrains/kotlin/idea/inspections/migration/DeprecatedForKotlinLibInfo;", "visitClosure", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "idea-gradle"})
    private static class DependencyFinder
    extends KotlinGradleInspectionVisitor {
        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $receiver$iv = (PsiElement)closure;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            GrExpression grExpression = dependenciesCall.getInvokedExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"dependenciesCall.invokedExpression");
            if (Intrinsics.areEqual((Object)grExpression.getText(), (Object)"dependencies") ^ true) {
                return;
            }
            List<GrCallExpression> dependencyEntries = GradleHeuristicHelper.INSTANCE.findStatementWithPrefixes(closure, GradleHeuristicHelper.INSTANCE.getPRODUCTION_DEPENDENCY_STATEMENTS());
            block0: for (GrCallExpression dependencyStatement : dependencyEntries) {
                for (DeprecatedForKotlinLibInfo outdatedInfo : CoroutinesObsoleteLibrariesKt.getDEPRECATED_COROUTINES_LIBRARIES_INFORMATION()) {
                    LocalQuickFix[] localQuickFixArray;
                    String dependencyText = dependencyStatement.getText();
                    String libMarker = GradleKotlinxCoroutinesDeprecationInspectionKt.access$getGradleMarker$p(outdatedInfo.getLib());
                    String string = dependencyText;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependencyText");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)libMarker, (boolean)false, (int)2, null)) continue;
                    PsiFile psiFile = dependencyStatement.getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"dependencyStatement.containingFile");
                    if (!this.checkKotlinVersion(psiFile, outdatedInfo.getSinceKotlinLanguageVersion())) {
                        return;
                    }
                    PsiFile psiFile2 = dependencyStatement.getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"dependencyStatement.containingFile");
                    String string2 = DifferentStdlibGradleVersionInspection.Companion.getResolvedLibVersion(psiFile2, outdatedInfo.getLib().getGroupId(), CollectionsKt.listOf((Object)outdatedInfo.getLib().getName()));
                    if (string2 == null) {
                        PsiFile psiFile3 = dependencyStatement.getContainingFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"dependencyStatement.containingFile");
                        string2 = DeprecatedGradleDependencyInspection.Companion.libraryVersionFromOrderEntry(psiFile3, outdatedInfo.getLib().getName());
                    }
                    if (string2 == null) {
                        continue;
                    }
                    String libVersion = string2;
                    String updatedVersion = outdatedInfo.getVersionUpdater().updateVersion(libVersion);
                    if (Intrinsics.areEqual((Object)libVersion, (Object)updatedVersion) || StringsKt.contains$default((CharSequence)dependencyText, (CharSequence)updatedVersion, (boolean)false, (int)2, null)) continue;
                    PsiElement reportOnElement = this.reportOnElement(dependencyStatement, outdatedInfo);
                    ReplaceStringInDocumentFix fix = StringsKt.contains$default((CharSequence)dependencyText, (CharSequence)libVersion, (boolean)false, (int)2, null) ? new ReplaceStringInDocumentFix(reportOnElement, libVersion, updatedVersion) : null;
                    DependencyFinder dependencyFinder = this;
                    PsiElement psiElement2 = reportOnElement;
                    String string3 = outdatedInfo.getMessage();
                    if (fix != null) {
                        localQuickFixArray = new ReplaceStringInDocumentFix[]{fix};
                    } else {
                        String string4 = string3;
                        PsiElement psiElement3 = psiElement2;
                        DependencyFinder dependencyFinder2 = dependencyFinder;
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{};
                        dependencyFinder = dependencyFinder2;
                        psiElement2 = psiElement3;
                        string3 = string4;
                        localQuickFixArray = localQuickFixArray2;
                    }
                    dependencyFinder.registerError(psiElement2, string3, localQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    continue block0;
                }
            }
        }

        private final PsiElement reportOnElement(GrCallExpression classpathEntry, DeprecatedForKotlinLibInfo deprecatedForKotlinInfo) {
            String string = classpathEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classpathEntry.text");
            int indexOf = StringsKt.indexOf$default((CharSequence)string, (String)deprecatedForKotlinInfo.getLib().getName(), (int)0, (boolean)false, (int)6, null);
            if (indexOf < 0) {
                return (PsiElement)classpathEntry;
            }
            PsiElement psiElement2 = classpathEntry.findElementAt(indexOf);
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)classpathEntry;
            }
            return psiElement2;
        }

        private final boolean checkKotlinVersion(PsiFile file, LanguageVersion languageVersion) {
            boolean bl;
            block4: {
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)file.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(file.project)");
                Module module = projectRootManager.getFileIndex().getModuleForFile(file.getVirtualFile());
                if (module == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ProjectRootManager.getIn\u2026tualFile) ?: return false");
                Module module2 = module;
                ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.getWholeModuleGroup(module2);
                Iterable $receiver$iv = moduleGroup.getSourceRootModules();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Module moduleInGroup = (Module)element$iv;
                        if (!(PlatformKt.getLanguageVersionSettings(moduleInGroup).getLanguageVersion().compareTo((Enum)languageVersion) >= 0)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

