/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.SimplifyNegatedBinaryExpressionInspection;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u001a\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertAssertToIfWithThrowIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractMessageSingleExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isApplicableTo", "", "caretOffset", "", "messageIsFunction", "callExpr", "replaceWithIfThenThrowExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "original", "simplifyConditionIfPossible", "ifExpression", "idea"})
public final class ConvertAssertToIfWithThrowIntention
extends SelfTargetingIntention<KtCallExpression>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        if (ktExpression == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.calleeExpression ?: return false");
        KtExpression callee = ktExpression;
        if (!callee.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        int argumentSize = element3.getValueArguments().size();
        int n = argumentSize;
        if (1 > n || 2 < n) {
            return false;
        }
        List<KtLambdaArgument> list2 = element3.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.lambdaArguments");
        List<KtLambdaArgument> functionLiterals = list2;
        if (functionLiterals.size() > 1) {
            return false;
        }
        if (functionLiterals.size() == 1 && argumentSize == 1) {
            return false;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(element3, null, 1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtils.getFqName((DeclarationDescriptor)resolvedCall3.getResultingDescriptor()).asString(), (Object)"kotlin.assert");
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor2) {
        String string;
        KtCallExpression assertionErrorCall;
        KtCallExpression ktCallExpression;
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtValueArgument messageFunctionExpr;
        KtValueArgument ktValueArgument;
        KtElement ktElement;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        List<KtValueArgument> list2 = element3.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.valueArguments");
        List<KtValueArgument> args = list2;
        Object object = args.get(0);
        if (object == null || (object = ((KtValueArgument)object).getArgumentExpression()) == null || (object = object.getText()) == null) {
            return;
        }
        Object conditionText = object;
        List<KtLambdaArgument> list3 = element3.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"element.lambdaArguments");
        KtLambdaArgument functionLiteralArgument = (KtLambdaArgument)CollectionsKt.singleOrNull(list3);
        BindingContext bindingContext2 = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL_WITH_CFA);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        if (args.size() == 2) {
            ktElement = args.get(1);
            if (ktElement == null || (ktElement = ((KtValueArgument)ktElement).getArgumentExpression()) == null) {
                return;
            }
        } else {
            ktElement = functionLiteralArgument != null ? (KtExpression)functionLiteralArgument.getLambdaExpression() : null;
        }
        if (!((ktValueArgument = (messageFunctionExpr = ktElement)) instanceof KtLambdaExpression)) {
            ktValueArgument = null;
        }
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)((Object)ktValueArgument);
        if (ktLambdaExpression != null) {
            KtLambdaExpression ktLambdaExpression2;
            KtLambdaExpression it = ktLambdaExpression2 = ktLambdaExpression;
            ktExpression2 = this.extractMessageSingleExpression(it, bindingContext2);
        } else {
            ktExpression2 = null;
        }
        KtExpression extractedMessageSingleExpr = ktExpression2;
        boolean messageIsFunction = extractedMessageSingleExpr == null && this.messageIsFunction(element3, bindingContext2);
        KtElement ktElement2 = extractedMessageSingleExpr;
        if (ktElement2 == null) {
            ktElement2 = ktExpression = messageFunctionExpr;
        }
        if (ktElement2 == null) {
            ktExpression = psiFactory.createExpression("\"Assertion failed\"");
        }
        KtExpression messageExpr = ktExpression;
        KtIfExpression ifExpression2 = this.replaceWithIfThenThrowExpression(element3);
        KtExpression ktExpression3 = ifExpression2.getThen();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ifExpression.then!!");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktExpression3, null, 2, null);
        KtExpression ktExpression4 = ifExpression2.getCondition();
        if (ktExpression4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrefixExpression");
        }
        KtPrefixExpression ifCondition = (KtPrefixExpression)ktExpression4;
        KtExpression ktExpression5 = ifCondition.getBaseExpression();
        if (ktExpression5 == null) {
            Intrinsics.throwNpe();
        }
        ktExpression5.replace((PsiElement)psiFactory.createExpression((String)conditionText));
        KtExpression ktExpression6 = ifExpression2.getThen();
        if (ktExpression6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        List<KtExpression> list4 = ((KtBlockExpression)ktExpression6).getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"(ifExpression.then as Kt\u2026ockExpression).statements");
        Object object2 = CollectionsKt.single(list4);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThrowExpression");
        }
        KtExpression thrownExpression = ((KtThrowExpression)object2).getThrownExpression();
        KtExpression ktExpression7 = thrownExpression;
        if (!(ktExpression7 instanceof KtCallExpression)) {
            ktExpression7 = null;
        }
        if ((ktCallExpression = (KtCallExpression)ktExpression7) == null) {
            KtExpression ktExpression8 = thrownExpression;
            if (ktExpression8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            }
            KtExpression ktExpression9 = ((KtDotQualifiedExpression)ktExpression8).getSelectorExpression();
            if (ktExpression9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            ktCallExpression = assertionErrorCall = (KtCallExpression)ktExpression9;
        }
        if (messageIsFunction && messageExpr instanceof KtCallableReferenceExpression) {
            StringBuilder stringBuilder = new StringBuilder();
            KtSimpleNameExpression ktSimpleNameExpression = ((KtCallableReferenceExpression)messageExpr).getCallableReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"messageExpr.callableReference");
            string = stringBuilder.append(ktSimpleNameExpression.getText()).append("()").toString();
        } else {
            string = messageIsFunction ? messageExpr.getText() + "()" : messageExpr.getText();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (messageIsFunction &&\u2026pr.text\n                }");
        KtExpression message2 = psiFactory.createExpression(string);
        List<KtValueArgument> list5 = assertionErrorCall.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list5, (String)"assertionErrorCall.valueArguments");
        KtExpression ktExpression10 = ((KtValueArgument)CollectionsKt.single(list5)).getArgumentExpression();
        if (ktExpression10 == null) {
            Intrinsics.throwNpe();
        }
        ktExpression10.replace((PsiElement)message2);
        this.simplifyConditionIfPossible(ifExpression2, editor2);
    }

    private final KtExpression extractMessageSingleExpression(KtLambdaExpression functionLiteral, BindingContext bindingContext2) {
        Object object;
        Object singleStatement;
        Object object2;
        Object it;
        Object object3 = functionLiteral.getBodyExpression();
        return object3 != null && (object3 = ((KtBlockExpression)object3).getStatements()) != null && (object3 = (KtExpression)CollectionsKt.singleOrNull((List)object3)) != null ? (BindingContextUtilsKt.isUsedAsExpression((KtExpression)(it = (object2 = (singleStatement = (object = object3)))), bindingContext2) ? object2 : null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean messageIsFunction(KtCallExpression callExpr, BindingContext bindingContext2) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpr, bindingContext2);
        if (resolvedCall2 == null) return false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> list2 = resolvedCall3.getResultingDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.resultingDescriptor.valueParameters");
        List<ValueParameterDescriptor> valParameters = list2;
        if (valParameters.size() <= 1) return false;
        ValueParameterDescriptor valueParameterDescriptor = valParameters.get(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"valParameters[1]");
        if (KotlinBuiltIns.isAny(valueParameterDescriptor.getType())) return false;
        return true;
    }

    private final void simplifyConditionIfPossible(KtIfExpression ifExpression2, Editor editor2) {
        KtExpression ktExpression = ifExpression2.getCondition();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrefixExpression");
        }
        SimplifyNegatedBinaryExpressionInspection simplifier = new SimplifyNegatedBinaryExpressionInspection();
        KtPrefixExpression condition2 = (KtPrefixExpression)ktExpression;
        if (simplifier.isApplicable(condition2)) {
            KtSimpleNameExpression ktSimpleNameExpression = condition2.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"condition.operationReference");
            AbstractApplicabilityBasedInspection.applyTo$default(simplifier, (PsiElement)ktSimpleNameExpression, null, editor2, 2, null);
        }
    }

    private final KtIfExpression replaceWithIfThenThrowExpression(KtCallExpression original) {
        KtExpression ktExpression;
        block14: {
            PsiElement psiElement2;
            PsiElement result$iv;
            PsiElement $receiver$iv;
            KtIfExpression replacement2;
            block13: {
                KtExpression ktExpression2;
                KtExpression ktExpression3 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)original, false, 2, null).createExpression("if (!true) { throw kotlin.AssertionError(\"\") }");
                if (ktExpression3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                }
                replacement2 = (KtIfExpression)ktExpression3;
                PsiElement parent2 = original.getParent();
                PsiElement psiElement3 = parent2;
                if (!(psiElement3 instanceof KtDotQualifiedExpression)) {
                    psiElement3 = null;
                }
                if ((ktExpression = (KtDotQualifiedExpression)psiElement3) == null) break block13;
                $receiver$iv = (PsiElement)ktExpression;
                result$iv = $receiver$iv.replace((PsiElement)replacement2);
                PsiElement psiElement4 = result$iv;
                if (!(psiElement4 instanceof KtIfExpression)) {
                    psiElement4 = null;
                }
                if ((ktExpression2 = (KtIfExpression)psiElement4) == null) {
                    PsiElement psiElement5 = result$iv;
                    if (psiElement5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression4 = ((KtParenthesizedExpression)psiElement5).getExpression();
                    if (ktExpression4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                    }
                    ktExpression2 = ktExpression = (KtIfExpression)ktExpression4;
                }
                if (ktExpression2 != null) break block14;
            }
            if (!((psiElement2 = (result$iv = ($receiver$iv = (PsiElement)original).replace((PsiElement)replacement2))) instanceof KtIfExpression)) {
                psiElement2 = null;
            }
            if ((ktExpression = (KtIfExpression)psiElement2) == null) {
                PsiElement psiElement6 = result$iv;
                if (psiElement6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression5 = ((KtParenthesizedExpression)psiElement6).getExpression();
                if (ktExpression5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                }
                ktExpression = (KtIfExpression)ktExpression5;
            }
        }
        return ktExpression;
    }

    public ConvertAssertToIfWithThrowIntention() {
        super(KtCallExpression.class, "Replace 'assert' with 'if' statement", null, 4, null);
    }
}

