/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveTypeVarianceFix$WhenMappings;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveTypeVarianceFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "typeParameter", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "type", "", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lorg/jetbrains/kotlin/types/Variance;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class RemoveTypeVarianceFix
extends KotlinQuickFixAction<KtTypeParameter> {
    private final Variance variance;
    private final String type;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Remove '" + this.variance.getLabel() + "' variance from '" + this.type + '\'';
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        block5: {
            KtModifierKeywordToken ktModifierKeywordToken;
            KtModifierKeywordToken ktModifierKeywordToken2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtTypeParameter ktTypeParameter = (KtTypeParameter)this.getElement();
            if (ktTypeParameter == null) {
                return;
            }
            KtTypeParameter typeParameter = ktTypeParameter;
            switch (RemoveTypeVarianceFix$WhenMappings.$EnumSwitchMapping$0[this.variance.ordinal()]) {
                case 1: {
                    ktModifierKeywordToken2 = KtTokens.IN_KEYWORD;
                    break;
                }
                case 2: {
                    ktModifierKeywordToken2 = KtTokens.OUT_KEYWORD;
                    break;
                }
                default: {
                    ktModifierKeywordToken2 = null;
                }
            }
            if (ktModifierKeywordToken2 == null) break block5;
            KtModifierKeywordToken it = ktModifierKeywordToken = ktModifierKeywordToken2;
            typeParameter.removeModifier(it);
        }
    }

    public RemoveTypeVarianceFix(@NotNull KtTypeParameter typeParameter, @NotNull Variance variance, @NotNull String type2) {
        Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)variance), (String)"variance");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)typeParameter);
        this.variance = variance;
        this.type = type2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveTypeVarianceFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtTypeParameter> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement psiElement3 = psiElement2.getParent();
            if (!(psiElement3 instanceof KtTypeReference)) {
                psiElement3 = null;
            }
            KtTypeReference ktTypeReference = (KtTypeReference)psiElement3;
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference typeReference = ktTypeReference;
            KotlinType kotlinType2 = (KotlinType)ResolutionUtils.analyze(typeReference, BodyResolveMode.PARTIAL).get(BindingContext.TYPE, typeReference);
            if (kotlinType2 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"typeReference.analyze(Bo\u2026Reference] ?: return null");
            KotlinType type2 = kotlinType2;
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
            if (typeParameterDescriptor == null) {
                return null;
            }
            TypeParameterDescriptor descriptor2 = typeParameterDescriptor;
            Variance variance = descriptor2.getVariance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance), (String)"descriptor.variance");
            Variance variance2 = variance;
            if (variance2 == Variance.INVARIANT) {
                return null;
            }
            PsiElement psiElement4 = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
            if (!(psiElement4 instanceof KtTypeParameter)) {
                psiElement4 = null;
            }
            KtTypeParameter ktTypeParameter = (KtTypeParameter)psiElement4;
            if (ktTypeParameter == null) {
                return null;
            }
            KtTypeParameter typeParameter = ktTypeParameter;
            return new RemoveTypeVarianceFix(typeParameter, variance2, IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(type2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

