/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfo;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfoKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0006H\u0002R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/ExtractableSubstringInfo;", "", "startEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "endEntry", "prefix", "", "suffix", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;)V", "content", "getContent", "()Ljava/lang/String;", "contentRange", "Lcom/intellij/openapi/util/TextRange;", "getContentRange", "()Lcom/intellij/openapi/util/TextRange;", "getEndEntry", "()Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "entries", "Lkotlin/sequences/Sequence;", "getEntries", "()Lkotlin/sequences/Sequence;", "getPrefix", "relativeContentRange", "getRelativeContentRange", "getStartEntry", "getSuffix", "template", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getTemplate", "()Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "copy", "newTemplate", "createExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "guessLiteralType", "literal", "ide-common"})
public final class ExtractableSubstringInfo {
    @NotNull
    private final KtStringTemplateExpression template;
    @NotNull
    private final String content;
    @NotNull
    private final KotlinType type;
    @NotNull
    private final KtStringTemplateEntry startEntry;
    @NotNull
    private final KtStringTemplateEntry endEntry;
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;

    private final KotlinType guessLiteralType(String literal) {
        ResolutionFacade facade = ResolutionUtils.getResolutionFacade(this.template);
        ModuleDescriptor module = facade.getModuleDescriptor();
        SimpleType simpleType2 = module.getBuiltIns().getStringType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"module.builtIns.stringType");
        SimpleType stringType = simpleType2;
        if (Intrinsics.areEqual((Object)this.startEntry, (Object)this.endEntry) ^ true || !(this.startEntry instanceof KtLiteralStringTemplateEntry)) {
            return stringType;
        }
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)this.startEntry, false, 2, null).createExpressionIfPossible(literal);
        if (ktExpression == null) {
            return stringType;
        }
        KtExpression expr2 = ktExpression;
        BindingContext context = facade.analyze(this.template, BodyResolveMode.PARTIAL);
        LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)this.template, context, facade);
        BindingContext tempContext = AnalyzerUtilKt.analyzeInContext$default(expr2, scope2, this.template, null, null, null, false, null, null, 252, null);
        DelegatingBindingTrace trace = new DelegatingBindingTrace(tempContext, "Evaluate '" + literal + '\'', false, null, false, 28, null);
        LanguageVersionSettings languageVersionSettings = facade.getFrontendService(LanguageVersionSettings.class);
        CompileTimeConstant value = ConstantExpressionEvaluator.evaluateExpression$default(new ConstantExpressionEvaluator(module, languageVersionSettings, facade.getProject()), expr2, trace, null, 4, null);
        if (value == null || value.isError()) {
            return stringType;
        }
        SimpleType simpleType3 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"TypeUtils.NO_EXPECTED_TYPE");
        return value.toConstantValue(simpleType3).getType(module);
    }

    @NotNull
    public final KtStringTemplateExpression getTemplate() {
        return this.template;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @NotNull
    public final TextRange getContentRange() {
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)this.startEntry) + this.prefix.length(), PsiUtilsKt.getEndOffset((PsiElement)this.endEntry) - this.suffix.length());
    }

    @NotNull
    public final TextRange getRelativeContentRange() {
        TextRange textRange = this.getContentRange().shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)this.template));
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"contentRange.shiftRight(-template.startOffset)");
        return textRange;
    }

    @NotNull
    public final Sequence<KtStringTemplateEntry> getEntries() {
        return SequencesKt.generateSequence((Object)this.startEntry, (Function1)((Function1)new Function1<KtStringTemplateEntry, KtStringTemplateEntry>(this){
            final /* synthetic */ ExtractableSubstringInfo this$0;

            @Nullable
            public final KtStringTemplateEntry invoke(@NotNull KtStringTemplateEntry it) {
                KtStringTemplateEntry ktStringTemplateEntry;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it, (Object)this.this$0.getEndEntry()) ^ true) {
                    PsiElement $receiver$iv = (PsiElement)it;
                    ktStringTemplateEntry = (KtStringTemplateEntry)PsiTreeUtil.getNextSiblingOfType((PsiElement)$receiver$iv, KtStringTemplateEntry.class);
                } else {
                    ktStringTemplateEntry = null;
                }
                return ktStringTemplateEntry;
            }
            {
                this.this$0 = extractableSubstringInfo;
                super(1);
            }
        }));
    }

    @NotNull
    public final KtExpression createExpression() {
        KtExpression ktExpression;
        PsiElement psiElement2 = this.template.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"template.firstChild");
        String quote = psiElement2.getText();
        String literalValue = KotlinBuiltIns.isString(this.type) ? quote + this.content + quote : this.content;
        KtExpression $receiver = ktExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)this.startEntry, false, 2, null).createExpression(literalValue);
        ExtractableSubstringInfoKt.setExtractableSubstringInfo($receiver, this);
        return ktExpression;
    }

    @NotNull
    public final ExtractableSubstringInfo copy(@NotNull KtStringTemplateExpression newTemplate) {
        Intrinsics.checkParameterIsNotNull((Object)newTemplate, (String)"newTemplate");
        Object[] objectArray = this.template.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"template.entries");
        Object[] oldEntries = objectArray;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = newTemplate.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntryArray, (String)"newTemplate.entries");
        KtStringTemplateEntry[] newEntries2 = ktStringTemplateEntryArray;
        int startIndex = ArraysKt.indexOf((Object[])oldEntries, (Object)this.startEntry);
        int endIndex = ArraysKt.indexOf((Object[])oldEntries, (Object)this.endEntry);
        if (startIndex < 0 || startIndex >= newEntries2.length || endIndex < 0 || endIndex >= newEntries2.length) {
            throw (Throwable)((Object)new AssertionError((Object)("Old template(" + startIndex + ".." + endIndex + "): " + this.template.getText() + ", new template: " + newTemplate.getText())));
        }
        KtStringTemplateEntry ktStringTemplateEntry = newEntries2[startIndex];
        Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry, (String)"newEntries[startIndex]");
        KtStringTemplateEntry ktStringTemplateEntry2 = newEntries2[endIndex];
        Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry2, (String)"newEntries[endIndex]");
        return new ExtractableSubstringInfo(ktStringTemplateEntry, ktStringTemplateEntry2, this.prefix, this.suffix, this.type);
    }

    @NotNull
    public final KtStringTemplateEntry getStartEntry() {
        return this.startEntry;
    }

    @NotNull
    public final KtStringTemplateEntry getEndEntry() {
        return this.endEntry;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    public ExtractableSubstringInfo(@NotNull KtStringTemplateEntry startEntry, @NotNull KtStringTemplateEntry endEntry, @NotNull String prefix, @NotNull String suffix, @Nullable KotlinType type2) {
        String string;
        String $receiver;
        Intrinsics.checkParameterIsNotNull((Object)startEntry, (String)"startEntry");
        Intrinsics.checkParameterIsNotNull((Object)endEntry, (String)"endEntry");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        this.startEntry = startEntry;
        this.endEntry = endEntry;
        this.prefix = prefix;
        this.suffix = suffix;
        PsiElement psiElement2 = this.startEntry.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        this.template = (KtStringTemplateExpression)psiElement2;
        String string2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map(this.getEntries(), (Function1)content.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        ExtractableSubstringInfo extractableSubstringInfo = this;
        String string3 = $receiver = string2;
        int n = this.prefix.length();
        int n2 = $receiver.length() - this.suffix.length();
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        extractableSubstringInfo.content = string = string5;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 == null) {
            kotlinType2 = this.guessLiteralType(this.content);
        }
        this.type = kotlinType2;
    }

    public /* synthetic */ ExtractableSubstringInfo(KtStringTemplateEntry ktStringTemplateEntry, KtStringTemplateEntry ktStringTemplateEntry2, String string, String string2, KotlinType kotlinType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            kotlinType2 = null;
        }
        this(ktStringTemplateEntry, ktStringTemplateEntry2, string, string2, kotlinType2);
    }
}

