/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsDialog;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveDeclarationToSeparateFileIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "idea"})
public final class MoveDeclarationToSeparateFileIntention
extends SelfTargetingRangeIntention<KtClassOrObject>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element3) {
        PsiElement keyword;
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3.getName() == null) {
            return null;
        }
        if (!(element3.getParent() instanceof KtFile)) {
            return null;
        }
        if (element3.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return null;
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
        if (ktFile.getDeclarations().size() == 1) {
            return null;
        }
        ClassDescriptor classDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        Collection<ClassDescriptor> collection = descriptor2.getSealedSubclasses();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.sealedSubclasses");
        Collection<ClassDescriptor> collection2 = collection;
        if (!collection2.isEmpty()) {
            return null;
        }
        ClassDescriptor classDescriptor3 = DescriptorUtilsKt.getSuperClassNotAny(descriptor2);
        if ((classDescriptor3 != null ? classDescriptor3.getModality() : null) == Modality.SEALED) {
            return null;
        }
        KtClassOrObject ktClassOrObject = element3;
        if (ktClassOrObject instanceof KtClass) {
            psiElement2 = ((KtClass)element3).getClassOrInterfaceKeyword();
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            psiElement2 = ((KtObjectDeclaration)element3).getObjectKeyword();
        } else {
            return null;
        }
        PsiElement psiElement3 = keyword = psiElement2;
        if (psiElement3 == null) {
            return null;
        }
        int startOffset = PsiUtilsKt.getStartOffset(psiElement3);
        PsiElement psiElement4 = element3.getNameIdentifier();
        if (psiElement4 == null) {
            return null;
        }
        int endOffset = PsiUtilsKt.getEndOffset(psiElement4);
        this.setText("Move '" + element3.getName() + "' to separate file");
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (editor2 == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
        KtFile file = ktFile;
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        Project project2 = project;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int originalOffset = caretModel.getOffset() - PsiUtilsKt.getStartOffset(element3);
        PsiDirectory psiDirectory = file.getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"file.containingDirectory ?: return");
        PsiDirectory directory = psiDirectory;
        FqName packageName = file.getPackageFqName();
        String targetFileName = element3.getName() + ".kt";
        PsiFile targetFile = directory.findFile(targetFileName);
        if (targetFile != null) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                throw (Throwable)new CommonRefactoringUtil.RefactoringErrorHintException("File " + targetFileName + " already exists");
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(project2, element3, packageName, directory, targetFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ KtClassOrObject $element;
                final /* synthetic */ FqName $packageName;
                final /* synthetic */ PsiDirectory $directory;
                final /* synthetic */ PsiFile $targetFile;

                public final void run() {
                    Set set2 = SetsKt.setOf((Object)this.$element);
                    String string = this.$packageName.asString();
                    PsiFile psiFile = this.$targetFile;
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    new MoveKotlinTopLevelDeclarationsDialog(this.$project, set2, string, this.$directory, (KtFile)psiFile, true, true, true, null).show();
                }
                {
                    this.$project = project;
                    this.$element = ktClassOrObject;
                    this.$packageName = fqName2;
                    this.$directory = psiDirectory;
                    this.$targetFile = psiFile;
                }
            });
            return;
        }
        KotlinMoveTargetForDeferredFile moveTarget2 = new KotlinMoveTargetForDeferredFile(packageName, directory, null, (Function1<? super KtFile, ? extends KtFile>)((Function1)new Function1<KtFile, KtFile>(targetFileName, directory, packageName){
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ FqName $packageName;

            @NotNull
            public final KtFile invoke(@NotNull KtFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return KotlinRefactoringUtilKt.createKotlinFile(this.$targetFileName, this.$directory, this.$packageName.asString());
            }
            {
                this.$targetFileName = string;
                this.$directory = psiDirectory;
                this.$packageName = fqName2;
                super(1);
            }
        }));
        MoveDeclarationsDescriptor descriptor2 = new MoveDeclarationsDescriptor(project2, MoveKotlinDeclarationsProcessorKt.MoveSource(element3), moveTarget2, MoveDeclarationsDelegate.TopLevel.INSTANCE, false, false, false, new MoveCallback(directory, targetFileName, project2, originalOffset){
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $originalOffset;

            public final void refactoringCompleted() {
                block1: {
                    PsiFile psiFile = this.$directory.findFile(this.$targetFileName);
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    KtFile newFile = (KtFile)psiFile;
                    KtDeclaration newDeclaration = (KtDeclaration)CollectionsKt.first(newFile.getDeclarations());
                    NavigationUtil.activateFileWithPsiElement((PsiElement)((PsiElement)newFile));
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.$project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
                    Editor editor2 = fileEditorManager.getSelectedTextEditor();
                    if (editor2 == null) break block1;
                    GenerateUtilKt.moveCaret$default(editor2, PsiUtilsKt.getStartOffset(newDeclaration) + this.$originalOffset, null, 2, null);
                }
            }
            {
                this.$directory = psiDirectory;
                this.$targetFileName = string;
                this.$project = project;
                this.$originalOffset = n;
            }
        }, false, null, false, false, 3904, null);
        new MoveKotlinDeclarationsProcessor(descriptor2, null, 2, null).run();
    }

    public MoveDeclarationToSeparateFileIntention() {
        super(KtClassOrObject.class, "Move declaration to separate file", null, 4, null);
    }
}

