/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.patterns;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate KOTLIN_NAME_PREDICATE = new NamePredicate("kotlin");
    @NotNull
    private static final Name KOTLIN_NAME = Name.identifier("Kotlin".toLowerCase());

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull NamePredicate checker, @NotNull String stringWithPattern) {
        ArrayList checkers = Lists.newArrayList((Object[])new NamePredicate[]{checker});
        checkers.addAll(PatternBuilder.parseFqNamesFromString(stringWithPattern));
        return PatternBuilder.pattern(checkers, PatternBuilder.parseArgumentsFromString(stringWithPattern));
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern, @NotNull NamePredicate checker) {
        ArrayList checkers = Lists.newArrayList(PatternBuilder.parseFqNamesFromString(stringWithPattern));
        checkers.add(checker);
        return PatternBuilder.pattern(checkers);
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern) {
        return PatternBuilder.pattern(PatternBuilder.parseFqNamesFromString(stringWithPattern), PatternBuilder.parseArgumentsFromString(stringWithPattern));
    }

    @NotNull
    private static List<NamePredicate> parseFqNamesFromString(@NotNull String stringWithPattern) {
        stringWithPattern = PatternBuilder.getNamePatternFromString(stringWithPattern);
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        return checkers;
    }

    @Nullable
    private static List<NamePredicate> parseArgumentsFromString(@NotNull String stringWithPattern) {
        String[] subPatterns;
        if ((stringWithPattern = PatternBuilder.getArgumentsPatternFromString(stringWithPattern)) == null) {
            return null;
        }
        ArrayList checkers = Lists.newArrayList();
        if (stringWithPattern.isEmpty()) {
            return checkers;
        }
        for (String subPattern : subPatterns = stringWithPattern.split("\\,")) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        return checkers;
    }

    @NotNull
    private static String getNamePatternFromString(@NotNull String stringWithPattern) {
        int left = stringWithPattern.indexOf("(");
        if (left < 0) {
            return stringWithPattern;
        }
        return stringWithPattern.substring(0, left);
    }

    @Nullable
    private static String getArgumentsPatternFromString(@NotNull String stringWithPattern) {
        int left = stringWithPattern.indexOf("(");
        if (left < 0) {
            return null;
        }
        int right = stringWithPattern.indexOf(")");
        assert (right == stringWithPattern.length() - 1) : "expected ')' at the end: " + stringWithPattern;
        return stringWithPattern.substring(left + 1, right);
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers) {
        return PatternBuilder.pattern(checkers, null);
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers, @Nullable List<NamePredicate> arguments2) {
        assert (!checkers.isEmpty());
        final ArrayList checkersWithPrefixChecker = Lists.newArrayList();
        if (!checkers.get(0).test(KOTLIN_NAME)) {
            checkersWithPrefixChecker.add(KOTLIN_NAME_PREDICATE);
        }
        checkersWithPrefixChecker.addAll(checkers);
        assert (checkersWithPrefixChecker.size() > 1);
        final ArrayList argumentCheckers = arguments2 != null ? Lists.newArrayList(arguments2) : null;
        return new DescriptorPredicate(){

            @Override
            public boolean test(FunctionDescriptor descriptor2) {
                try {
                    return this.doApply(descriptor2);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor2) {
                List<Name> nameParts = DescriptorUtils.getFqName(descriptor2).pathSegments();
                if (nameParts.size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts) && this.checkAllArgumentsValidIfNeeded(descriptor2);
            }

            private boolean checkAllArgumentsValidIfNeeded(@NotNull FunctionDescriptor descriptor2) {
                if (argumentCheckers != null) {
                    List<ValueParameterDescriptor> valueParameterDescriptors = descriptor2.getValueParameters();
                    if (valueParameterDescriptors.size() != argumentCheckers.size()) {
                        return false;
                    }
                    for (int i2 = 0; i2 < valueParameterDescriptors.size(); ++i2) {
                        ValueParameterDescriptor valueParameterDescriptor = valueParameterDescriptors.get(i2);
                        Name name2 = DescriptorUtilsKt.getNameIfStandardType(valueParameterDescriptor.getType());
                        NamePredicate namePredicate = (NamePredicate)argumentCheckers.get(i2);
                        if (namePredicate.test(name2)) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                for (int i2 = 0; i2 < nameParts.size(); ++i2) {
                    Name namePart = nameParts.get(i2);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i2);
                    if (correspondingPredicate.test(namePart)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @NotNull
    public static DescriptorPredicate pattern(NamePredicate ... checkers) {
        return PatternBuilder.pattern(Arrays.asList(checkers));
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(String ... names2) {
        return new DescriptorPredicateImpl(names2);
    }

    public static class DescriptorPredicateImpl
    implements DescriptorPredicate {
        private final String[] names;
        private String receiverFqName;
        private boolean checkOverridden;

        public DescriptorPredicateImpl(String ... names2) {
            this.names = names2;
        }

        public DescriptorPredicateImpl isExtensionOf(String receiverFqName) {
            this.receiverFqName = receiverFqName;
            return this;
        }

        public DescriptorPredicateImpl checkOverridden() {
            this.checkOverridden = true;
            return this;
        }

        private boolean matches(@NotNull CallableDescriptor callable2) {
            DeclarationDescriptor descriptor2 = callable2;
            int nameIndex = this.names.length - 1;
            do {
                if (nameIndex == -1) {
                    return false;
                }
                if (!descriptor2.getName().asString().equals(this.names[nameIndex])) {
                    return false;
                }
                --nameIndex;
            } while (!((descriptor2 = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor));
            return nameIndex == 0 && this.names[0].equals(((PackageFragmentDescriptor)descriptor2).getFqName().asString());
        }

        @Override
        public boolean test(FunctionDescriptor functionDescriptor2) {
            ReceiverParameterDescriptor actualReceiver = functionDescriptor2.getExtensionReceiverParameter();
            if (actualReceiver != null) {
                if (this.receiverFqName == null) {
                    return false;
                }
                String actualReceiverFqName = DescriptorUtilsKt.getJetTypeFqName(actualReceiver.getType(), false);
                if (!actualReceiverFqName.equals(this.receiverFqName)) {
                    return false;
                }
            }
            if (!(functionDescriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
                return this.matches(functionDescriptor2);
            }
            for (CallableMemberDescriptor callableMemberDescriptor : OverridingUtil.getOverriddenDeclarations(functionDescriptor2)) {
                if (!this.matches(callableMemberDescriptor)) continue;
                return true;
            }
            if (this.checkOverridden) {
                for (CallableDescriptor callableDescriptor : DescriptorUtils.getAllOverriddenDescriptors(functionDescriptor2)) {
                    if (!this.matches(callableDescriptor)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

