/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

public class VariableAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    private final ResolvedCall<? extends VariableDescriptor> resolvedCall;
    private final KtReferenceExpression referenceExpression;
    private final JsExpression receiver;

    public static VariableAccessTranslator newInstance(@NotNull TranslationContext context, @NotNull KtReferenceExpression referenceExpression, @Nullable JsExpression receiver) {
        ResolvedCall<? extends VariableDescriptor> resolvedCall2 = CallUtilKt.getVariableResolvedCallWithAssert(referenceExpression, context.bindingContext());
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            resolvedCall2 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
        }
        return new VariableAccessTranslator(context, referenceExpression, resolvedCall2, receiver);
    }

    private VariableAccessTranslator(@NotNull TranslationContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression receiver) {
        super(context);
        this.referenceExpression = referenceExpression;
        this.receiver = receiver;
        this.resolvedCall = resolvedCall2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        LocalVariableDescriptor originalLocal;
        JsExpression e = CallTranslator.INSTANCE.translateGet(this.context(), this.resolvedCall, this.receiver);
        CallableDescriptor original = this.resolvedCall.getResultingDescriptor().getOriginal();
        if (original instanceof PropertyDescriptor) {
            PropertyGetterDescriptor getter2 = ((PropertyDescriptor)original).getGetter();
            if (InlineUtil.isInline(getter2)) {
                if (e instanceof JsNameRef) {
                    InlineUtils.setInlineCallMetadata((JsNameRef)e, (KtElement)this.referenceExpression, (CallableDescriptor)getter2, this.context());
                } else {
                    InlineUtils.setInlineCallMetadata(e, (KtElement)this.referenceExpression, (CallableDescriptor)getter2, this.context());
                }
            }
        } else if (original instanceof LocalVariableDescriptor && (originalLocal = (LocalVariableDescriptor)original).isLateInit()) {
            JsExpression throwFunction = this.context().getReferenceToIntrinsic("throwUPAE");
            JsInvocation throwInvocation = new JsInvocation(throwFunction, new JsStringLiteral(originalLocal.getName().asString()));
            return new JsConditional(new JsBinaryOperation(JsBinaryOperator.EQ, e, new JsNullLiteral()), throwInvocation, e);
        }
        return e;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        PropertySetterDescriptor setter2;
        JsExpression e = CallTranslator.INSTANCE.translateSet(this.context(), this.resolvedCall, setTo, this.receiver);
        CallableDescriptor original = this.resolvedCall.getResultingDescriptor().getOriginal();
        if (original instanceof PropertyDescriptor && InlineUtil.isInline(setter2 = ((PropertyDescriptor)original).getSetter())) {
            if (e instanceof JsBinaryOperation && ((JsBinaryOperation)e).getOperator().isAssignment()) {
                InlineUtils.setInlineCallMetadata((JsNameRef)((JsBinaryOperation)e).getArg1(), (KtElement)this.referenceExpression, (CallableDescriptor)setter2, this.context());
            } else {
                InlineUtils.setInlineCallMetadata(e, (KtElement)this.referenceExpression, (CallableDescriptor)setter2, this.context());
            }
        }
        return e;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        JsExpression cachedReceiver = this.receiver != null ? this.context().cacheExpressionIfNeeded(this.receiver) : null;
        return new CachedVariableAccessTranslator(this.context(), this.referenceExpression, this.resolvedCall, cachedReceiver);
    }

    private static class CachedVariableAccessTranslator
    extends VariableAccessTranslator
    implements AccessTranslator {
        public CachedVariableAccessTranslator(@NotNull TranslationContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression cachedReceiver) {
            super(context, referenceExpression, resolvedCall2, cachedReceiver);
        }

        @Override
        @NotNull
        public AccessTranslator getCached() {
            return this;
        }
    }
}

