/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Companion$WhenMappings;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker$Overrides$WhenMappings;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.deprecation.CoroutineCompatibilitySupport;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "ClassifierUsage", "Companion", "Experimentality", "ExperimentalityDiagnostics", "Overrides", "frontend"})
public final class ExperimentalUsageChecker
implements CallChecker {
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final FqName EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final FqName USE_EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final FqName WAS_EXPERIMENTAL_FQ_NAME;
    @NotNull
    private static final Name USE_EXPERIMENTAL_ANNOTATION_CLASS;
    @NotNull
    private static final Name WAS_EXPERIMENTAL_ANNOTATION_CLASS;
    private static final Name LEVEL;
    private static final Name WARNING_LEVEL;
    private static final Name ERROR_LEVEL;
    private static final Name EXPERIMENTAL_SHORT_NAME;
    private static final Name USE_EXPERIMENTAL_SHORT_NAME;
    private static final ExperimentalityDiagnostics EXPERIMENTAL_API_DIAGNOSTICS;
    public static final Companion Companion;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        Set<Experimentality> experimentalities = Companion.loadExperimentalities((DeclarationDescriptor)obj, this.moduleAnnotationsResolver, context.getLanguageVersionSettings());
        Companion.reportNotAcceptedExperimentalities((Collection<Experimentality>)experimentalities, reportOn, context);
    }

    public ExperimentalUsageChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    static {
        Companion = new Companion(null);
        EXPERIMENTAL_FQ_NAME = new FqName("kotlin.Experimental");
        USE_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.UseExperimental");
        WAS_EXPERIMENTAL_FQ_NAME = new FqName("kotlin.WasExperimental");
        Name name2 = Name.identifier("markerClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"markerClass\")");
        USE_EXPERIMENTAL_ANNOTATION_CLASS = name2;
        Name name3 = Name.identifier("markerClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(\"markerClass\")");
        WAS_EXPERIMENTAL_ANNOTATION_CLASS = name3;
        Name name4 = Name.identifier("level");
        Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"Name.identifier(\"level\")");
        LEVEL = name4;
        Name name5 = Name.identifier("WARNING");
        Intrinsics.checkExpressionValueIsNotNull((Object)name5, (String)"Name.identifier(\"WARNING\")");
        WARNING_LEVEL = name5;
        Name name6 = Name.identifier("ERROR");
        Intrinsics.checkExpressionValueIsNotNull((Object)name6, (String)"Name.identifier(\"ERROR\")");
        ERROR_LEVEL = name6;
        Name name7 = EXPERIMENTAL_FQ_NAME.shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name7, (String)"EXPERIMENTAL_FQ_NAME.shortName()");
        EXPERIMENTAL_SHORT_NAME = name7;
        Name name8 = USE_EXPERIMENTAL_FQ_NAME.shortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name8, (String)"USE_EXPERIMENTAL_FQ_NAME.shortName()");
        USE_EXPERIMENTAL_SHORT_NAME = name8;
        DiagnosticFactory1<PsiElement, FqName> diagnosticFactory1 = Errors.EXPERIMENTAL_API_USAGE;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, (String)"Errors.EXPERIMENTAL_API_USAGE");
        DiagnosticFactory1<PsiElement, FqName> diagnosticFactory12 = Errors.EXPERIMENTAL_API_USAGE_ERROR;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory12, (String)"Errors.EXPERIMENTAL_API_USAGE_ERROR");
        EXPERIMENTAL_API_DIAGNOSTICS = new ExperimentalityDiagnostics(diagnosticFactory1, diagnosticFactory12);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "severity", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;)V", "getAnnotationFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getSeverity", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "Severity", "frontend"})
    public static final class Experimentality {
        @NotNull
        private final FqName annotationFqName;
        @NotNull
        private final Severity severity;
        @NotNull
        private static final Severity DEFAULT_SEVERITY;
        public static final Companion Companion;

        @NotNull
        public final FqName getAnnotationFqName() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity getSeverity() {
            return this.severity;
        }

        public Experimentality(@NotNull FqName annotationFqName, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            this.annotationFqName = annotationFqName;
            this.severity = severity;
        }

        static {
            Companion = new Companion(null);
            DEFAULT_SEVERITY = Severity.ERROR;
        }

        @NotNull
        public final FqName component1() {
            return this.annotationFqName;
        }

        @NotNull
        public final Severity component2() {
            return this.severity;
        }

        @NotNull
        public final Experimentality copy(@NotNull FqName annotationFqName, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            return new Experimentality(annotationFqName, severity);
        }

        @NotNull
        public static /* synthetic */ Experimentality copy$default(Experimentality experimentality, FqName fqName2, Severity severity, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = experimentality.annotationFqName;
            }
            if ((n & 2) != 0) {
                severity = experimentality.severity;
            }
            return experimentality.copy(fqName2, severity);
        }

        @NotNull
        public String toString() {
            return "Experimentality(annotationFqName=" + this.annotationFqName + ", severity=" + (Object)((Object)this.severity) + ")";
        }

        public int hashCode() {
            FqName fqName2 = this.annotationFqName;
            Severity severity = this.severity;
            return (fqName2 != null ? ((Object)fqName2).hashCode() : 0) * 31 + (severity != null ? ((Object)((Object)severity)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Experimentality)) break block3;
                    Experimentality experimentality = (Experimentality)object;
                    if (!Intrinsics.areEqual((Object)this.annotationFqName, (Object)experimentality.annotationFqName) || !Intrinsics.areEqual((Object)((Object)this.severity), (Object)((Object)experimentality.severity))) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "", "(Ljava/lang/String;I)V", "WARNING", "ERROR", "frontend"})
        public static final class Severity
        extends Enum<Severity> {
            public static final /* enum */ Severity WARNING;
            public static final /* enum */ Severity ERROR;
            private static final /* synthetic */ Severity[] $VALUES;

            static {
                Severity[] severityArray = new Severity[2];
                Severity[] severityArray2 = severityArray;
                severityArray[0] = WARNING = new Severity();
                severityArray[1] = ERROR = new Severity();
                $VALUES = severityArray;
            }

            public static Severity[] values() {
                return (Severity[])$VALUES.clone();
            }

            public static Severity valueOf(String string) {
                return Enum.valueOf(Severity.class, string);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Companion;", "", "()V", "DEFAULT_SEVERITY", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "getDEFAULT_SEVERITY", "()Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality$Severity;", "frontend"})
        public static final class Companion {
            @NotNull
            public final Severity getDEFAULT_SEVERITY() {
                return DEFAULT_SEVERITY;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J5\u0010\r\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "", "warning", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/name/FqName;", "error", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;)V", "getError", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "getWarning", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class ExperimentalityDiagnostics {
        @NotNull
        private final DiagnosticFactory1<PsiElement, FqName> warning;
        @NotNull
        private final DiagnosticFactory1<PsiElement, FqName> error;

        @NotNull
        public final DiagnosticFactory1<PsiElement, FqName> getWarning() {
            return this.warning;
        }

        @NotNull
        public final DiagnosticFactory1<PsiElement, FqName> getError() {
            return this.error;
        }

        public ExperimentalityDiagnostics(@NotNull DiagnosticFactory1<PsiElement, FqName> warning, @NotNull DiagnosticFactory1<PsiElement, FqName> error) {
            Intrinsics.checkParameterIsNotNull(warning, (String)"warning");
            Intrinsics.checkParameterIsNotNull(error, (String)"error");
            this.warning = warning;
            this.error = error;
        }

        @NotNull
        public final DiagnosticFactory1<PsiElement, FqName> component1() {
            return this.warning;
        }

        @NotNull
        public final DiagnosticFactory1<PsiElement, FqName> component2() {
            return this.error;
        }

        @NotNull
        public final ExperimentalityDiagnostics copy(@NotNull DiagnosticFactory1<PsiElement, FqName> warning, @NotNull DiagnosticFactory1<PsiElement, FqName> error) {
            Intrinsics.checkParameterIsNotNull(warning, (String)"warning");
            Intrinsics.checkParameterIsNotNull(error, (String)"error");
            return new ExperimentalityDiagnostics(warning, error);
        }

        @NotNull
        public static /* synthetic */ ExperimentalityDiagnostics copy$default(ExperimentalityDiagnostics experimentalityDiagnostics, DiagnosticFactory1 diagnosticFactory1, DiagnosticFactory1 diagnosticFactory12, int n, Object object) {
            if ((n & 1) != 0) {
                diagnosticFactory1 = experimentalityDiagnostics.warning;
            }
            if ((n & 2) != 0) {
                diagnosticFactory12 = experimentalityDiagnostics.error;
            }
            return experimentalityDiagnostics.copy(diagnosticFactory1, diagnosticFactory12);
        }

        @NotNull
        public String toString() {
            return "ExperimentalityDiagnostics(warning=" + this.warning + ", error=" + this.error + ")";
        }

        public int hashCode() {
            DiagnosticFactory1<PsiElement, FqName> diagnosticFactory1 = this.warning;
            DiagnosticFactory1<PsiElement, FqName> diagnosticFactory12 = this.error;
            return (diagnosticFactory1 != null ? diagnosticFactory1.hashCode() : 0) * 31 + (diagnosticFactory12 != null ? diagnosticFactory12.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExperimentalityDiagnostics)) break block3;
                    ExperimentalityDiagnostics experimentalityDiagnostics = (ExperimentalityDiagnostics)object;
                    if (!Intrinsics.areEqual(this.warning, experimentalityDiagnostics.warning) || !Intrinsics.areEqual(this.error, experimentalityDiagnostics.error)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\fH\u0002J\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinExperimentalOrUseExperimental", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsQualifier", "", "isUsageAsUseExperimentalArgument", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element3, @NotNull ClassifierUsageCheckerContext context) {
            void $receiver$iv;
            ClassDescriptor targetClass;
            FqNameUnsafe fqName2;
            Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Name name2 = targetDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"targetDescriptor.name");
            Name name3 = name2;
            if ((Intrinsics.areEqual((Object)name3, (Object)EXPERIMENTAL_SHORT_NAME) || Intrinsics.areEqual((Object)name3, (Object)USE_EXPERIMENTAL_SHORT_NAME)) && (Intrinsics.areEqual((Object)(fqName2 = DescriptorUtilsKt.getFqNameUnsafe(targetDescriptor)), (Object)Companion.getEXPERIMENTAL_FQ_NAME().toUnsafe()) || Intrinsics.areEqual((Object)fqName2, (Object)Companion.getUSE_EXPERIMENTAL_FQ_NAME().toUnsafe()))) {
                this.checkUsageOfKotlinExperimentalOrUseExperimental(element3, context);
                return;
            }
            ClassifierDescriptor classifierDescriptor = targetDescriptor;
            ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)targetDescriptor : (targetClass = classifierDescriptor instanceof TypeAliasDescriptor ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
            if (targetClass != null && Companion.loadExperimentalityForMarkerAnnotation$frontend(targetClass) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element3)) {
                BindingContext bindingContext2 = context.getTrace().getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.trace.bindingContext");
                if (!this.isUsageAsUseExperimentalArgument(element3, bindingContext2)) {
                    context.getTrace().report(Errors.EXPERIMENTAL_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_USE_EXPERIMENTAL.on(element3));
                }
            }
            classifierDescriptor = element3;
            boolean strict$iv = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtImportDirective.class, (boolean)strict$iv) == null) {
                Set<Experimentality> experimentalities = Companion.loadExperimentalities(targetDescriptor, this.moduleAnnotationsResolver, context.getLanguageVersionSettings());
                Companion.reportNotAcceptedExperimentalities((Collection<Experimentality>)experimentalities, element3, context);
            }
        }

        private final void checkUsageOfKotlinExperimentalOrUseExperimental(PsiElement element3, CheckerContext context) {
            if (!context.getLanguageVersionSettings().getFlag(AnalysisFlags.getUseExperimental()).contains(Companion.getEXPERIMENTAL_FQ_NAME().asString())) {
                context.getTrace().report(Errors.EXPERIMENTAL_IS_NOT_ENABLED.on(element3));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element3) && !this.isUsageAsQualifier(element3)) {
                context.getTrace().report(Errors.EXPERIMENTAL_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element3));
            }
        }

        private final boolean isUsageAsQualifier(@NotNull PsiElement $receiver) {
            if ($receiver instanceof KtSimpleNameExpression) {
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$receiver);
                KtExpression qualifier = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)$receiver;
                PsiElement psiElement2 = qualifier.getParent();
                if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                    psiElement2 = null;
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
                if (Intrinsics.areEqual((Object)(ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null), (Object)qualifier)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsUseExperimentalArgument(@NotNull PsiElement $receiver, BindingContext bindingContext2) {
            PsiElement psiElement2;
            KtExpression ktExpression;
            PsiElement psiElement3 = $receiver;
            if (!(psiElement3 instanceof KtSimpleNameExpression)) {
                psiElement3 = null;
            }
            PsiElement qualifier = (ktExpression = (KtSimpleNameExpression)psiElement3) != null && (ktExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(ktExpression)) != null ? (PsiElement)ktExpression : $receiver;
            PsiElement parent2 = qualifier.getParent();
            if (!(parent2 instanceof KtClassLiteralExpression)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent() instanceof KtValueArgument)) return false;
            PsiElement psiElement4 = ((KtClassLiteralExpression)parent2).getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"parent.parent");
            if (!(psiElement4.getParent() instanceof KtValueArgumentList)) return false;
            PsiElement psiElement5 = ((KtClassLiteralExpression)parent2).getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"parent.parent");
            PsiElement psiElement6 = psiElement5.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"parent.parent.parent");
            PsiElement entry = psiElement2 = psiElement6.getParent();
            if (!(entry instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null) return false;
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            AnnotationDescriptor annotation2 = annotationDescriptor2;
            if (Intrinsics.areEqual((Object)annotation2.getFqName(), (Object)Companion.getUSE_EXPERIMENTAL_FQ_NAME())) return true;
            if (!Intrinsics.areEqual((Object)annotation2.getFqName(), (Object)Companion.getWAS_EXPERIMENTAL_FQ_NAME$frontend())) return false;
            return true;
        }

        public ClassifierUsage(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    public static final class Overrides
    implements DeclarationChecker {
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"descriptor.overriddenDescriptors");
            Iterable entry = collection;
            Iterable iterable = entry;
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                void $receiver$iv2;
                CallableMemberDescriptor member;
                CallableMemberDescriptor callableMemberDescriptor = member = (CallableMemberDescriptor)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"member");
                Iterable iterable2 = Companion.loadExperimentalities(callableMemberDescriptor, this.moduleAnnotationsResolver, context.getLanguageVersionSettings());
                void var12_13 = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void experimentality;
                    Experimentality experimentality2 = (Experimentality)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    Pair pair2 = TuplesKt.to((Object)experimentality, (Object)member);
                    collection2.add(pair2);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map experimentalOverridden = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            destination$iv$iv = experimentalOverridden;
            for (Map.Entry entry2 : destination$iv$iv.entrySet()) {
                KtNamedDeclaration ktNamedDeclaration;
                DiagnosticFactory2<PsiElement, FqName, DeclarationDescriptor> diagnosticFactory2;
                Object element$iv$iv;
                element$iv$iv = entry2;
                Experimentality experimentality = (Experimentality)element$iv$iv.getKey();
                element$iv$iv = entry2;
                CallableMemberDescriptor member = (CallableMemberDescriptor)element$iv$iv.getValue();
                if (Companion.isExperimentalityAccepted(declaration2, experimentality.getAnnotationFqName(), context)) continue;
                switch (ExperimentalUsageChecker$Overrides$WhenMappings.$EnumSwitchMapping$0[experimentality.getSeverity().ordinal()]) {
                    case 1: {
                        diagnosticFactory2 = Errors.EXPERIMENTAL_OVERRIDE;
                        break;
                    }
                    case 2: {
                        diagnosticFactory2 = Errors.EXPERIMENTAL_OVERRIDE_ERROR;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                DiagnosticFactory2<PsiElement, FqName, DeclarationDescriptor> diagnostic = diagnosticFactory2;
                KtDeclaration ktDeclaration = declaration2;
                if (!(ktDeclaration instanceof KtNamedDeclaration)) {
                    ktDeclaration = null;
                }
                if ((ktNamedDeclaration = (KtNamedDeclaration)ktDeclaration) == null || (ktNamedDeclaration = ktNamedDeclaration.getNameIdentifier()) == null) {
                    ktNamedDeclaration = declaration2;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"(declaration as? KtNamed\u2026Identifier ?: declaration");
                KtNamedDeclaration reportOn = ktNamedDeclaration;
                BindingTrace bindingTrace = context.getTrace();
                FqName fqName2 = experimentality.getAnnotationFqName();
                CallableMemberDescriptor callableMemberDescriptor = member;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"member");
                bindingTrace.report(diagnostic.on(reportOn, fqName2, callableMemberDescriptor.getContainingDeclaration()));
            }
        }

        public Overrides(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00190\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00190\u001fJ4\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0006J$\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020,J0\u0010-\u001a\u00020.*\u00020'2!\u0010/\u001a\u001d\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020.0\u001fH\u0082\bJ\u001c\u00102\u001a\u00020.*\u00020'2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0002J\u001c\u00106\u001a\u00020.*\u00020'2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0002J\"\u00107\u001a\u00020.*\u00020'2\u0006\u00103\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00104\u001a\u000205J\u001c\u00107\u001a\u00020.*\u00020'2\u0006\u00103\u001a\u00020\b2\u0006\u0010+\u001a\u00020,H\u0002J \u00108\u001a\b\u0012\u0004\u0012\u00020%09*\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0013\u0010=\u001a\u0004\u0018\u00010%*\u00020>H\u0000\u00a2\u0006\u0002\b?R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\n\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Companion;", "", "()V", "ERROR_LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "EXPERIMENTAL_API_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "EXPERIMENTAL_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getEXPERIMENTAL_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "EXPERIMENTAL_SHORT_NAME", "LEVEL", "USE_EXPERIMENTAL_ANNOTATION_CLASS", "getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend", "()Lorg/jetbrains/kotlin/name/Name;", "USE_EXPERIMENTAL_FQ_NAME", "getUSE_EXPERIMENTAL_FQ_NAME", "USE_EXPERIMENTAL_SHORT_NAME", "WARNING_LEVEL", "WAS_EXPERIMENTAL_ANNOTATION_CLASS", "getWAS_EXPERIMENTAL_ANNOTATION_CLASS$frontend", "WAS_EXPERIMENTAL_FQ_NAME", "getWAS_EXPERIMENTAL_FQ_NAME$frontend", "checkCompilerArguments", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "reportError", "Lkotlin/Function1;", "", "reportWarning", "reportNotAcceptedExperimentalities", "experimentalities", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$Experimentality;", "element", "Lcom/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnostics", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "anyParentMatches", "", "predicate", "Lkotlin/ParameterName;", "name", "isDeclarationAnnotatedWith", "annotationFqName", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isElementAnnotatedWithUseExperimentalOf", "isExperimentalityAccepted", "loadExperimentalities", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "loadExperimentalityForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "loadExperimentalityForMarkerAnnotation$frontend", "frontend"})
    public static final class Companion {
        @NotNull
        public final FqName getEXPERIMENTAL_FQ_NAME() {
            return EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final FqName getUSE_EXPERIMENTAL_FQ_NAME() {
            return USE_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final FqName getWAS_EXPERIMENTAL_FQ_NAME$frontend() {
            return WAS_EXPERIMENTAL_FQ_NAME;
        }

        @NotNull
        public final Name getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend() {
            return USE_EXPERIMENTAL_ANNOTATION_CLASS;
        }

        @NotNull
        public final Name getWAS_EXPERIMENTAL_ANNOTATION_CLASS$frontend() {
            return WAS_EXPERIMENTAL_ANNOTATION_CLASS;
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element3, @NotNull CheckerContext context) {
            Intrinsics.checkParameterIsNotNull(experimentalities, (String)"experimentalities");
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.reportNotAcceptedExperimentalities(experimentalities, element3, context.getLanguageVersionSettings(), context.getTrace(), EXPERIMENTAL_API_DIAGNOSTICS);
        }

        public final void reportNotAcceptedExperimentalities(@NotNull Collection<Experimentality> experimentalities, @NotNull PsiElement element3, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace, @NotNull ExperimentalityDiagnostics diagnostics2) {
            Intrinsics.checkParameterIsNotNull(experimentalities, (String)"experimentalities");
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Intrinsics.checkParameterIsNotNull((Object)diagnostics2, (String)"diagnostics");
            for (Experimentality experimentality : experimentalities) {
                DiagnosticFactory1<PsiElement, FqName> diagnosticFactory1;
                FqName annotationFqName = experimentality.component1();
                Experimentality.Severity severity = experimentality.component2();
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
                if (this.isExperimentalityAccepted(element3, annotationFqName, languageVersionSettings, bindingContext2)) continue;
                switch (ExperimentalUsageChecker$Companion$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        diagnosticFactory1 = diagnostics2.getWarning();
                        break;
                    }
                    case 2: {
                        diagnosticFactory1 = diagnostics2.getError();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                DiagnosticFactory1<PsiElement, FqName> diagnostic = diagnosticFactory1;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = diagnostic.on(element3, annotationFqName);
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"diagnostic.on(element, annotationFqName)");
                DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Experimentality> loadExperimentalities(@NotNull DeclarationDescriptor $receiver, @NotNull ModuleAnnotationsResolver moduleAnnotationsResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
            DeclarationDescriptor container2;
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)moduleAnnotationsResolver, (String)"moduleAnnotationsResolver");
                Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
                result2 = SmartSet.Companion.create();
                for (AnnotationDescriptor annotation2 : $receiver.getAnnotations()) {
                    ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass(annotation2);
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor2 != null ? this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor2) : null);
                }
                Iterable $receiver$iv = $receiver.getAnnotations();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)Companion.getWAS_EXPERIMENTAL_FQ_NAME$frontend())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($receiver, languageVersionSettings)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                Collection<Experimentality> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Object element$iv;
                Iterable iterable = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                element$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    ClassDescriptor classDescriptor3 = (ClassDescriptor)item$iv$iv;
                    collection = destination$iv$iv;
                    Experimentality experimentality = Companion.loadExperimentalityForMarkerAnnotation$frontend((ClassDescriptor)it);
                    collection.add(experimentality);
                }
                collection = (List)destination$iv$iv;
                smartSet.addAll(collection);
            }
            if ((container2 = $receiver.getContainingDeclaration()) instanceof ClassDescriptor && !($receiver instanceof ConstructorDescriptor)) {
                result2.addAll(this.loadExperimentalities(container2, moduleAnnotationsResolver, languageVersionSettings));
            }
            for (ClassId moduleAnnotationClassId : moduleAnnotationsResolver.getAnnotationsOnContainingModule($receiver)) {
                ClassDescriptor annotationClass = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule($receiver), moduleAnnotationClassId);
                ClassDescriptor classDescriptor4 = annotationClass;
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, classDescriptor4 != null ? this.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor4) : null);
            }
            return result2;
        }

        @Nullable
        public final Experimentality loadExperimentalityForMarkerAnnotation$frontend(@NotNull ClassDescriptor $receiver) {
            Name name2;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            AnnotationDescriptor annotationDescriptor = $receiver.getAnnotations().findAnnotation(this.getEXPERIMENTAL_FQ_NAME());
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor experimental = annotationDescriptor;
            ConstantValue<?> constantValue = experimental.getAllValueArguments().get(LEVEL);
            if (!(constantValue instanceof EnumValue)) {
                constantValue = null;
            }
            EnumValue enumValue = (EnumValue)constantValue;
            Name name3 = name2 = enumValue != null ? enumValue.getEnumEntryName() : null;
            Experimentality.Severity severity = Intrinsics.areEqual((Object)name2, (Object)WARNING_LEVEL) ? Experimentality.Severity.WARNING : (Intrinsics.areEqual((Object)name2, (Object)ERROR_LEVEL) ? Experimentality.Severity.ERROR : Experimentality.Companion.getDEFAULT_SEVERITY());
            return new Experimentality(DescriptorUtilsKt.getFqNameSafe($receiver), severity);
        }

        private final boolean isExperimentalityAccepted(@NotNull PsiElement $receiver, FqName annotationFqName, CheckerContext context) {
            LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
            BindingContext bindingContext2 = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.trace.bindingContext");
            return this.isExperimentalityAccepted($receiver, annotationFqName, languageVersionSettings, bindingContext2);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isExperimentalityAccepted(@NotNull PsiElement $receiver, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingContext bindingContext2) {
            void element3;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            if (languageVersionSettings.getFlag(AnalysisFlags.getExperimental()).contains(annotationFqName.asString())) return true;
            if (languageVersionSettings.getFlag(AnalysisFlags.getUseExperimental()).contains(annotationFqName.asString())) return true;
            PsiElement psiElement2 = $receiver;
            Companion companion = this;
            PsiElement element$iv = $receiver$iv;
            while (!Companion.isDeclarationAnnotatedWith((PsiElement)(element3 = element$iv), annotationFqName, bindingContext2)) {
                if (Companion.isElementAnnotatedWithUseExperimentalOf((PsiElement)element3, annotationFqName, bindingContext2)) {
                    return true;
                }
                boolean bl = false;
                if (bl) {
                    return true;
                }
                if (element$iv.getParent() == null) return false;
            }
            return true;
        }

        private final boolean isDeclarationAnnotatedWith(@NotNull PsiElement $receiver, FqName annotationFqName, BindingContext bindingContext2) {
            if (!($receiver instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver);
            return descriptor2 != null && !DescriptorUtils.isLocal(descriptor2) && descriptor2.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithUseExperimentalOf(@NotNull PsiElement $receiver, FqName annotationFqName, BindingContext bindingContext2) {
            boolean bl;
            if (!($receiver instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list2 = ((KtAnnotated)$receiver).getAnnotationEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationEntries");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                AnnotationDescriptor descriptor2;
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                AnnotationDescriptor annotationDescriptor = descriptor2 = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, entry);
                if (Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)Companion.getUSE_EXPERIMENTAL_FQ_NAME())) {
                    ConstantValue<?> annotationClasses = descriptor2.getAllValueArguments().get(Companion.getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend());
                    if (annotationClasses instanceof ArrayValue) {
                        boolean bl2;
                        Iterable $receiver$iv2 = (Iterable)((ArrayValue)annotationClasses).getValue();
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                ConstantValue annotationClass = (ConstantValue)element$iv2;
                                if (annotationClass instanceof KClassValue) {
                                    Object t = ((KClassValue)annotationClass).getValue();
                                    ClassLiteralValue $classId_arrayDimensions = (ClassLiteralValue)t;
                                    ClassId classId = $classId_arrayDimensions.component1();
                                    int arrayDimensions = $classId_arrayDimensions.component2();
                                    if (Intrinsics.areEqual((Object)classId.asSingleFqName(), (Object)annotationFqName) && arrayDimensions == 0) {
                                        return true;
                                    }
                                    boolean bl3 = false;
                                    if (bl3) {
                                        return true;
                                    }
                                }
                                boolean bl4 = false;
                                if (!bl4) continue;
                                return true;
                            }
                            bl2 = false;
                        }
                        if (bl2) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final boolean anyParentMatches(@NotNull PsiElement $receiver, Function1<? super PsiElement, Boolean> predicate2) {
            PsiElement element3 = $receiver;
            while (!((Boolean)predicate2.invoke((Object)element3)).booleanValue()) {
                if (element3.getParent() != null) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkCompilerArguments(@NotNull ModuleDescriptor module, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError2, @NotNull Function1<? super String, Unit> reportWarning) {
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkParameterIsNotNull(reportError2, (String)"reportError");
            Intrinsics.checkParameterIsNotNull(reportWarning, (String)"reportWarning");
            DeprecationResolver deprecationResolver2 = new DeprecationResolver(new LockBasedStorageManager(), languageVersionSettings, CoroutineCompatibilitySupport.Companion.getENABLED());
            Function1<String, Boolean> checkAnnotation$ = new Function1<String, Boolean>(module, reportWarning, deprecationResolver2, reportError2){
                final /* synthetic */ ModuleDescriptor $module;
                final /* synthetic */ Function1 $reportWarning;
                final /* synthetic */ DeprecationResolver $deprecationResolver;
                final /* synthetic */ Function1 $reportError;

                public final boolean invoke(@NotNull String fqName2) {
                    Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                    ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName(this.$module, new FqName(fqName2), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
                    if (descriptor2 == null) {
                        this.$reportWarning.invoke((Object)("Experimental API marker " + fqName2 + " is unresolved. Please make sure it's present in the module dependencies"));
                        return false;
                    }
                    if (ExperimentalUsageChecker.Companion.loadExperimentalityForMarkerAnnotation$frontend(descriptor2) == null) {
                        this.$reportWarning.invoke((Object)("Class " + fqName2 + " is not an experimental API marker annotation"));
                        return false;
                    }
                    for (Deprecation deprecation : this.$deprecationResolver.getDeprecations(descriptor2)) {
                        String string;
                        String string2;
                        Function1 function1;
                        StringBuilder stringBuilder;
                        String string3;
                        Function1 report2;
                        Function1 function12;
                        switch (ExperimentalUsageChecker$Companion$WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                            case 1: {
                                function12 = this.$reportWarning;
                                break;
                            }
                            case 2: 
                            case 3: {
                                function12 = this.$reportError;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        Function1 function13 = report2 = function12;
                        StringBuilder stringBuilder2 = new StringBuilder().append("Experimental API marker ").append(fqName2).append(" is deprecated");
                        String string4 = deprecation.getMessage();
                        if (string4 != null) {
                            string3 = string4;
                            stringBuilder = stringBuilder2;
                            function1 = function13;
                            String it = string3;
                            string2 = ". " + it;
                            function13 = function1;
                            stringBuilder2 = stringBuilder;
                            string = string2;
                        } else {
                            string = null;
                        }
                        string3 = string;
                        stringBuilder = stringBuilder2;
                        function1 = function13;
                        String string5 = string3;
                        if (string5 == null) {
                            string5 = "";
                        }
                        string2 = string5;
                        function1.invoke((Object)stringBuilder.append(string2).toString());
                    }
                    return true;
                }
                {
                    this.$module = moduleDescriptor2;
                    this.$reportWarning = function1;
                    this.$deprecationResolver = deprecationResolver2;
                    this.$reportError = function12;
                    super(1);
                }
            };
            Iterable iterable = $receiver$iv = (Iterable)languageVersionSettings.getFlag(AnalysisFlags.getExperimental());
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                String p1 = (String)element$iv$iv;
                if (!checkAnnotation$.invoke(p1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List validExperimental = (List)destination$iv$iv;
            Iterable $receiver$iv2 = languageVersionSettings.getFlag(AnalysisFlags.getUseExperimental());
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String fqName2 = (String)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)fqName2, (Object)Companion.getEXPERIMENTAL_FQ_NAME().asString()) || checkAnnotation$.invoke(fqName2))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List validUseExperimental = (List)destination$iv$iv2;
            for (String fqName3 : CollectionsKt.intersect((Iterable)validExperimental, (Iterable)validUseExperimental)) {
                reportError2.invoke((Object)("'-Xuse-experimental=" + fqName3 + "' has no effect because '-Xexperimental=" + fqName3 + "' is used"));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

