/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J.\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u001e\u001a\u00020\u00102\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0014J$\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0014J$\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J \u0010'\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010(2\u0006\u0010\u001a\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010(2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0002J \u0010-\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010(2\u0006\u0010\u001a\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020&H\u0002J&\u00101\u001a\u00020\u00182\u0014\u00102\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010!0(2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u00103\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J1\u00104\u001a\u0012\u0012\u0004\u0012\u000206\u0012\b\u0012\u0006\u0012\u0002\b\u00030!052\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b7J2\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0(2\u0006\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/openapi/project/Project;)V", "getLanguageVersionSettings$frontend", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getModule$frontend", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "checkCompileTimeConstant", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "useDeprecationWarning", "", "checkExperimentalityOfConstantLiteral", "expression", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expectedType", "checkInnerPartsOfCompileTimeConstant", "evaluateExpression", "evaluateToConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getArgumentExpressionsForArrayCall", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getArgumentExpressionsForArrayLikeCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getArgumentExpressionsForCollectionLiteralCall", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "hasSpread", "argument", "isArrayPassedInNamedForm", "constants", "reportDeprecationWarningOnNonConst", "resolveAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "resolveAnnotationArguments$frontend", "resolveAnnotationValueArguments", "resolvedValueArgument", "deprecatedExpectedType", "updateNumberType", "numberType", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "Companion", "frontend"})
public final class ConstantExpressionEvaluator {
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private static final ExperimentalUsageChecker.ExperimentalityDiagnostics EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS;
    public static final Companion Companion;

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression2, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)numberType, (String)"numberType");
        Intrinsics.checkParameterIsNotNull((Object)statementFilter, (String)"statementFilter");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        if (expression2 == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression2, trace, false);
        if (!(expression2 instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression2, statementFilter);
            if (deparenthesized != expression2) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression2, trace, numberType);
    }

    @NotNull
    public final Map<Name, ConstantValue<?>> resolveAnnotationArguments$frontend(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        HashMap arguments2 = new HashMap();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = resolvedCall2.getValueArguments().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = entry2.getKey();
            entry2 = entry;
            ResolvedValueArgument resolvedArgument = entry2.getValue();
            ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameterDescriptor");
            ResolvedValueArgument resolvedValueArgument = resolvedArgument;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"resolvedArgument");
            ConstantValue<?> value = this.getAnnotationArgumentValue(trace, valueParameterDescriptor, resolvedValueArgument);
            if (value == null) continue;
            arguments2.put(parameterDescriptor.getName(), value);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)resolvedArgument, (String)"resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        KotlinType constantType = argumentsAsVararg ? varargElementType : parameterDescriptor.getType();
        KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(parameterDescriptor, resolvedArgument, this.languageVersionSettings, trace);
        KotlinType kotlinType2 = constantType;
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType2, expectedType, trace);
        Iterable iterable = $receiver$iv = (Iterable)compileTimeConstants;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            ConstantValue constantValue = it.toConstantValue(expectedType);
            collection.add(constantValue);
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (this.isArrayPassedInNamedForm(constants, resolvedArgument)) {
                return (ConstantValue)CollectionsKt.single((List)constants);
            }
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType3 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"parameterDescriptor.type");
            return ConstantValueFactory.INSTANCE.createArrayValue(constants, kotlinType3);
        }
        return (ConstantValue)CollectionsKt.lastOrNull((List)constants);
    }

    private final boolean isArrayPassedInNamedForm(List<? extends ConstantValue<? extends Object>> constants, ResolvedValueArgument resolvedArgument) {
        ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull(constants);
        if (constantValue == null) {
            return false;
        }
        ConstantValue constant = constantValue;
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedArgument.arguments");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull(list2);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument argument2 = valueArgument;
        return constant instanceof ArrayValue && argument2.isNamed();
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression2, KotlinType expressionType, BindingTrace trace, boolean useDeprecationWarning) {
        DiagnosticFactory0<KtExpression> diagnosticFactory;
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression2, bindingContext2);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            this.checkInnerPartsOfCompileTimeConstant(constant, trace, argumentExpression2, useDeprecationWarning);
            return;
        }
        ClassifierDescriptor descriptor2 = expressionType.getConstructor().getDeclarationDescriptor();
        DiagnosticFactory0<KtExpression> diagnosticFactory0 = DescriptorUtils.isEnumClass(descriptor2) ? Errors.ANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST : (diagnosticFactory = descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2) ? Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL : Errors.ANNOTATION_ARGUMENT_MUST_BE_CONST);
        if (useDeprecationWarning) {
            this.reportDeprecationWarningOnNonConst(argumentExpression2, trace);
        } else {
            trace.report(diagnosticFactory.on((KtExpression)((PsiElement)argumentExpression2)));
        }
    }

    private final void checkInnerPartsOfCompileTimeConstant(CompileTimeConstant<?> constant, BindingTrace trace, KtExpression argumentExpression2, boolean useDeprecationWarning) {
        DoubleColonLHS doubleColonLhs;
        KtExpression lhsExpression;
        List<KtExpression> callArguments;
        KtExpression ktExpression = argumentExpression2;
        List<KtExpression> list2 = ktExpression instanceof KtCallExpression ? this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression2, trace) : (callArguments = ktExpression instanceof KtCollectionLiteralExpression ? this.getArgumentExpressionsForCollectionLiteralCall((KtCollectionLiteralExpression)argumentExpression2, trace) : null);
        if (callArguments != null) {
            for (KtExpression argument2 : callArguments) {
                KotlinType type2;
                if (trace.getType(argument2) == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"trace.getType(argument) ?: continue");
                this.checkCompileTimeConstant(argument2, type2, trace, useDeprecationWarning);
            }
        }
        if (constant.getUsesNonConstValAsConstant()) {
            if (useDeprecationWarning) {
                this.reportDeprecationWarningOnNonConst(argumentExpression2, trace);
            } else {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression2)));
            }
        }
        if (argumentExpression2 instanceof KtClassLiteralExpression && (lhsExpression = ((KtClassLiteralExpression)argumentExpression2).getReceiverExpression()) != null && (doubleColonLhs = (DoubleColonLHS)trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, lhsExpression)) instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)doubleColonLhs).isObjectQualifier()) {
            if (useDeprecationWarning) {
                this.reportDeprecationWarningOnNonConst(argumentExpression2, trace);
            } else {
                trace.report(Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression2)));
            }
        }
    }

    private final void reportDeprecationWarningOnNonConst(KtExpression expression2, BindingTrace trace) {
        trace.report(Errors.ANNOTATION_ARGUMENT_IS_NON_CONST.on((KtExpression)((PsiElement)expression2)));
    }

    private final List<KtExpression> getArgumentExpressionsForArrayCall(KtCallExpression expression2, BindingTrace trace) {
        KtElement ktElement = expression2;
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForCollectionLiteralCall(KtCollectionLiteralExpression expression2, BindingTrace trace) {
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForArrayLikeCall(ResolvedCall<?> resolvedCall2) {
        if (!CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2)) {
            return null;
        }
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedValueArgument;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ResolvedValueArgument resolvedValueArgument2 = resolvedValueArgument = entry2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument2, (String)"resolvedValueArgument");
            for (ValueArgument valueArgument : resolvedValueArgument2.getArguments()) {
                KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
                if (valueArgumentExpression == null) continue;
                result2.add(valueArgumentExpression);
            }
        }
        return result2;
    }

    private final boolean hasSpread(ResolvedValueArgument argument2) {
        List<ValueArgument> list2 = argument2.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argument.arguments");
        List<ValueArgument> arguments2 = list2;
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType deprecatedExpectedType, KotlinType expectedType, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument2 : resolvedValueArgument.getArguments()) {
            KotlinType expressionType;
            KtExpression argumentExpression2;
            if (argument2.getArgumentExpression() == null) {
                continue;
            }
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression2, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType2 = ((IntegerValueTypeConstant)constant).getType(expectedType);
                this.updateNumberType(defaultType2, argumentExpression2, StatementFilter.NONE, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            if (trace.getType(argumentExpression2) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionType, (String)"trace.getType(argumentExpression) ?: continue");
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonConstValuesAsVarargsInAnnotations) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, deprecatedExpectedType)) {
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) continue;
                this.checkCompileTimeConstant(argumentExpression2, expressionType, trace, true);
                continue;
            }
            this.checkCompileTimeConstant(argumentExpression2, expressionType, trace, false);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @Nullable KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant<?> compileTimeConstant = visitor2.evaluate(expression2, expectedType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        this.checkExperimentalityOfConstantLiteral(expression2, constant, expectedType, trace);
        return !constant.isError() ? constant : null;
    }

    @Nullable
    public static /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType2, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType2);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression2, trace, expectedType);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
    }

    private final void checkExperimentalityOfConstantLiteral(KtExpression expression2, CompileTimeConstant<?> constant, KotlinType expectedType, BindingTrace trace) {
        ExperimentalUsageChecker.Companion companion;
        KotlinType kotlinType2;
        if (constant.isError()) {
            return;
        }
        if (!constant.getParameters().isUnsignedNumberLiteral() && !constant.getParameters().isUnsignedLongNumberLiteral()) {
            return;
        }
        if (constant instanceof TypedCompileTimeConstant) {
            kotlinType2 = ((TypedCompileTimeConstant)constant).getType();
        } else if (expectedType != null) {
            kotlinType2 = constant.toConstantValue(expectedType).getType(this.module);
        } else {
            return;
        }
        KotlinType constantType = kotlinType2;
        if (!UnsignedTypes.INSTANCE.isUnsignedType(constantType)) {
            return;
        }
        ExperimentalUsageChecker.Companion $receiver = companion = ExperimentalUsageChecker.Companion;
        ClassifierDescriptor classifierDescriptor = constantType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"constantType.constructor\u2026ationDescriptor ?: return");
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        Set<ExperimentalUsageChecker.Experimentality> experimentalities = $receiver.loadExperimentalities(descriptor2, this.moduleAnnotationsResolver, this.languageVersionSettings);
        $receiver.reportNotAcceptedExperimentalities((Collection<ExperimentalUsageChecker.Experimentality>)experimentalities, (PsiElement)expression2, this.languageVersionSettings, trace, EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS);
    }

    @NotNull
    public final ModuleDescriptor getModule$frontend() {
        return this.module;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings$frontend() {
        return this.languageVersionSettings;
    }

    public ConstantExpressionEvaluator(@NotNull ModuleDescriptor module, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.module = module;
        this.languageVersionSettings = languageVersionSettings;
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    static {
        Companion = new Companion(null);
        DiagnosticFactory1<PsiElement, FqName> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, (String)"Errors.EXPERIMENTAL_UNSIGNED_LITERALS");
        DiagnosticFactory1<PsiElement, FqName> diagnosticFactory12 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory12, (String)"Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS = new ExperimentalUsageChecker.ExperimentalityDiagnostics(diagnosticFactory1, diagnosticFactory12);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
        return Companion.getConstant(expression2, bindingContext2);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
        return Companion.getPossiblyErrorConstant(expression2, bindingContext2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "()V", "EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalUsageChecker$ExperimentalityDiagnostics;", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant", "frontend"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            CompileTimeConstant<?> compileTimeConstant = this.getPossiblyErrorConstant(expression2, bindingContext2);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> constant = compileTimeConstant;
            return !constant.isError() ? constant : null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            return (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

