/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmTypes {
    private static final Map<Class<?>, Type> TYPES_MAP = new HashMap();
    public static final Type OBJECT_TYPE = AsmTypes.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypes.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypes.getType(Throwable.class);
    public static final Type JAVA_CLASS_TYPE = AsmTypes.getType(Class.class);
    public static final Type ENUM_TYPE = AsmTypes.getType(Enum.class);
    public static final Type NUMBER_TYPE = AsmTypes.getType(Number.class);
    public static final Type BOOLEAN_WRAPPER_TYPE = AsmTypes.getType(Boolean.class);
    public static final Type CHARACTER_WRAPPER_TYPE = AsmTypes.getType(Character.class);
    public static final Type VOID_WRAPPER_TYPE = AsmTypes.getType(Void.class);
    public static final Type UNIT_TYPE = Type.getObjectType((String)"kotlin/Unit");
    public static final Type LAMBDA = Type.getObjectType((String)"kotlin/jvm/internal/Lambda");
    public static final Type FUNCTION_REFERENCE = Type.getObjectType((String)"kotlin/jvm/internal/FunctionReference");
    public static final Type PROPERTY_REFERENCE0 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference0");
    public static final Type PROPERTY_REFERENCE1 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference1");
    public static final Type PROPERTY_REFERENCE2 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference2");
    public static final Type MUTABLE_PROPERTY_REFERENCE0 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference0");
    public static final Type MUTABLE_PROPERTY_REFERENCE1 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference1");
    public static final Type MUTABLE_PROPERTY_REFERENCE2 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference2");
    public static final Type RESULT_FAILURE = Type.getObjectType((String)"kotlin/Result$Failure");
    public static final Type[] PROPERTY_REFERENCE_IMPL = new Type[]{Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference0Impl"), Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference1Impl"), Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference2Impl")};
    public static final Type[] MUTABLE_PROPERTY_REFERENCE_IMPL = new Type[]{Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference0Impl"), Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference1Impl"), Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference2Impl")};
    public static final Type K_CLASS_TYPE = AsmTypes.reflect("KClass");
    public static final Type K_CLASS_ARRAY_TYPE = Type.getObjectType((String)("[" + K_CLASS_TYPE.getDescriptor()));
    public static final Type K_DECLARATION_CONTAINER_TYPE = AsmTypes.reflect("KDeclarationContainer");
    public static final Type K_FUNCTION = AsmTypes.reflect("KFunction");
    public static final Type K_PROPERTY_TYPE = AsmTypes.reflect("KProperty");
    public static final Type K_PROPERTY0_TYPE = AsmTypes.reflect("KProperty0");
    public static final Type K_PROPERTY1_TYPE = AsmTypes.reflect("KProperty1");
    public static final Type K_PROPERTY2_TYPE = AsmTypes.reflect("KProperty2");
    public static final Type K_MUTABLE_PROPERTY0_TYPE = AsmTypes.reflect("KMutableProperty0");
    public static final Type K_MUTABLE_PROPERTY1_TYPE = AsmTypes.reflect("KMutableProperty1");
    public static final Type K_MUTABLE_PROPERTY2_TYPE = AsmTypes.reflect("KMutableProperty2");
    public static final Type SUSPEND_FUNCTION_TYPE = Type.getObjectType((String)"kotlin/coroutines/jvm/internal/SuspendFunction");
    public static final String REFLECTION = "kotlin/jvm/internal/Reflection";
    public static final String REF_TYPE_PREFIX = "kotlin/jvm/internal/Ref$";
    public static final Type OBJECT_REF_TYPE = Type.getObjectType((String)"kotlin/jvm/internal/Ref$ObjectRef");
    public static final Type DEFAULT_CONSTRUCTOR_MARKER = Type.getObjectType((String)"kotlin/jvm/internal/DefaultConstructorMarker");

    @NotNull
    private static Type reflect(@NotNull String className2) {
        return Type.getObjectType((String)("kotlin/reflect/" + className2));
    }

    public static boolean isSharedVarType(@NotNull Type type2) {
        return type2.getSort() == 10 && type2.getInternalName().startsWith(REF_TYPE_PREFIX);
    }

    @NotNull
    public static Type sharedTypeForPrimitive(@NotNull PrimitiveType primitiveType) {
        String typeName = primitiveType.getTypeName().getIdentifier();
        return Type.getObjectType((String)(REF_TYPE_PREFIX + typeName + "Ref"));
    }

    @NotNull
    public static Type valueTypeForPrimitive(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case BOOLEAN: {
                return Type.BOOLEAN_TYPE;
            }
            case CHAR: {
                return Type.CHAR_TYPE;
            }
            case BYTE: {
                return Type.BYTE_TYPE;
            }
            case SHORT: {
                return Type.SHORT_TYPE;
            }
            case INT: {
                return Type.INT_TYPE;
            }
            case FLOAT: {
                return Type.FLOAT_TYPE;
            }
            case LONG: {
                return Type.LONG_TYPE;
            }
            case DOUBLE: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Type getType(@NotNull Class<?> javaClass) {
        return TYPES_MAP.computeIfAbsent(javaClass, k -> Type.getType((Class)javaClass));
    }

    private AsmTypes() {
    }
}

