/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.type;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.type.MapPsiToAsmDesc;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/type/MapPsiToAsmDesc;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "classDesc", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "error", "message", "methodDesc", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "primitive", "kotlin.jvm.PlatformType", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "typeDesc", "type", "Lcom/intellij/psi/PsiType;", "unknownSignature", "util"})
public final class MapPsiToAsmDesc {
    private static final Logger LOG;
    public static final MapPsiToAsmDesc INSTANCE;

    @NotNull
    public final String typeDesc(@NotNull PsiType type2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        PsiType psiType = type2;
        if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.VOID)) {
            Type type3 = Type.VOID_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"VOID_TYPE");
            String string2 = this.primitive(type3);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"primitive(VOID_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.BOOLEAN)) {
            Type type4 = Type.BOOLEAN_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"BOOLEAN_TYPE");
            String string3 = this.primitive(type4);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"primitive(BOOLEAN_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.CHAR)) {
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"CHAR_TYPE");
            String string4 = this.primitive(type5);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"primitive(CHAR_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.INT)) {
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"INT_TYPE");
            String string5 = this.primitive(type6);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"primitive(INT_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.BYTE)) {
            Type type7 = Type.BYTE_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"BYTE_TYPE");
            String string6 = this.primitive(type7);
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"primitive(BYTE_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.SHORT)) {
            Type type8 = Type.SHORT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"SHORT_TYPE");
            String string7 = this.primitive(type8);
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"primitive(SHORT_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.LONG)) {
            Type type9 = Type.LONG_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"LONG_TYPE");
            String string8 = this.primitive(type9);
            string = string8;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"primitive(LONG_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.FLOAT)) {
            Type type10 = Type.FLOAT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type10, (String)"FLOAT_TYPE");
            String string9 = this.primitive(type10);
            string = string9;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"primitive(FLOAT_TYPE)");
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.DOUBLE)) {
            Type type11 = Type.DOUBLE_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type11, (String)"DOUBLE_TYPE");
            String string10 = this.primitive(type11);
            string = string10;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"primitive(DOUBLE_TYPE)");
        } else if (psiType instanceof PsiArrayType) {
            StringBuilder stringBuilder = new StringBuilder().append("[");
            PsiType psiType2 = ((PsiArrayType)type2).getComponentType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"type.componentType");
            string = stringBuilder.append(this.typeDesc(psiType2)).toString();
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            PsiClass psiClass2 = resolved;
            if (psiClass2 instanceof PsiTypeParameter) {
                String string11;
                String it;
                Object[] objectArray = ((PsiTypeParameter)resolved).getSuperTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"resolved.superTypes");
                string = (PsiClassType)ArraysKt.firstOrNull((Object[])objectArray);
                if (string == null || (string = INSTANCE.typeDesc((PsiType)(it = (string11 = string)))) == null) {
                    string = "Ljava/lang/Object;";
                }
            } else {
                string = psiClass2 instanceof PsiClass ? this.classDesc(resolved) : (psiClass2 == null ? this.unknownSignature() : this.error("Resolved to unexpected " + resolved + " of class " + resolved.getClass()));
            }
        } else {
            string = this.error("Unexpected type " + type2 + " of class " + type2.getClass());
        }
        return string;
    }

    private final String classDesc(PsiClass psiClass2) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("L");
        List classes2 = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)psiClass2, (Function1)classDesc.1.classes.1.INSTANCE)));
        String string = ((PsiClass)CollectionsKt.first((List)classes2)).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classes.first().qualifiedName!!");
        $receiver.append(StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null));
        Iterable $receiver$iv = CollectionsKt.drop((Iterable)classes2, (int)1);
        for (Object element$iv : $receiver$iv) {
            PsiClass it = (PsiClass)element$iv;
            $receiver.append("$");
            String string2 = it.getName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            $receiver.append(string2);
        }
        $receiver.append(";");
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    @NotNull
    public final String methodDesc(@NotNull PsiMethod psiMethod) {
        StringBuilder stringBuilder;
        block4: {
            block3: {
                PsiType psiType;
                PsiType it;
                PsiParameter[] $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)psiMethod, (String)"psiMethod");
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                $receiver.append("(");
                PsiParameterList psiParameterList = psiMethod.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"psiMethod.parameterList");
                PsiParameter[] psiParameterArray = psiParameterList.getParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"psiMethod.parameterList.parameters");
                PsiParameter[] psiParameterArray2 = $receiver$iv = psiParameterArray;
                int n = psiParameterArray2.length;
                for (int j = 0; j < n; ++j) {
                    PsiParameter element$iv;
                    PsiParameter it2;
                    PsiParameter psiParameter = it2 = (element$iv = psiParameterArray2[j]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"it");
                    PsiType psiType2 = psiParameter.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"it.type");
                    $receiver.append(INSTANCE.typeDesc(psiType2));
                }
                $receiver.append(")");
                Object object = psiMethod.getReturnType();
                if (object == null) break block3;
                PsiType psiType3 = it = (psiType = object);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiType3, (String)"it");
                object = $receiver.append(INSTANCE.typeDesc(psiType3));
                if (object != null) break block4;
            }
            return INSTANCE.unknownSignature();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String unknownSignature() {
        return "";
    }

    private final String error(String message2) {
        LOG.error(message2);
        return this.unknownSignature();
    }

    private final String primitive(Type asmType) {
        return asmType.getDescriptor();
    }

    private MapPsiToAsmDesc() {
    }

    static {
        MapPsiToAsmDesc mapPsiToAsmDesc;
        INSTANCE = mapPsiToAsmDesc = new MapPsiToAsmDesc();
        Logger logger = Logger.getInstance(mapPsiToAsmDesc.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(this::class.java)");
        LOG = logger;
    }
}

