/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\u000fH\u0002J(\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J@\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020$0\u000fH\u0016J\u0014\u0010%\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010&\u001a\u00020\u001b*\u00020\u0004H\u0002J\f\u0010'\u001a\u00020\u000b*\u00020\u0004H\u0002J\u0014\u0010(\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010!\u001a\u00020\u0004H\u0002J\f\u0010)\u001a\u00020\u000b*\u00020\u0004H\u0002J\u0014\u0010*\u001a\u00020\u0004*\u00020\u00042\u0006\u0010+\u001a\u00020\u001bH\u0002J\u0014\u0010,\u001a\u00020\u0004*\u00020\u00042\u0006\u0010+\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/build/output/KotlincOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "COLON", "", "JAVAC_POSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "KOTLIN_POSITION_PATTERN", "addMessage", "", "message", "Lcom/intellij/build/events/MessageEvent;", "consumer", "Ljava/util/function/Consumer;", "createMessage", "buildId", "", "messageKind", "Lcom/intellij/build/events/MessageEvent$Kind;", "text", "detail", "createMessageWithLocation", "Lcom/intellij/build/events/impl/FileMessageEventImpl;", "file", "lineNumber", "", "columnIndex", "getMessageKind", "kind", "isKaptErrorWhileAnnotationProcessing", "parse", "line", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "Lcom/intellij/build/events/BuildEvent;", "amendNextLinesIfNeeded", "colon", "isNextMessage", "skipDriveOnWin", "startsWithSeverityPrefix", "substringAfterAndTrim", "index", "substringBeforeAndTrim", "Companion", "intellij.java.compiler.impl"})
public final class KotlincOutputParser
implements BuildOutputParser {
    private final String COLON = ":";
    private final Pattern KOTLIN_POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    private final Pattern JAVAC_POSITION_PATTERN = Pattern.compile("([0-9]+)");
    private final String KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT = "org.jetbrains.kotlin.kapt3.diagnostic.KaptError: Error while annotation processing";
    private static final String COMPILER_MESSAGES_GROUP = "Kotlin compiler";
    public static final Companion Companion = new Companion(null);

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        int colonIndex1 = this.colon(line);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = this.substringBeforeAndTrim(line, colonIndex1);
        if (!this.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = this.substringAfterAndTrim(line, colonIndex1);
        int colonIndex2 = this.skipDriveOnWin(this.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String string;
            String path = this.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file = new File(path);
            String string2 = string = FilesKt.getExtension((File)file);
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String fileExtension = string3;
            if (!file.isFile() || Intrinsics.areEqual((Object)fileExtension, (Object)"kt") ^ true && Intrinsics.areEqual((Object)fileExtension, (Object)"java") ^ true) {
                Object object = reader.getBuildId();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"reader.buildId");
                return this.addMessage(this.createMessage(object, this.getMessageKind(severity), this.amendNextLinesIfNeeded(lineWoSeverity, reader), line), consumer);
            }
            String lineWoPath = this.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = this.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                Matcher matcher;
                String position = this.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher it = matcher = this.KOTLIN_POSITION_PATTERN.matcher(position);
                boolean bl = false;
                Matcher matcher2 = it.matches() ? matcher : null;
                if (matcher2 == null) {
                    matcher2 = this.JAVAC_POSITION_PATTERN.matcher(position);
                }
                Matcher matcher3 = matcher2;
                String relatedNextLines = this.amendNextLinesIfNeeded("", reader);
                String message = this.substringAfterAndTrim(lineWoPath, colonIndex3) + relatedNextLines;
                String details = lineWoSeverity + relatedNextLines;
                if (matcher3.matches()) {
                    String symbolNumber;
                    String lineNumber = matcher3.group(1);
                    String string4 = symbolNumber = matcher3.groupCount() >= 2 ? matcher3.group(2) : "1";
                    if (lineNumber != null) {
                        String string5 = symbolNumber;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"symbolNumber");
                        String string6 = string5;
                        int symbolNumberText = Integer.parseInt(string6);
                        Object object = reader.getBuildId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"reader.buildId");
                        string6 = lineNumber;
                        String string7 = path;
                        String string8 = message;
                        MessageEvent.Kind kind = this.getMessageKind(severity);
                        Object object2 = object;
                        KotlincOutputParser kotlincOutputParser = this;
                        KotlincOutputParser kotlincOutputParser2 = this;
                        int n = Integer.parseInt(string6);
                        return kotlincOutputParser2.addMessage((MessageEvent)kotlincOutputParser.createMessageWithLocation(object2, kind, string8, string7, n, symbolNumberText, details), consumer);
                    }
                }
                Object object = reader.getBuildId();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"reader.buildId");
                return this.addMessage(this.createMessage(object, this.getMessageKind(severity), message, details), consumer);
            }
            String text = this.amendNextLinesIfNeeded(lineWoSeverity, reader);
            Object object = reader.getBuildId();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"reader.buildId");
            return this.addMessage(this.createMessage(object, this.getMessageKind(severity), text, text), consumer);
        }
        return false;
    }

    private final String amendNextLinesIfNeeded(@NotNull String $receiver, BuildOutputInstantReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($receiver);
        while (nextLine != null) {
            if (this.isNextMessage(nextLine)) {
                reader.pushBack();
                break;
            }
            builder.append("\n").append(nextLine);
            nextLine = reader.readLine();
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNextMessage(@NotNull String $receiver) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$receiver, (String)this.COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            String string = $receiver;
            int n = 0;
            KotlincOutputParser kotlincOutputParser = this;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, colonIndex1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            if (kotlincOutputParser.startsWithSeverityPrefix(string4)) return true;
        }
        if (StringUtil.startsWith((CharSequence)$receiver, (CharSequence)"Note: ")) return true;
        if (StringUtil.startsWith((CharSequence)$receiver, (CharSequence)"> Task :")) return true;
        if (StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILED")) return false;
        return true;
    }

    private final boolean startsWithSeverityPrefix(@NotNull String $receiver) {
        return this.getMessageKind($receiver) != MessageEvent.Kind.SIMPLE;
    }

    private final MessageEvent.Kind getMessageKind(String kind) {
        MessageEvent.Kind kind2;
        switch (kind) {
            case "e": {
                kind2 = MessageEvent.Kind.ERROR;
                break;
            }
            case "w": {
                kind2 = MessageEvent.Kind.WARNING;
                break;
            }
            case "i": {
                kind2 = MessageEvent.Kind.INFO;
                break;
            }
            case "v": {
                kind2 = MessageEvent.Kind.SIMPLE;
                break;
            }
            default: {
                kind2 = MessageEvent.Kind.SIMPLE;
            }
        }
        return kind2;
    }

    private final String substringAfterAndTrim(@NotNull String $receiver, int index) {
        String string = $receiver;
        int n = index + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private final String substringBeforeAndTrim(@NotNull String $receiver, int index) {
        String string = $receiver;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private final int colon(@NotNull String $receiver) {
        return StringsKt.indexOf$default((CharSequence)$receiver, (String)this.COLON, (int)0, (boolean)false, (int)6, null);
    }

    private final int skipDriveOnWin(int $receiver, String line) {
        return $receiver == 1 ? StringsKt.indexOf$default((CharSequence)line, (String)this.COLON, (int)($receiver + 1), (boolean)false, (int)4, null) : $receiver;
    }

    private final boolean isKaptErrorWhileAnnotationProcessing(MessageEvent message) {
        if (message.getKind() != MessageEvent.Kind.ERROR) {
            return false;
        }
        String string = message.getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.message");
        String messageText = string;
        String string2 = IllegalStateException.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IllegalStateException::class.java.name");
        return StringsKt.startsWith$default((String)messageText, (String)string2, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)messageText, (CharSequence)this.KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT, (boolean)false, (int)2, null);
    }

    private final boolean addMessage(MessageEvent message, Consumer<? super MessageEvent> consumer) {
        if (this.isKaptErrorWhileAnnotationProcessing(message)) {
            return true;
        }
        consumer.accept((MessageEvent)message);
        return true;
    }

    private final MessageEvent createMessage(Object buildId, MessageEvent.Kind messageKind, String text, String detail) {
        String string = text;
        String string2 = COMPILER_MESSAGES_GROUP;
        MessageEvent.Kind kind = messageKind;
        Object object = buildId;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        String string5 = detail;
        String string6 = string4;
        String string7 = string2;
        MessageEvent.Kind kind2 = kind;
        Object object2 = object;
        return (MessageEvent)new MessageEventImpl(object2, kind2, string7, string6, string5);
    }

    private final FileMessageEventImpl createMessageWithLocation(Object buildId, MessageEvent.Kind messageKind, String text, String file, int lineNumber, int columnIndex, String detail) {
        String string = text;
        String string2 = COMPILER_MESSAGES_GROUP;
        MessageEvent.Kind kind = messageKind;
        Object object = buildId;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        FilePosition filePosition = new FilePosition(new File(file), lineNumber - 1, columnIndex - 1);
        String string5 = detail;
        String string6 = string4;
        String string7 = string2;
        MessageEvent.Kind kind2 = kind;
        Object object2 = object;
        return new FileMessageEventImpl(object2, kind2, string7, string6, string5, filePosition);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/build/output/KotlincOutputParser$Companion;", "", "()V", "COMPILER_MESSAGES_GROUP", "", "intellij.java.compiler.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

