/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.JavaCompilerElementRetriever;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public class JavaCompilerRefAdapter
implements LanguageCompilerRefAdapter {
    @Override
    @NotNull
    public Set<FileType> getFileTypes() {
        Set set = ContainerUtil.set((Object[])new FileType[]{JavaFileType.INSTANCE, JavaClassFileType.INSTANCE});
        if (set == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public CompilerRef asCompilerRef(@NotNull PsiElement element, @NotNull NameEnumerator names) throws IOException {
        if (element == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(1);
        }
        if (names == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(2);
        }
        if (JavaCompilerRefAdapter.mayBeVisibleOutsideOwnerFile(element)) {
            int nameId;
            String jvmClassName;
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                String name2 = field.getName();
                if (name2 == null || jvmOwnerName == null) {
                    return null;
                }
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                if (ownerId == 0) {
                    return null;
                }
                int nameId2 = names.tryEnumerate((Object)name2);
                if (nameId2 == 0) {
                    return null;
                }
                return new CompilerRef.JavaCompilerFieldRef(ownerId, nameId2);
            }
            if (element instanceof PsiMethod) {
                PsiClass aClass = ((PsiMethod)element).getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                if (jvmOwnerName == null) {
                    return null;
                }
                PsiMethod method = (PsiMethod)element;
                String name3 = method.isConstructor() ? "<init>" : method.getName();
                int parametersCount = method.getParameterList().getParametersCount();
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                if (ownerId == 0) {
                    return null;
                }
                int nameId3 = names.tryEnumerate((Object)name3);
                if (nameId3 == 0) {
                    return null;
                }
                return new CompilerRef.JavaCompilerMethodRef(ownerId, nameId3, parametersCount);
            }
            if (element instanceof PsiClass && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null && (nameId = names.tryEnumerate((Object)jvmClassName)) != 0) {
                return new CompilerRef.JavaCompilerClassRef(nameId);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<CompilerRef> getHierarchyRestrictedToLibraryScope(@NotNull CompilerRef baseRef, @NotNull PsiElement basePsi, @NotNull NameEnumerator names, @NotNull GlobalSearchScope libraryScope) throws IOException {
        if (baseRef == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(3);
        }
        if (basePsi == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(4);
        }
        if (names == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(5);
        }
        if (libraryScope == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(6);
        }
        PsiClass baseClass = (PsiClass)ObjectUtils.notNull((Object)(basePsi instanceof PsiClass ? (PsiClass)basePsi : ((PsiMember)ReadAction.compute(() -> (PsiMember)basePsi)).getContainingClass()));
        ArrayList<CompilerRef> overridden = new ArrayList<CompilerRef>();
        IOException[] exception = new IOException[]{null};
        Processor processor = c -> {
            if (c.hasModifierProperty("private")) {
                return true;
            }
            String qName = (String)ReadAction.compute(() -> c.getQualifiedName());
            if (qName == null) {
                return true;
            }
            try {
                int nameId = names.tryEnumerate((Object)qName);
                if (nameId != 0) {
                    overridden.add(baseRef.override(nameId));
                }
            }
            catch (IOException e) {
                exception[0] = e;
                return false;
            }
            return true;
        };
        ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)LibraryScopeCache.getInstance((Project)baseClass.getProject()).getLibrariesOnlyScope(), (boolean)true).forEach(processor);
        if (exception[0] != null) {
            throw exception[0];
        }
        ArrayList<CompilerRef> arrayList = overridden;
        if (arrayList == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Class<? extends CompilerRef.CompilerClassHierarchyElementDef> getHierarchyObjectClass() {
        if (CompilerRef.CompilerClassHierarchyElementDef.class == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(8);
        }
        return CompilerRef.CompilerClassHierarchyElementDef.class;
    }

    @Override
    @NotNull
    public Class<? extends CompilerRef> getFunExprClass() {
        if (CompilerRef.JavaCompilerFunExprDef.class == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(9);
        }
        return CompilerRef.JavaCompilerFunExprDef.class;
    }

    @NotNull
    public PsiClass[] findDirectInheritorCandidatesInFile(@NotNull SearchId[] internalNames, @NotNull PsiFileWithStubSupport file) {
        if (internalNames == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(10);
        }
        if (file == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(11);
        }
        PsiClass[] psiClassArray = JavaCompilerElementRetriever.retrieveClassesByInternalIds(internalNames, file);
        if (psiClassArray == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(12);
        }
        return psiClassArray;
    }

    @NotNull
    public PsiFunctionalExpression[] findFunExpressionsInFile(@NotNull SearchId[] funExpressions, @NotNull PsiFileWithStubSupport file) {
        if (funExpressions == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(13);
        }
        if (file == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(14);
        }
        TIntHashSet requiredIndices = new TIntHashSet(funExpressions.length);
        for (SearchId funExpr : funExpressions) {
            requiredIndices.add(funExpr.getId());
        }
        PsiFunctionalExpression[] psiFunctionalExpressionArray = JavaCompilerElementRetriever.retrieveFunExpressionsByIndices(requiredIndices, file);
        if (psiFunctionalExpressionArray == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(15);
        }
        return psiFunctionalExpressionArray;
    }

    @Override
    public boolean isClass(@NotNull PsiElement element) {
        if (element == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(16);
        }
        return element instanceof PsiClass;
    }

    @Override
    @NotNull
    public PsiElement[] getInstantiableConstructors(@NotNull PsiElement aClass) {
        if (aClass == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(17);
        }
        if (!(aClass instanceof PsiClass)) {
            throw new IllegalArgumentException("parameter should be an instance of PsiClass: " + aClass);
        }
        PsiClass theClass = (PsiClass)aClass;
        if (theClass.hasModifierProperty("abstract")) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JavaCompilerRefAdapter.$$$reportNull$$$0(18);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = (PsiElement[])Stream.of(theClass.getConstructors()).filter(c -> !c.hasModifierProperty("private")).toArray(s -> (PsiElement[])PsiElement.ARRAY_FACTORY.create(s));
        if (psiElementArray == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(19);
        }
        return psiElementArray;
    }

    @Override
    public boolean isDirectInheritor(PsiElement candidate, PsiNamedElement baseClass) {
        return ((PsiClass)candidate).isInheritor((PsiClass)baseClass, false);
    }

    private static boolean mayBeVisibleOutsideOwnerFile(@NotNull PsiElement element) {
        if (element == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(20);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return true;
        }
        return !((PsiModifierListOwner)element).hasModifierProperty("private");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/JavaCompilerRefAdapter";
                break;
            }
            case 1: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePsi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryScope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalNames";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpressions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaCompilerRefAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyRestrictedToLibraryScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyObjectClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunExprClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectInheritorCandidatesInFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunExpressionsInFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstantiableConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "asCompilerRef";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyRestrictedToLibraryScope";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findDirectInheritorCandidatesInFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findFunExpressionsInFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInstantiableConstructors";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mayBeVisibleOutsideOwnerFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

