/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SrcFileAnnotator
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.coverage.SrcFileAnnotator");
    public static final Key<List<RangeHighlighter>> COVERAGE_HIGHLIGHTERS = Key.create((String)"COVERAGE_HIGHLIGHTERS");
    private static final Key<DocumentListener> COVERAGE_DOCUMENT_LISTENER = Key.create((String)"COVERAGE_DOCUMENT_LISTENER");
    public static final Key<Map<FileEditor, EditorNotificationPanel>> NOTIFICATION_PANELS = Key.create((String)"NOTIFICATION_PANELS");
    private PsiFile myFile;
    private Editor myEditor;
    private Document myDocument;
    private final Project myProject;
    private SoftReference<TIntIntHashMap> myNewToOldLines;
    private SoftReference<TIntIntHashMap> myOldToNewLines;
    private SoftReference<byte[]> myOldContent;
    private static final Object LOCK = new Object();
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);

    public SrcFileAnnotator(PsiFile file, Editor editor) {
        this.myFile = file;
        this.myEditor = editor;
        this.myProject = file.getProject();
        this.myDocument = this.myEditor.getDocument();
    }

    public void hideCoverageData() {
        DocumentListener documentListener;
        Map map;
        Editor editor = this.myEditor;
        PsiFile file = this.myFile;
        Document document = this.myDocument;
        if (editor == null || editor.isDisposed() || file == null || document == null) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        List highlighters = (List)editor.getUserData(COVERAGE_HIGHLIGHTERS);
        if (highlighters != null) {
            for (RangeHighlighter highlighter : highlighters) {
                ApplicationManager.getApplication().invokeLater(() -> highlighter.dispose());
            }
            editor.putUserData(COVERAGE_HIGHLIGHTERS, null);
        }
        if ((map = (Map)file.getCopyableUserData(NOTIFICATION_PANELS)) != null) {
            VirtualFile vFile = SrcFileAnnotator.getVirtualFile(file);
            boolean freeAll = !fileEditorManager.isFileOpen(vFile);
            file.putCopyableUserData(NOTIFICATION_PANELS, null);
            for (FileEditor fileEditor : map.keySet()) {
                if (!freeAll && !this.isCurrentEditor(fileEditor)) continue;
                fileEditorManager.removeTopComponent(fileEditor, (JComponent)map.get(fileEditor));
            }
        }
        if ((documentListener = (DocumentListener)editor.getUserData(COVERAGE_DOCUMENT_LISTENER)) != null) {
            document.removeDocumentListener(documentListener);
            editor.putUserData(COVERAGE_DOCUMENT_LISTENER, null);
        }
    }

    @NotNull
    private static String[] getCoveredLines(@NotNull byte[] oldContent, VirtualFile vFile) {
        if (oldContent == null) {
            SrcFileAnnotator.$$$reportNull$$$0(0);
        }
        String text = LoadTextUtil.getTextByBinaryPresentation((byte[])oldContent, (VirtualFile)vFile, (boolean)false, (boolean)false).toString();
        String[] stringArray = LineTokenizer.tokenize((CharSequence)text, (boolean)false);
        if (stringArray == null) {
            SrcFileAnnotator.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    private static String[] getUpToDateLines(Document document) {
        Ref linesRef = new Ref();
        Runnable runnable = () -> {
            int lineCount = document.getLineCount();
            String[] lines = new String[lineCount];
            CharSequence chars = document.getCharsSequence();
            for (int i = 0; i < lineCount; ++i) {
                lines[i] = chars.subSequence(document.getLineStartOffset(i), document.getLineEndOffset(i)).toString();
            }
            linesRef.set((Object)lines);
        };
        ApplicationManager.getApplication().runReadAction(runnable);
        String[] stringArray = (String[])linesRef.get();
        if (stringArray == null) {
            SrcFileAnnotator.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    private static TIntIntHashMap getCoverageVersionToCurrentLineMapping(Diff.Change change, int firstNLines) {
        TIntIntHashMap result = new TIntIntHashMap();
        int prevLineInFirst = 0;
        int prevLineInSecond = 0;
        while (change != null) {
            for (int l = 0; l < change.line0 - prevLineInFirst; ++l) {
                result.put(prevLineInFirst + l, prevLineInSecond + l);
            }
            prevLineInFirst = change.line0 + change.deleted;
            prevLineInSecond = change.line1 + change.inserted;
            change = change.link;
        }
        for (int i = prevLineInFirst; i < firstNLines; ++i) {
            result.put(i, prevLineInSecond + i - prevLineInFirst);
        }
        return result;
    }

    @Nullable
    private TIntIntHashMap getOldToNewLineMapping(long date, MyEditorBean editorBean) {
        if (this.myOldToNewLines == null) {
            this.myOldToNewLines = this.doGetLineMapping(date, true, editorBean);
            if (this.myOldToNewLines == null) {
                return null;
            }
        }
        return (TIntIntHashMap)this.myOldToNewLines.get();
    }

    @Nullable
    private TIntIntHashMap getNewToOldLineMapping(long date, MyEditorBean editorBean) {
        if (this.myNewToOldLines == null) {
            this.myNewToOldLines = this.doGetLineMapping(date, false, editorBean);
            if (this.myNewToOldLines == null) {
                return null;
            }
        }
        return (TIntIntHashMap)this.myNewToOldLines.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SoftReference<TIntIntHashMap> doGetLineMapping(final long date, boolean oldToNew, MyEditorBean editorBean) {
        Diff.Change change;
        byte[] oldContent;
        VirtualFile virtualFile = editorBean.getVFile();
        if (this.myOldContent == null && ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.myOldContent == null) {
                LocalHistory localHistory = LocalHistory.getInstance();
                byte[] byteContent = localHistory.getByteContent(virtualFile, new FileRevisionTimestampComparator(){

                    public boolean isSuitable(long revisionTimestamp) {
                        return revisionTimestamp < date;
                    }
                });
                if (byteContent == null && virtualFile.getTimeStamp() > date) {
                    byteContent = this.loadFromVersionControl(date, virtualFile);
                }
                this.myOldContent = new SoftReference((Object)byteContent);
            }
            oldContent = (byte[])this.myOldContent.get();
        }
        if (oldContent == null) {
            return null;
        }
        Object[] coveredLines = SrcFileAnnotator.getCoveredLines(oldContent, virtualFile);
        Document document = editorBean.getDocument();
        if (document == null) {
            return null;
        }
        Object[] currentLines = SrcFileAnnotator.getUpToDateLines(document);
        Object[] oldLines = oldToNew ? coveredLines : currentLines;
        Object[] newLines = oldToNew ? currentLines : coveredLines;
        try {
            change = Diff.buildChanges((Object[])oldLines, (Object[])newLines);
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
            return null;
        }
        return new SoftReference((Object)SrcFileAnnotator.getCoverageVersionToCurrentLineMapping(change, oldLines.length));
    }

    @Nullable
    private byte[] loadFromVersionControl(long date, VirtualFile f) {
        try {
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.myProject, (VirtualFile)f);
            if (vcs == null) {
                return null;
            }
            VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
            if (historyProvider == null) {
                return null;
            }
            FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(f);
            VcsHistorySession session = historyProvider.createSessionFor(filePath2);
            if (session == null) {
                return null;
            }
            List list = session.getRevisionList();
            if (list != null) {
                for (VcsFileRevision revision : list) {
                    Date revisionDate = revision.getRevisionDate();
                    if (revisionDate == null) {
                        return null;
                    }
                    if (revisionDate.getTime() >= date) continue;
                    return revision.loadContent();
                }
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return null;
        }
        return null;
    }

    public void showCoverageInformation(final CoverageSuitesBundle suite) {
        TIntIntHashMap oldToNewLineMapping;
        final PsiFile psiFile = this.myFile;
        final Editor editor = this.myEditor;
        final Document document = this.myDocument;
        if (editor == null || psiFile == null || document == null) {
            return;
        }
        VirtualFile file = SrcFileAnnotator.getVirtualFile(psiFile);
        if (file == null || !file.isValid()) {
            return;
        }
        final MyEditorBean editorBean = new MyEditorBean(editor, file, document);
        final MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)this.myProject, (boolean)true);
        final ArrayList highlighters = new ArrayList();
        final ProjectData data = suite.getCoverageData();
        if (data == null) {
            this.coverageDataNotFound(suite);
            return;
        }
        final CoverageEngine engine = suite.getCoverageEngine();
        Set<String> qualifiedNames = engine.getQualifiedNames(psiFile);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        long fileTimeStamp = file.getTimeStamp();
        long coverageTimeStamp = suite.getLastCoverageTimeStamp();
        if (engine.isInLibraryClasses(this.myProject, file)) {
            return;
        }
        if (projectFileIndex.isInLibrarySource(file)) {
            if (fileTimeStamp > coverageTimeStamp) {
                this.showEditorWarningMessage(CodeInsightBundle.message((String)"coverage.data.outdated", (Object[])new Object[0]));
                return;
            }
            oldToNewLineMapping = null;
        } else {
            oldToNewLineMapping = this.getOldToNewLineMapping(coverageTimeStamp, editorBean);
            if (oldToNewLineMapping == null && fileTimeStamp > coverageTimeStamp && SrcFileAnnotator.classesArePresentInCoverageData(data, qualifiedNames)) {
                this.showEditorWarningMessage(CodeInsightBundle.message((String)"coverage.data.outdated", (Object[])new Object[0]));
                return;
            }
        }
        if (editor.getUserData(COVERAGE_HIGHLIGHTERS) != null) {
            return;
        }
        Module module2 = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        if (module2 != null && engine.recompileProjectAndRerunAction(module2, suite, () -> CoverageDataManager.getInstance(this.myProject).chooseSuitesBundle(suite))) {
            return;
        }
        Set<File> outputFiles = engine.getCorrespondingOutputFiles(psiFile, module2, suite);
        final boolean subCoverageActive = CoverageDataManager.getInstance(this.myProject).isSubCoverageActive();
        final boolean coverageByTestApplicable = suite.isCoverageByTestApplicable() && (!subCoverageActive || !suite.isCoverageByTestEnabled());
        final TreeMap executableLines = new TreeMap();
        final TreeMap classLines = new TreeMap();
        final TreeMap classNames = new TreeMap();
        class HighlightersCollector {
            HighlightersCollector() {
            }

            private void collect(File outputFile, String qualifiedName) {
                ClassData fileData = data.getClassData(qualifiedName);
                if (fileData != null) {
                    Object[] lines = fileData.getLines();
                    if (lines != null) {
                        Object[] postProcessedLines;
                        for (Object lineData : postProcessedLines = engine.postProcessExecutableLines(lines, editor)) {
                            int lineNumberInCurrent;
                            if (!(lineData instanceof LineData)) continue;
                            int line = ((LineData)lineData).getLineNumber() - 1;
                            if (oldToNewLineMapping != null) {
                                if (!oldToNewLineMapping.contains(line)) continue;
                                lineNumberInCurrent = oldToNewLineMapping.get(line);
                            } else {
                                lineNumberInCurrent = line;
                            }
                            if (engine.isGeneratedCode(SrcFileAnnotator.this.myProject, qualifiedName, lineData)) continue;
                            executableLines.put(line, (LineData)lineData);
                            classLines.put(line, postProcessedLines);
                            classNames.put(line, qualifiedName);
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (lineNumberInCurrent >= document.getLineCount()) {
                                    return;
                                }
                                if (editorBean.isDisposed()) {
                                    return;
                                }
                                RangeHighlighter highlighter = SrcFileAnnotator.this.createRangeHighlighter(suite.getLastCoverageTimeStamp(), markupModel, coverageByTestApplicable, executableLines, qualifiedName, line, lineNumberInCurrent, suite, postProcessedLines, editorBean);
                                highlighters.add(highlighter);
                            });
                        }
                    }
                } else if (outputFile != null && !subCoverageActive && engine.includeUntouchedFileInCoverage(qualifiedName, outputFile, psiFile, suite)) {
                    SrcFileAnnotator.this.collectNonCoveredFileInfo(outputFile, highlighters, markupModel, executableLines, coverageByTestApplicable, editorBean);
                }
            }
        }
        HighlightersCollector collector = new HighlightersCollector();
        if (!outputFiles.isEmpty()) {
            for (File outputFile : outputFiles) {
                String qualifiedName = engine.getQualifiedName(outputFile, psiFile);
                if (qualifiedName == null) continue;
                collector.collect(outputFile, qualifiedName);
            }
        } else {
            for (String qName : qualifiedNames) {
                collector.collect(null, qName);
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!editorBean.isDisposed() && highlighters.size() > 0) {
                editor.putUserData(COVERAGE_HIGHLIGHTERS, (Object)highlighters);
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SrcFileAnnotator.this.myNewToOldLines = null;
                SrcFileAnnotator.this.myOldToNewLines = null;
                ArrayList rangeHighlighters = (ArrayList)editor.getUserData(COVERAGE_HIGHLIGHTERS);
                if (rangeHighlighters == null) {
                    rangeHighlighters = new ArrayList();
                }
                int offset = e.getOffset();
                int lineNumber = document.getLineNumber(offset);
                int lastLineNumber = document.getLineNumber(offset + e.getNewLength());
                TextRange changeRange = new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lastLineNumber));
                Iterator it = rangeHighlighters.iterator();
                while (it.hasNext()) {
                    RangeHighlighter highlighter = (RangeHighlighter)it.next();
                    if (highlighter.isValid() && !TextRange.create((Segment)highlighter).intersects(changeRange)) continue;
                    highlighter.dispose();
                    it.remove();
                }
                ArrayList highlighters = rangeHighlighters;
                SrcFileAnnotator.this.myUpdateAlarm.cancelAllRequests();
                if (!SrcFileAnnotator.this.myUpdateAlarm.isDisposed()) {
                    SrcFileAnnotator.this.myUpdateAlarm.addRequest(() -> {
                        TIntIntHashMap newToOldLineMapping = SrcFileAnnotator.this.getNewToOldLineMapping(suite.getLastCoverageTimeStamp(), editorBean);
                        if (newToOldLineMapping != null) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (editorBean.isDisposed()) {
                                    return;
                                }
                                for (int line = lineNumber; line <= lastLineNumber; ++line) {
                                    int oldLineNumber = newToOldLineMapping.get(line);
                                    LineData lineData = (LineData)executableLines.get(oldLineNumber);
                                    if (lineData == null) continue;
                                    RangeHighlighter rangeHighlighter = SrcFileAnnotator.this.createRangeHighlighter(suite.getLastCoverageTimeStamp(), markupModel, coverageByTestApplicable, executableLines, (String)classNames.get(oldLineNumber), oldLineNumber, line, suite, (Object[])classLines.get(oldLineNumber), editorBean);
                                    highlighters.add(rangeHighlighter);
                                }
                                editor.putUserData(COVERAGE_HIGHLIGHTERS, (Object)(highlighters.size() > 0 ? highlighters : null));
                            });
                        }
                    }, 100);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/SrcFileAnnotator$2", "documentChanged"));
            }
        };
        document.addDocumentListener(documentListener);
        editor.putUserData(COVERAGE_DOCUMENT_LISTENER, (Object)documentListener);
    }

    private static boolean classesArePresentInCoverageData(ProjectData data, Set<String> qualifiedNames) {
        for (String qualifiedName : qualifiedNames) {
            if (data.getClassData(qualifiedName) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private RangeHighlighter createRangeHighlighter(long date, MarkupModel markupModel, boolean coverageByTestApplicable, TreeMap<Integer, LineData> executableLines, @Nullable String className, int line, int lineNumberInCurrent, @NotNull CoverageSuitesBundle coverageSuite, Object[] lines, @NotNull MyEditorBean myEditorBean) {
        LineData lineData;
        void editorBean;
        if (coverageSuite == null) {
            SrcFileAnnotator.$$$reportNull$$$0(3);
        }
        if (myEditorBean == null) {
            SrcFileAnnotator.$$$reportNull$$$0(4);
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(CoverageLineMarkerRenderer.getAttributesKey(line, executableLines));
        TextAttributes textAttributes = null;
        if (attributes.getBackgroundColor() != null) {
            textAttributes = attributes;
        }
        Document document = editorBean.getDocument();
        Editor editor = editorBean.getEditor();
        int startOffset = document.getLineStartOffset(lineNumberInCurrent);
        int endOffset = document.getLineEndOffset(lineNumberInCurrent);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 5999, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        Function newToOldConverter = arg_0 -> this.lambda$createRangeHighlighter$5(editor, date, (MyEditorBean)editorBean, arg_0);
        Function oldToNewConverter = arg_0 -> this.lambda$createRangeHighlighter$6(editor, date, (MyEditorBean)editorBean, arg_0);
        LineMarkerRendererWithErrorStripe markerRenderer = coverageSuite.getLineMarkerRenderer(line, className, executableLines, coverageByTestApplicable, coverageSuite, (Function<Integer, Integer>)newToOldConverter, (Function<Integer, Integer>)oldToNewConverter, CoverageDataManager.getInstance(this.myProject).isSubCoverageActive());
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)markerRenderer);
        LineData lineData2 = lineData = className != null ? (LineData)lines[line + 1] : null;
        if (lineData != null && lineData.getStatus() == 0) {
            highlighter.setErrorStripeMarkColor(markerRenderer.getErrorStripeColor(editor));
            highlighter.setThinErrorStripeMark(true);
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
        return highlighter;
    }

    private void showEditorWarningMessage(final String message) {
        Editor textEditor = this.myEditor;
        PsiFile file = this.myFile;
        ApplicationManager.getApplication().invokeLater(() -> {
            FileEditor[] editors;
            if (textEditor == null || textEditor.isDisposed() || file == null) {
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            VirtualFile vFile = file.getVirtualFile();
            assert (vFile != null);
            HashMap<FileEditor, 3> map = (HashMap<FileEditor, 3>)file.getCopyableUserData(NOTIFICATION_PANELS);
            if (map == null) {
                map = new HashMap<FileEditor, 3>();
                file.putCopyableUserData(NOTIFICATION_PANELS, map);
            }
            for (FileEditor editor : editors = fileEditorManager.getAllEditors(vFile)) {
                if (!this.isCurrentEditor(editor)) continue;
                EditorNotificationPanel panel = new EditorNotificationPanel(){
                    {
                        this.myLabel.setIcon(AllIcons.General.ExclMark);
                        this.myLabel.setText(message);
                    }
                };
                panel.createActionLabel("Close", () -> fileEditorManager.removeTopComponent(editor, (JComponent)panel));
                map.put(editor, panel);
                fileEditorManager.addTopComponent(editor, (JComponent)panel);
                break;
            }
        });
    }

    private boolean isCurrentEditor(FileEditor editor) {
        return editor instanceof TextEditor && ((TextEditor)editor).getEditor() == this.myEditor;
    }

    private void collectNonCoveredFileInfo(File outputFile, List<RangeHighlighter> highlighters, MarkupModel markupModel, TreeMap<Integer, LineData> executableLines, boolean coverageByTestApplicable, @NotNull MyEditorBean editorBean) {
        TIntIntHashMap mapping;
        CoverageSuitesBundle coverageSuite;
        if (editorBean == null) {
            SrcFileAnnotator.$$$reportNull$$$0(5);
        }
        if ((coverageSuite = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle()) == null) {
            return;
        }
        Document document = editorBean.getDocument();
        VirtualFile file = editorBean.getVFile();
        if (outputFile.lastModified() < file.getTimeStamp()) {
            mapping = this.getOldToNewLineMapping(outputFile.lastModified(), editorBean);
            if (mapping == null) {
                return;
            }
        } else {
            mapping = null;
        }
        List<Integer> uncoveredLines = coverageSuite.getCoverageEngine().collectSrcLinesForUntouchedFile(outputFile, coverageSuite);
        int lineCount = document.getLineCount();
        if (uncoveredLines == null) {
            for (int lineNumber = 0; lineNumber < lineCount; ++lineNumber) {
                this.addHighlighter(outputFile, highlighters, markupModel, executableLines, coverageByTestApplicable, coverageSuite, lineNumber, lineNumber, editorBean);
            }
        } else {
            for (int lineNumber : uncoveredLines) {
                if (lineNumber >= lineCount) continue;
                int updatedLineNumber = mapping != null ? mapping.get(lineNumber) : lineNumber;
                this.addHighlighter(outputFile, highlighters, markupModel, executableLines, coverageByTestApplicable, coverageSuite, lineNumber, updatedLineNumber, editorBean);
            }
        }
    }

    private void addHighlighter(File outputFile, List<RangeHighlighter> highlighters, MarkupModel markupModel, TreeMap<Integer, LineData> executableLines, boolean coverageByTestApplicable, CoverageSuitesBundle coverageSuite, int lineNumber, int updatedLineNumber, @NotNull MyEditorBean editorBean) {
        if (editorBean == null) {
            SrcFileAnnotator.$$$reportNull$$$0(6);
        }
        executableLines.put(updatedLineNumber, null);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editorBean.isDisposed()) {
                return;
            }
            RangeHighlighter highlighter = this.createRangeHighlighter(outputFile.lastModified(), markupModel, coverageByTestApplicable, executableLines, null, lineNumber, updatedLineNumber, coverageSuite, null, editorBean);
            highlighters.add(highlighter);
        });
    }

    private static VirtualFile getVirtualFile(PsiFile file) {
        VirtualFile vFile = file.getVirtualFile();
        LOG.assertTrue(vFile != null);
        return vFile;
    }

    private void coverageDataNotFound(CoverageSuitesBundle suite) {
        this.showEditorWarningMessage(CodeInsightBundle.message((String)"coverage.data.not.found", (Object[])new Object[0]));
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            CoverageDataManager.getInstance(this.myProject).removeCoverageSuite(coverageSuite);
        }
    }

    public void dispose() {
        this.hideCoverageData();
        this.myEditor = null;
        this.myDocument = null;
        this.myFile = null;
    }

    private /* synthetic */ Integer lambda$createRangeHighlighter$6(Editor editor, long date, MyEditorBean editorBean, Integer newLine) {
        if (editor == null) {
            return -1;
        }
        TIntIntHashMap newLineMapping = this.getOldToNewLineMapping(date, editorBean);
        return newLineMapping != null ? newLineMapping.get(newLine.intValue()) : newLine.intValue();
    }

    private /* synthetic */ Integer lambda$createRangeHighlighter$5(Editor editor, long date, MyEditorBean editorBean, Integer newLine) {
        if (editor == null) {
            return -1;
        }
        TIntIntHashMap oldLineMapping = this.getNewToOldLineMapping(date, editorBean);
        return oldLineMapping != null ? oldLineMapping.get(newLine.intValue()) : newLine.intValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/SrcFileAnnotator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/SrcFileAnnotator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredLines";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpToDateLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredLines";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRangeHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectNonCoveredFileInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyEditorBean {
        private final Editor myEditor;
        private final VirtualFile myVFile;
        private final Document myDocument;

        MyEditorBean(Editor editor, VirtualFile VFile, Document document) {
            this.myEditor = editor;
            this.myVFile = VFile;
            this.myDocument = document;
        }

        public boolean isDisposed() {
            return this.myEditor == null || this.myEditor.isDisposed() || this.myVFile == null || this.myDocument == null;
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public Editor getEditor() {
            return this.myEditor;
        }

        public VirtualFile getVFile() {
            return this.myVFile;
        }
    }
}

