/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaFramesListRenderer {
    JavaFramesListRenderer() {
    }

    public static void customizePresentation(StackFrameDescriptorImpl descriptor2, @NotNull ColoredTextContainer component, @Nullable StackFrameDescriptorImpl selectedDescriptor) {
        String label;
        int openingBrace;
        if (component == null) {
            JavaFramesListRenderer.$$$reportNull$$$0(0);
        }
        component.setIcon(descriptor2.getIcon());
        ValueMarkup markup = descriptor2.getValueMarkup();
        if (markup != null) {
            component.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        int closingBrace = (openingBrace = (label = descriptor2.getLabel()).indexOf("{")) < 0 ? -1 : label.indexOf("}");
        SimpleTextAttributes attributes = JavaFramesListRenderer.getAttributes(descriptor2);
        if (openingBrace < 0 || closingBrace < 0) {
            component.append(label, attributes);
        } else {
            component.append(label.substring(0, openingBrace - 1), attributes);
            component.append(" (" + label.substring(openingBrace + 1, closingBrace) + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            component.append(label.substring(closingBrace + 1), attributes);
        }
        if (JavaFramesListRenderer.isOccurrenceOfSelectedFrame(selectedDescriptor, descriptor2) && descriptor2.isRecursiveCall()) {
            component.append(" [" + descriptor2.getOccurrenceIndex() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private static boolean isOccurrenceOfSelectedFrame(@Nullable StackFrameDescriptorImpl selectedDescriptor, @NotNull StackFrameDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            JavaFramesListRenderer.$$$reportNull$$$0(1);
        }
        Method method = descriptor2.getMethod();
        return selectedDescriptor != null && method != null && method.equals(selectedDescriptor.getMethod());
    }

    private static SimpleTextAttributes getAttributes(StackFrameDescriptorImpl descriptor2) {
        if (descriptor2.isSynthetic() || descriptor2.isInLibraryContent()) {
            return SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaFramesListRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizePresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isOccurrenceOfSelectedFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

